/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.animation.VJoint;
import hmi.bml.core.HeadBehaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.ElckerlycRealizer;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SpeechPlannerFactory;
import hmi.elckerlyc.TTSPlannerFactory;
import hmi.elckerlyc.TextPlannerFactory;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.gesturebinding.GestureBinding;
import hmi.elckerlyc.animationengine.gesturebinding.SpeechBinding;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SystemSchedulingClock;
import hmi.elckerlyc.speechengine.DirectTTSUnitFactory;
import hmi.elckerlyc.speechengine.SpeechPlanner;
import hmi.elckerlyc.speechengine.WavTTSUnitFactory;
import hmi.elckerlyc.util.MaryTTSBindingFactory;
import hmi.elckerlyc.util.SAPITTSBindingFactory;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.ode.OdeHumanoid;
import hmi.testutil.LabelledParameterized;
import hmi.testutil.animation.HanimBody;
import hmi.testutil.bml.feedback.FeedbackAsserts;
import hmi.tts.util.NullPhonemeToVisemeMapping;
import hmi.tts.util.PhonemeToVisemeMapping;
import hmi.util.Resources;
import hmi.util.SystemClock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.odejava.Odejava;

@RunWith(value=LabelledParameterized.class)
public class SchedulerParameterizedTest {
    protected Resources res;
    protected ElckerlycRealizer realizer;
    protected ArrayList<BMLWarningFeedback> warnings;
    protected ArrayList<BMLExceptionFeedback> exceptions;
    private Planner speechPlanner;
    private Planner aPlanner;
    private Set<String> invBeh;
    protected BMLScheduler scheduler;

    @After
    public void cleanup() {
        this.realizer.shutdown();
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        Odejava.init();
    }

    @AfterClass
    public static void oneTimeCleanup() {
        Odejava.close();
    }

    private void assertNoWarnings() {
        Assert.assertTrue((String)("Unexpected warning(s): " + this.warnings), (this.warnings.size() == 0 ? 1 : 0) != 0);
    }

    private void assertNoExceptions() {
        Assert.assertTrue((String)("Unexpected exceptions(s): " + this.exceptions), (this.exceptions.size() == 0 ? 1 : 0) != 0);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() throws Exception {
        ArrayList<SpeechPlannerFactory> speechPlannersFactories = new ArrayList<SpeechPlannerFactory>();
        speechPlannersFactories.add(new TTSPlannerFactory(DirectTTSUnitFactory.getFactory(), new SAPITTSBindingFactory()));
        speechPlannersFactories.add(new TTSPlannerFactory(WavTTSUnitFactory.getFactory(), new SAPITTSBindingFactory()));
        speechPlannersFactories.add(new TTSPlannerFactory(WavTTSUnitFactory.getFactory(), new MaryTTSBindingFactory("../../Shared/repository/MARYTTS", (PhonemeToVisemeMapping)new NullPhonemeToVisemeMapping())));
        speechPlannersFactories.add(new TextPlannerFactory());
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        for (SpeechPlannerFactory sp : speechPlannersFactories) {
            Object[] obj = new Object[]{"SpeechPlanner = " + sp.getType(), sp};
            objs.add(obj);
        }
        return objs;
    }

    public SchedulerParameterizedTest(String label, SpeechPlannerFactory sv) throws IOException {
        SpeechPlanner vp = sv.createPlanner();
        VJoint human = HanimBody.getLOA1HanimBody();
        ArrayList<MixedSystem> m = new ArrayList<MixedSystem>();
        float[] g = new float[]{0.0f, 0.0f, 0.0f};
        OdeHumanoid p = new OdeHumanoid("phuman", null, null);
        m.add(new MixedSystem(g, (PhysicalHumanoid)p));
        Resources gres = new Resources("");
        GestureBinding gestureBinding = new GestureBinding(gres);
        gestureBinding.readXML(gres.getReader("gesturebinding/gesturebinding.xml"));
        SpeechBinding speechBinding = new SpeechBinding(gres);
        speechBinding.readXML(gres.getReader("speechbinding/disneyspeechbinding.xml"));
        AnimationPlayer aPlayer = new AnimationPlayer(human, human, human, human, m, 0.001f);
        AnimationPlanner ap = new AnimationPlanner(aPlayer, gestureBinding, speechBinding);
        SystemClock clock = new SystemClock();
        clock.setMediaSeconds(0.3);
        this.realizer = new ElckerlycRealizer(new SystemSchedulingClock(clock), ap, vp);
        this.res = new Resources("bmltest");
        this.warnings = new ArrayList();
        this.exceptions = new ArrayList();
        this.realizer.setWarningListener(new MyWarningListener());
        this.realizer.setExceptionListener(new MyExceptionListener());
        this.scheduler = this.realizer.getScheduler();
        this.scheduler.addAnticipator("dummyanticipator", new DummyAnticipator());
    }

    private void readXML(String file) {
        try {
            this.realizer.scheduleBML(this.res.getReader(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test(timeout=10000L)
    public void timepegTestSpeechEndTimed() {
        this.readXML("testspeech_endtimed.xml");
        this.scheduler.getPegBoard().getTimePeg("end", "speech1", "bml1").setGlobalValue(6.0);
        this.speechPlanner = this.realizer.getPlanner(SpeechBehaviour.class);
        this.invBeh = this.speechPlanner.getInvalidBehaviours();
        Assert.assertEquals((long)0L, (long)this.invBeh.size());
    }

    @Test(timeout=10000L)
    public void timepegTestNod() {
        this.readXML("testnod.xml");
        TimePeg nod1Start = this.scheduler.getPegBoard().getTimePeg("start", "nod1", "bml1");
        nod1Start.setGlobalValue(1.0);
        this.aPlanner = this.realizer.getPlanner(HeadBehaviour.class);
        this.invBeh = this.aPlanner.getInvalidBehaviours();
        Assert.assertEquals((long)0L, (long)this.invBeh.size());
        Assert.assertEquals((double)1.0, (double)nod1Start.getGlobalValue(), (double)0.001f);
    }

    @Test(timeout=10000L)
    public void timepegTestSpeechSyncTimed() {
        this.readXML("testspeech_synctimed.xml");
        this.assertNoExceptions();
        this.assertNoWarnings();
        this.scheduler.getPegBoard().getTimePeg("s1", "speech1", "bml1").setGlobalValue(15.0);
        this.speechPlanner = this.realizer.getPlanner(SpeechBehaviour.class);
        this.invBeh = this.speechPlanner.getInvalidBehaviours();
        Assert.assertEquals((long)0L, (long)this.invBeh.size());
        this.scheduler.getPegBoard().getTimePeg("start", "speech1", "bml1").setGlobalValue(15.0);
        this.speechPlanner = this.realizer.getPlanner(SpeechBehaviour.class);
        this.invBeh = this.speechPlanner.getInvalidBehaviours();
        Assert.assertTrue((this.invBeh.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") == 15.0 ? 1 : 0) != 0);
    }

    @Ignore
    @Test(timeout=10000L)
    public void timepegTestSpeechAndNodSyncTimed() {
        this.readXML("testspeechandnod_synctimed.xml");
        this.assertNoExceptions();
        this.assertNoWarnings();
        double speechStartOrig = this.scheduler.getPegBoard().getTimePeg("start", "speech1", "bml1").getLocalValue();
        Assert.assertTrue((speechStartOrig < 10.0 ? 1 : 0) != 0);
        this.scheduler.getPegBoard().getTimePeg("s1", "speech1", "bml1").setGlobalValue(15.0);
        this.speechPlanner = this.realizer.getPlanner(SpeechBehaviour.class);
        this.invBeh = this.speechPlanner.getInvalidBehaviours();
        Assert.assertTrue((this.invBeh.size() == 0 ? 1 : 0) != 0);
        Planner animationPlanner = this.realizer.getPlanner(HeadBehaviour.class);
        this.invBeh = animationPlanner.getInvalidBehaviours();
        Assert.assertTrue((this.invBeh.size() == 0 ? 1 : 0) != 0);
        double speechStartNew = this.scheduler.getPegBoard().getTimePeg("start", "speech1", "bml1").getGlobalValue();
        Assert.assertTrue((speechStartNew - speechStartOrig == 5.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void bmltDummyAnticipatorTest() {
        this.readXML("bmlt/testanticipatedspeech.xml");
        this.assertNoExceptions();
        this.assertNoWarnings();
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") == 21.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void bmltDummyAnticipatorTestOffset() {
        this.readXML("bmlt/testanticipatedspeech_offset.xml");
        this.assertNoExceptions();
        this.assertNoWarnings();
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") == 22.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void bmltConstraintAnticipatorTest() {
        Anticipator antip = new Anticipator();
        this.realizer.addAnticipator("anticipator1", antip);
        TimePeg s1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        s1.setGlobalValue(1.0);
        antip.addSynchronisationPoint("sync1", s1);
        TimePeg s2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        s2.setGlobalValue(2.0);
        antip.addSynchronisationPoint("sync2", s2);
        TimePeg s3 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        s3.setGlobalValue(3.0);
        antip.addSynchronisationPoint("sync3", s3);
        TimePeg s4 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        s4.setGlobalValue(4.0);
        antip.addSynchronisationPoint("sync4", s4);
        this.readXML("bmlt/testanticipator.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod1", "bml1") == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1") == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1") == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod2", "bml1") == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod2", "bml1") == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod3", "bml1") == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod3", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getTimePeg("end", "nod1", "bml1") == this.scheduler.getPegBoard().getTimePeg("start", "nod2", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getTimePeg("end", "nod2", "bml1") == this.scheduler.getPegBoard().getTimePeg("start", "nod3", "bml1") ? 1 : 0) != 0);
        antip.getSynchronisationPoint("sync2").setGlobalValue(2.2);
        antip.getSynchronisationPoint("sync3").setGlobalValue(3.2);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1") == 2.2 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod2", "bml1") == 2.2 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "nod2", "bml1") == 3.2 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod3", "bml1") == 3.2 ? 1 : 0) != 0);
        this.realizer.removeAnticipator("anticipator1");
        Assert.assertTrue((this.realizer.getScheduler().getNumberOfAnticipators() == 1 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void bmltConstraintTest() {
        this.readXML("bmlt/test_speech_syncs.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1"), (double)2.0, (double)1.0E-4);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("tm1", "speech1", "bml1") - this.scheduler.getPegBoard().getPegTime("stroke-end", "ref1", "bml1") < 0.001 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeech3x() {
        this.readXML("testspeech3x.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech10", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "speech11", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "speech10", "bml1") + 4.0), (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "speech12", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "speech11", "bml1") + 4.0), (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testSpeechRelOffsets() {
        this.readXML("testspeechrel_offsets.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        double speech1Start = this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1");
        Assert.assertTrue((speech1Start == 4.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "speech2", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "speech1", "bml1") + 5.0), (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod2", "bml1"), (double)(speech1Start - 2.0), (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("end", "nod2", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "speech2", "bml1") + 3.0), (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testNodOffset() {
        this.readXML("testnod_offset.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod2", "bml1"), (double)2.0, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testTimeShift() {
        this.readXML("testtimeshift.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1"), (double)this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1"), (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testNodInvalidTime() {
        this.readXML("testnod_invalidtime.xml");
        this.assertNoWarnings();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add("nod1");
        BMLExceptionFeedback ex = new BMLExceptionFeedback("", "bml1", 0.0, failedBehaviours, new HashSet(), "", false);
        FeedbackAsserts.assertEqualException((BMLExceptionFeedback)ex, (BMLExceptionFeedback)this.exceptions.get(0));
    }

    @Test(timeout=10000L)
    public void testSpeechInvalidTime() {
        this.readXML("testspeech_invalidtime.xml");
        Assert.assertThat(this.realizer.getScheduler().getBehaviours("bml1"), (Matcher)Matchers.empty());
        this.assertNoWarnings();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add("speech1");
        BMLExceptionFeedback ex = new BMLExceptionFeedback("", "bml1", 0.0, failedBehaviours, new HashSet(), "", false);
        FeedbackAsserts.assertEqualException((BMLExceptionFeedback)ex, (BMLExceptionFeedback)this.exceptions.get(0));
    }

    @Test(timeout=10000L)
    public void testNodAbsolute() {
        this.readXML("testnod_absolute.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "nod1", "bml1"), (double)2.0, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testNod2xAbsolute() {
        this.readXML("testnod2x_absolute.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1") == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod2", "bml1") == 3.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechEndTimed() {
        this.readXML("testspeech_endtimed.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "speech1", "bml1") == 5.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testNod() {
        this.readXML("testnod.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1") == 0.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testNodUnknownAttributes() {
        this.readXML("testnod_unknownattributes.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1") == 0.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechEndTimed2() {
        this.readXML("testspeech_endtimed2.xml");
        this.assertNoWarnings();
        Assert.assertEquals((long)1L, (long)this.exceptions.size());
        Assert.assertThat(this.realizer.getScheduler().getBehaviours("bml1"), (Matcher)Matchers.empty());
    }

    @Test(timeout=10000L)
    public void testSpeech2Linked() {
        this.readXML("testspeech_2linked.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "speech2", "bml1"), (double)this.scheduler.getPegBoard().getPegTime("end", "speech1", "bml1"), (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testOffset2() {
        this.readXML("testoffset2.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g1", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g2", "bml1") == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "g2", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h1", "bml1") == this.scheduler.getPegBoard().getPegTime("end", "g1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h1", "bml1") > 4.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testOffset3() {
        this.readXML("testoffset3.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g1", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g2", "bml1") == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "g2", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h1", "bml1") == this.scheduler.getPegBoard().getPegTime("end", "g1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h1", "bml1") > 4.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "gaze1", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("end", "gaze1", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "g1", "bml1") + 3.0), (double)1.0E-4);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "gaze1", "bml1") > 7.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testOffsetChain() {
        this.readXML("testoffsetchain.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h1", "bml1") == 4.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h2", "bml1") == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h3", "bml1") == 8.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h4", "bml1") == 10.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testOffsetChainReversed() {
        this.readXML("testoffsetchainreversed.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h1", "bml1"), (double)4.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h2", "bml1"), (double)6.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h3", "bml1"), (double)8.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h4", "bml1"), (double)10.0, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testEmpty() {
        this.readXML("empty.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertThat(this.realizer.getScheduler().getBehaviours("bml1"), (Matcher)Matchers.empty());
    }

    @Test(timeout=10000L)
    public void testSpeechInvalidTimeSync() {
        this.readXML("testspeech_invalidtimesync.xml");
        this.assertNoWarnings();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add("speech1");
        BMLExceptionFeedback ex = new BMLExceptionFeedback("", "bml1", 0.0, failedBehaviours, new HashSet(), "", false);
        FeedbackAsserts.assertEqualException((BMLExceptionFeedback)ex, (BMLExceptionFeedback)this.exceptions.get(0));
    }

    @Test(timeout=10000L)
    @Ignore
    public void testSpeechInvalidTimeSync2() {
        this.readXML("testspeech_invalidtimesync2.xml");
        this.assertNoWarnings();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add("speech1");
        BMLExceptionFeedback ex = new BMLExceptionFeedback("", "bml1", 0.0, failedBehaviours, new HashSet(), "", false);
        FeedbackAsserts.assertEqualException((BMLExceptionFeedback)ex, (BMLExceptionFeedback)this.exceptions.get(0));
        Assert.assertThat(this.realizer.getScheduler().getBehaviours("bml1"), (Matcher)Matchers.empty());
    }

    @Test(timeout=10000L)
    public void testSpeechSyncTimed() {
        this.readXML("testspeech_synctimed.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "s1", "speech1", "bml1") == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1") < 10.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechSyncTimed2x() {
        this.readXML("testspeech_synctimed2x.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "s1", "speech1", "bml1") == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1") < 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "s1", "speech2", "bml1") == 20.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech2", "bml1") < 20.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechAndNodSyncTimed() {
        this.readXML("testspeechandnod_synctimed.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") == this.scheduler.getPegBoard().getPegTime("start", "nod1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "s1", "speech1", "bml1") == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1") < 10.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechSyncAtStart() {
        this.readXML("testspeech_syncatstart.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "welkom", "bml1"), (double)0.0, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testSpeechSyncAtStartAndToBeat() {
        this.readXML("testspeech_syncatstartandtobeat.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)0.0, (double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "welkom", "bml1"), (double)0.001);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "g1", "bml1"), (double)this.scheduler.getPegBoard().getPegTime("deicticheart1", "welkom", "bml1"), (double)0.001);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("end", "g1", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("deicticheart1", "welkom", "bml1") + 1.0), (double)0.001);
    }

    @Test(timeout=10000L)
    public void testSpeechUnknownSync() {
        this.readXML("testspeech_unknownsync.xml");
        this.assertNoExceptions();
        Assert.assertTrue((this.warnings.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "welkom", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertTrue((boolean)this.warnings.get((int)0).bmlId.equals("bml1"));
        Assert.assertTrue((boolean)this.warnings.get((int)0).id.equals("w-welkom"));
        Assert.assertTrue((this.warnings.get((int)0).modifiedBehaviours.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.warnings.get((int)0).modifiedConstraints.size() == 0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testAbs() {
        this.readXML("testabs.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1") == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g1", "bml1") == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1") == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getTimePeg("start", "speech1", "bml1") != this.scheduler.getPegBoard().getTimePeg("start", "g1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getTimePeg("start", "speech1", "bml1") != this.scheduler.getPegBoard().getTimePeg("start", "nod1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getTimePeg("start", "g1", "bml1") != this.scheduler.getPegBoard().getTimePeg("start", "nod1", "bml1") ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testOffsetChainNeg() {
        this.readXML("testoffsetchainneg.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h1", "bml1") == this.scheduler.getPegBoard().getPegTime("s1", "speech1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "h1", "bml1") > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "h1", "bml1") == this.scheduler.getPegBoard().getPegTime("start", "h2", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h2", "bml1") > this.scheduler.getPegBoard().getPegTime("start", "h1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h3", "bml1") == this.scheduler.getPegBoard().getPegTime("end", "h2", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h3", "bml1") > this.scheduler.getPegBoard().getPegTime("start", "h2", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h4", "bml1") == this.scheduler.getPegBoard().getPegTime("end", "h3", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "h4", "bml1") > this.scheduler.getPegBoard().getPegTime("start", "h3", "bml1") ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testBMLNoId() {
        this.readXML("bmlnoid.xml");
        Assert.assertTrue((this.exceptions.size() == 1 ? 1 : 0) != 0);
        this.assertNoWarnings();
        BMLExceptionFeedback be = this.exceptions.get(0);
        Assert.assertTrue((boolean)be.performanceFailed);
    }

    @Test(timeout=10000L)
    public void testbeatreadytimed() {
        this.readXML("testbeatreadytimed.xml");
        this.assertNoExceptions();
        this.assertNoWarnings();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "beat1", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "ready", "beat1", "bml1"), (double)2.0, (double)1.0E-4);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("end", "beat1", "bml1") > this.scheduler.getPegBoard().getPegTime("ready", "beat1", "bml1") ? 1 : 0) != 0);
    }

    @Ignore
    @Test(timeout=10000L)
    public void testOffsetGazeTimed() {
        this.readXML("testoffsetgaze.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "gaze1", "bml1") == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") == this.scheduler.getPegBoard().getPegTime("ready", "gaze1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "speech1", "bml1") > 2.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testNods() {
        this.readXML("testnods.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getPegTime("start", "tilt1", "bml1"), (double)(this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1") + 1.0), (double)1.0E-4);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("start", "nod1", "bml1") < this.scheduler.getPegBoard().getPegTime("end", "nod1", "bml1") ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechNodTimedToSync() {
        this.readXML("testspeech_nodtimedtosync.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1") == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("syncstart1", "speech1", "bml1") == this.scheduler.getPegBoard().getPegTime("start", "nod1", "bml1") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "nod1", "bml1") == 9.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testSpeechNodTimedToSyncCapitalization() {
        this.readXML("testspeech_nodtimedtosync_capitalization.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("BMLWithCapitalizedStuff", "start", "speech1WithCapitalizedStuff", "BMLWithCapitalizedStuff") == 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getPegTime("syncStart_1", "speech1WithCapitalizedStuff", "BMLWithCapitalizedStuff") == this.scheduler.getPegBoard().getPegTime("start", "nod1WithCapitalizedStuff", "BMLWithCapitalizedStuff") ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("BMLWithCapitalizedStuff", "end", "nod1WithCapitalizedStuff", "BMLWithCapitalizedStuff") == 9.0 ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testNodAndBeat() {
        this.readXML("testnodandbeat.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1") == 3.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "nod1", "bml1") == 5.0 ? 1 : 0) != 0);
        Assert.assertTrue((this.scheduler.getPegBoard().getRelativePegTime("bml1", "stroke", "nod1", "bml1") == this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "beat1", "bml1") ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testBeatAndNod() {
        this.readXML("testbeatandnod.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)3.0, (double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "beat1", "bml1"), (double)0.001f);
        Assert.assertEquals((double)5.0, (double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "beat1", "bml1"), (double)0.001f);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "stroke_end", "beat1", "bml1"), (double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "nod1", "bml1"), (double)0.001f);
    }

    @Test(timeout=10000L)
    public void testSpeechNodTimedToSyncOffset() {
        this.readXML("testspeech_nodtimedtosyncoffset.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "speech1", "bml1"), (double)6.0, (double)1.0E-4);
        Assert.assertEquals((double)(this.scheduler.getPegBoard().getPegTime("syncstart1", "speech1", "bml1") + 1.0), (double)this.scheduler.getPegBoard().getPegTime("start", "nod1", "bml1"), (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "nod1", "bml1"), (double)9.0, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testSpeechGestures() {
        this.readXML("testspeechgestures.xml");
        this.assertNoWarnings();
        this.assertNoExceptions();
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "deicticheart1", "welkom", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "transleft", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "g1", "bml1"), (double)1.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "transleft", "bml1"), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "g1", "bml1"), (double)2.0, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "start", "relaxleft", "bml1"), (double)2.5, (double)1.0E-4);
        Assert.assertEquals((double)this.scheduler.getPegBoard().getRelativePegTime("bml1", "end", "relaxleft", "bml1"), (double)2.8, (double)1.0E-4);
    }

    @Test(timeout=10000L)
    public void testInvalidXML() {
        this.readXML("testinvalidxml.xml");
        Assert.assertTrue((this.exceptions.size() == 1 ? 1 : 0) != 0);
        this.assertNoWarnings();
    }

    @Test(timeout=10000L)
    public void testInvalidXML2() {
        this.readXML("testinvalidxml2.xml");
        Assert.assertTrue((this.exceptions.size() == 1 ? 1 : 0) != 0);
        this.assertNoWarnings();
    }

    @Ignore
    @Test(timeout=10000L)
    public void testGazeReadyTimed() {
    }

    @Ignore
    @Test(timeout=10000L)
    public void testOffset() {
    }

    static class DummyAnticipator
    extends Anticipator {
        TimePeg sp = new TimePeg(BMLBlockPeg.GLOBALPEG);

        public DummyAnticipator() {
            this.sp.setGlobalValue(21.0);
            this.addSynchronisationPoint("dummy", this.sp);
        }
    }

    class MyExceptionListener
    implements BMLExceptionListener {
        MyExceptionListener() {
        }

        public void exception(BMLExceptionFeedback be) {
            SchedulerParameterizedTest.this.exceptions.add(be);
        }
    }

    class MyWarningListener
    implements BMLWarningListener {
        MyWarningListener() {
        }

        public void warn(BMLWarningFeedback bw) {
            SchedulerParameterizedTest.this.warnings.add(bw);
        }
    }
}

