/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PegBoard;
import hmi.elckerlyc.TimePeg;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class PegBoardTest {
    @Test
    public void testAddTimePeg() {
        PegBoard pb = new PegBoard();
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(10.0);
        pb.addTimePeg("start", "beh1", "bml1", tp);
        Assert.assertEquals((Object)tp, (Object)pb.getTimePeg("start", "beh1", "bml1"));
    }

    @Test
    public void testGetTimedSyncs() {
        PegBoard pb = new PegBoard();
        TimePeg tp = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp.setGlobalValue(10.0);
        pb.addTimePeg("start", "beh1", "bml1", tp);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pb.addTimePeg("stroke", "beh1", "bml1", tp2);
        TimePeg tp3 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp3.setGlobalValue(1.0);
        pb.addTimePeg("stroke-end", "beh1", "bml2", tp3);
        TimePeg tp4 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp4.setGlobalValue(1.0);
        pb.addTimePeg("start", "beh2", "bml1", tp4);
        TimePeg tp5 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        tp5.setGlobalValue(11.0);
        pb.addTimePeg("end", "beh1", "bml1", tp5);
        Set<String> syncs = pb.getTimedSyncs("beh1", "bml1");
        Assert.assertTrue((syncs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)syncs.contains("start"));
        Assert.assertTrue((boolean)syncs.contains("end"));
    }

    @Test
    public void testRemoveBehaviour() {
        PegBoard pb = new PegBoard();
        TimePeg tp1 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pb.addTimePeg("s1", "beh1", "bml1", tp1);
        tp1.setGlobalValue(1.0);
        TimePeg tp2 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pb.addTimePeg("s4", "beh1", "bml2", tp2);
        tp2.setGlobalValue(1.0);
        TimePeg tp3 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pb.addTimePeg("s4", "beh1", "bml1", tp3);
        tp3.setGlobalValue(1.0);
        TimePeg tp4 = new TimePeg(BMLBlockPeg.GLOBALPEG);
        pb.addTimePeg("s5", "beh2", "bml1", tp4);
        tp4.setGlobalValue(1.0);
        Assert.assertNotSame(null, (Object)pb.getTimePeg("s1", "beh1", "bml1"));
        Assert.assertNotSame(null, (Object)pb.getTimePeg("s4", "beh1", "bml1"));
        Assert.assertTrue((pb.getTimedSyncs("beh1", "bml1").size() == 2 ? 1 : 0) != 0);
        pb.removeBehaviour("beh1", "bml1");
        Assert.assertTrue((pb.getTimedSyncs("beh1", "bml1").size() == 0 ? 1 : 0) != 0);
        Assert.assertSame(null, (Object)pb.getTimePeg("s1", "beh1", "bml1"));
        Assert.assertSame(null, (Object)pb.getTimePeg("s4", "beh1", "bml1"));
    }
}

