/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.GuardedBy;

public final class ExceptionManager {
    @GuardedBy(value="warningListeners")
    private final List<BMLExceptionListener> exceptionListeners = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(BMLExceptionFeedback e) {
        List<BMLExceptionListener> list = this.exceptionListeners;
        synchronized (list) {
            for (BMLExceptionListener el : this.exceptionListeners) {
                el.exception(e);
            }
        }
    }

    public void addExceptionListener(BMLExceptionListener es) {
        this.exceptionListeners.add(es);
    }

    public void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    public void puException(TimedPlanUnit timedMU, String message, double time) {
        String bmlId = timedMU.getBMLId();
        String id = "w-" + timedMU.getId();
        HashSet<String> failedBehaviours = new HashSet<String>();
        failedBehaviours.add(timedMU.getId());
        HashSet failedConstraints = new HashSet();
        String exceptionText = String.valueOf(message) + "\nBehavior " + timedMU.getBMLId() + ":" + timedMU.getId() + " dropped.";
        this.exception(new BMLExceptionFeedback(id, bmlId, time, failedBehaviours, failedConstraints, exceptionText, false));
    }
}

