/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.BMLInfo;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningListener;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizer {
    private static Logger logger = LoggerFactory.getLogger((String)ElckerlycRealizer.class.getName());
    private final SchedulingClock schedulingClock;
    private final BMLParser parser;
    private final BMLScheduler scheduler;

    public ElckerlycRealizer(BMLParser bmlparser, SchedulingClock c, BMLScheduler bmlScheduler, Planner ... planners) {
        this.schedulingClock = c;
        this.parser = bmlparser;
        logger.info("Initializing Elckerlyc Scheduler");
        this.scheduler = bmlScheduler;
        Planner[] plannerArray = planners;
        int n = planners.length;
        int n2 = 0;
        while (n2 < n) {
            Planner p = plannerArray[n2];
            if (p != null) {
                this.addPlanner(p);
            }
            ++n2;
        }
        this.initBMLInfo();
    }

    public ElckerlycRealizer(BMLParser p, SchedulingClock c, Planner ... planners) {
        this(p, c, new BMLScheduler(p, c, new SmartBodySchedulingStrategy()), planners);
    }

    public ElckerlycRealizer(SchedulingClock c, Planner ... planners) {
        this(new BMLParser(), c, planners);
    }

    public void setParameterValue(String behId, String bmlId, String paramId, float value) {
        for (Planner p : this.scheduler.getPlanners()) {
            p.setParameterValue(behId, bmlId, paramId, value);
        }
    }

    public void setParameterValue(String behId, String bmlId, String paramId, String value) {
        for (Planner p : this.scheduler.getPlanners()) {
            p.setParameterValue(behId, bmlId, paramId, value);
        }
    }

    public void setFeedbackListener(BMLFeedbackListener f) {
        for (Planner p : this.scheduler.getPlanners()) {
            p.removeAllFeedbackListeners();
            p.addFeedbackListener(f);
        }
    }

    public void setWarningListener(BMLWarningListener w) {
        this.scheduler.removeAllWarningListeners();
        this.scheduler.addWarningListener(w);
    }

    public void setExceptionListener(BMLExceptionListener e) {
        this.scheduler.removeAllExceptionListeners();
        this.scheduler.addExceptionListener(e);
        for (Planner p : this.scheduler.getPlanners()) {
            p.removeAllExceptionListeners();
        }
    }

    public void addExceptionListener(BMLExceptionListener newListener) {
        this.scheduler.addExceptionListener(newListener);
        for (Planner p : this.scheduler.getPlanners()) {
            p.addExceptionListener(newListener);
        }
    }

    public void addPlanningListener(BMLTPlanningListener bp) {
        this.scheduler.addPlanningListener(bp);
    }

    public void addWarningListener(BMLWarningListener newListener) {
        this.scheduler.addWarningListener(newListener);
    }

    public void addFeedbackListener(BMLFeedbackListener newListener) {
        this.scheduler.addFeedbackListener(newListener);
    }

    protected void initBMLInfo() {
        for (Planner p : this.scheduler.getPlanners()) {
            for (Class<? extends Behaviour> beh : p.getSupportedDescriptionExtensions()) {
                if (BMLInfo.supportedExtensions.contains(beh)) continue;
                BMLInfo.supportedExtensions.add(beh);
            }
        }
    }

    private void addPlanner(Planner p) {
        for (Class<? extends Behaviour> beh : p.getSupportedBehaviours()) {
            this.scheduler.addPlanner(beh, p);
        }
        for (Class<? extends Behaviour> beh : p.getSupportedDescriptionExtensions()) {
            this.scheduler.addPlanner(beh, p);
        }
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.scheduler.addAnticipator(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.scheduler.removeAnticipator(aid);
    }

    public void scheduleBML(Reader in) throws IOException {
        this.scheduleBML(new XMLTokenizer(in));
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public void scheduleBML(XMLTokenizer in) {
        BehaviourBlock block = new BehaviourBlock();
        try {
            block.readXML(in);
        }
        catch (XMLScanException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Parsing XML failed: see stack trace for more info. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        catch (IOException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "IO Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        catch (Exception e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception reading the XML. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        try {
            this.parser.addBehaviourBlock(block);
        }
        catch (Exception e) {
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception parsing the BML. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(block.id, block.bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
        try {
            this.scheduler.schedule();
        }
        catch (Exception e) {
            HashSet failedBehaviours = new HashSet();
            HashSet failedConstraints = new HashSet();
            String exceptionText = "Exception scheduling the BML. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            this.scheduler.exception(new BMLExceptionFeedback(block.id, block.bmlId, this.schedulingClock.getTime(), failedBehaviours, failedConstraints, exceptionText, true));
            return;
        }
    }

    public void scheduleBML(String blockContent) {
        XMLTokenizer in = new XMLTokenizer(blockContent);
        this.scheduleBML(in);
    }

    public void clear() {
        this.parser.clear();
        this.scheduler.clear();
    }

    public void reset() {
        this.scheduler.reset();
    }

    public Planner getPlanner(Class<? extends Behaviour> c) {
        return this.scheduler.getPlanner(c);
    }

    public BMLScheduler getScheduler() {
        return this.scheduler;
    }
}

