/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.AbstractPlanUnit;

public class WaitUnit
extends AbstractPlanUnit {
    private TimePeg startPeg;
    private TimePeg endPeg;

    public WaitUnit(BMLBlockPeg bmlPeg, String i, String bmlId) {
        super(bmlPeg, i, bmlId);
    }

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
    }

    public void setEndPeg(TimePeg endPeg) {
        this.endPeg = endPeg;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        if (this.endPeg == null) {
            return -1.7976931348623157E308;
        }
        return this.endPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        if (this.startPeg == null) {
            return false;
        }
        if (this.startPeg.getGlobalValue() == -1.7976931348623157E308) {
            return false;
        }
        if (this.endPeg == null) {
            return true;
        }
        if (this.endPeg.getGlobalValue() == -1.7976931348623157E308) {
            return true;
        }
        return this.startPeg.getGlobalValue() < this.endPeg.getGlobalValue();
    }

    private void sendFeedback(String syncId, double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    @Override
    public void startUnit(double time) {
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    @Override
    protected void playUnit(double time) throws PlayException {
    }

    @Override
    protected void stopUnit(double time) throws PlayException {
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getPreferedDuration() {
        if (this.getEndTime() != -1.7976931348623157E308 && this.getStartTime() != -1.7976931348623157E308) {
            return this.getEndTime() - this.getStartTime();
        }
        return 0.0;
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getStartTime();
        }
        return -1.7976931348623157E308;
    }
}

