/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.wait;

import hmi.bml.core.Behaviour;
import hmi.bml.core.WaitBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.wait.WaitPlayer;
import hmi.elckerlyc.wait.WaitUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WaitPlanner
extends AbstractPlanner {
    private final WaitPlayer player = new WaitPlayer();

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public WaitPlayer getWaitPlayer() {
        return this.player;
    }

    private void validateSacs(Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        if (sacs.size() > 2) {
            throw new BehaviourPlanningException(b, "More than two synchronization constraints on wait behaviour " + b);
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start") || sac.id.equals("end")) continue;
            throw new BehaviourPlanningException(b, "Wait behavior " + b + " has a synchronization constraint other than start or end.");
        }
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs, PlanUnit planElement) throws BehaviourPlanningException {
        WaitUnit wu = planElement == null ? new WaitUnit(bbPeg, b.id, b.bmlId) : (WaitUnit)planElement;
        this.validateSacs(b, sacs);
        this.player.addPlanUnit(wu);
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            wu.addFeedbackListener(fb);
        }
        ArrayList<SyncAndTimePeg> list = new ArrayList<SyncAndTimePeg>();
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) {
                wu.setStartPeg(sac.peg);
            }
            if (sac.id.equals("end")) {
                wu.setEndPeg(sac.peg);
            }
            list.add(new SyncAndTimePeg(sac.id, b.id, b.bmlId, sac.peg));
        }
        return list;
    }

    @Override
    public PlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        this.validateSacs(b, sacs);
        WaitUnit wu = new WaitUnit(bbPeg, b.id, b.bmlId);
        TimePegAndConstraint sacStart = null;
        TimePegAndConstraint sacEnd = null;
        float maxDur = b.getFloatParameterValue("max-wait");
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) {
                sacStart = sac;
            }
            if (!sac.id.equals("end")) continue;
            sacEnd = sac;
        }
        TimePeg startPeg = null;
        if (sacStart != null) {
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                if (sacEnd == null || sacEnd.peg.getGlobalValue() == -1.7976931348623157E308 || maxDur <= 0.0f) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    sacStart.peg.setGlobalValue(sacEnd.peg.getGlobalValue() - (double)maxDur);
                }
            }
            startPeg = sacStart.peg;
        } else if (sacEnd != null && sacEnd.peg.getGlobalValue() != -1.7976931348623157E308 && maxDur > 0.0f) {
            startPeg = new OffsetPeg(sacEnd.peg, -maxDur);
        } else {
            startPeg = new TimePeg(bbPeg);
            startPeg.setLocalValue(0.0);
        }
        wu.setStartPeg(startPeg);
        if (sacEnd == null) {
            if (maxDur <= 0.0f) {
                TimePeg p = new TimePeg(bbPeg);
                wu.setEndPeg(p);
            } else {
                wu.setEndPeg(new OffsetPeg(startPeg, maxDur));
            }
        } else {
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308 && maxDur > 0.0f) {
                sacEnd.peg.setGlobalValue(startPeg.getGlobalValue() + (double)maxDur);
            }
            wu.setEndPeg(sacEnd.peg);
        }
        return wu;
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    @Override
    public void reset() {
        this.player.reset();
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviors();
    }

    @Override
    public void removeBehaviour(String behaviourId, String bmlId) {
        this.player.interruptBehaviour(behaviourId, bmlId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String bmlId, double globalTime) {
        this.player.interruptBehaviour(behaviourId, bmlId, globalTime);
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(WaitBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    @Override
    public void removeAllWarningListeners() {
        this.player.removeAllWarningListeners();
    }

    @Override
    public void addWarningListener(BMLWarningListener war) {
        this.player.addWarningListener(war);
    }
}

