/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.SpeechPlanner;
import hmi.elckerlyc.speechengine.TextOutput;
import hmi.elckerlyc.speechengine.TextSpeechUnit;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPlanner
extends AbstractPlanner
implements SpeechPlanner {
    private static Logger logger = LoggerFactory.getLogger((String)TextPlanner.class.getName());
    private VerbalPlayer player;
    private TextOutput textOutput;

    @Override
    public String getType() {
        return this.getClass().getName() + "[" + this.textOutput.getClass().getName() + "]";
    }

    public TextPlanner(VerbalPlayer p, TextOutput output) {
        this.player = p;
        this.textOutput = output;
    }

    public void setTextOutput(TextOutput to) {
        this.textOutput = to;
    }

    private TextSpeechUnit createSpeechUnit(BMLBlockPeg bbPeg, Behaviour b) {
        SpeechBehaviour bSpeech = (SpeechBehaviour)b;
        TextSpeechUnit bs = new TextSpeechUnit(bbPeg, bSpeech.getContent(), bSpeech.id, bSpeech.bmlId, this.textOutput);
        return bs;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs, PlanUnit planElement) throws BehaviourPlanningException {
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        TextSpeechUnit bs = planElement == null ? this.createSpeechUnit(bbPeg, b) : (TextSpeechUnit)planElement;
        for (TimePegAndConstraint sac : sacs) {
            OffsetPeg p;
            if (sac.id.equals("start")) {
                if (sac.offset == 0.0) {
                    bs.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    bs.setStart(p);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, p));
                }
            }
            if (!sac.id.equals("end")) continue;
            if (sac.offset == 0.0) {
                bs.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            bs.setEnd(p);
            satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, p));
        }
        this.linkSyncs(bs, sacs);
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            bs.addFeedbackListener(fb);
        }
        for (String sync : bs.getSyncs()) {
            if (bs.getTimePeg(sync) == null) continue;
            satp.add(new SyncAndTimePeg(sync, b.id, b.bmlId, bs.getTimePeg(sync)));
        }
        this.player.addSpeechUnit(bs);
        return satp;
    }

    @Override
    public TextSpeechUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TextSpeechUnit bs = this.createSpeechUnit(bbPeg, b);
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block0: for (String sync : bs.getSyncs()) {
            for (TimePegAndConstraint s : sacs) {
                if (!s.id.equals(sync)) continue;
                sortedSac.add(s);
                continue block0;
            }
        }
        this.linkSyncs(bs, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = bs.getTime(s.id) - bs.getTime(sPrev.id);
                double startKey = 0.0;
                double endKey = 0.0;
                for (String sync : bs.getSyncs()) {
                    TimePeg tp = bs.getTimePeg(sync);
                    if (tp == null) continue;
                    if (tp.getLink() == sPrev.peg.getLink()) {
                        startKey = bs.getRelativeTime(sync);
                    }
                    if (tp.getLink() != s.peg.getLink()) continue;
                    endKey = bs.getRelativeTime(sync);
                }
                double nominalDuration = (endKey - startKey) * bs.getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey = bs.getRelativeTime(sacNext.id);
                    double nextTime = bs.getTime(sacNext.id);
                    double tStart = nextTime - nextKey * avgStretch * bs.getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(bs.getTimePeg(sacNext.id));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(bs.getPreferedDuration());
                } else {
                    double keyPrev = bs.getRelativeTime(sacPrev.id);
                    double keyNext = 1.0;
                    double keyCurr = bs.getRelativeTime(sacEnd.id);
                    double timePrev = bs.getTime(sacPrev.id);
                    double timeNext = timePrev + (keyNext - keyPrev) * avgStretch * bs.getPreferedDuration();
                    sacEnd.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    double keyPrev = bs.getRelativeTime(sacPrev.id);
                    double keyNext = bs.getRelativeTime(sacNext.id);
                    double keyCurr = bs.getRelativeTime(s.id);
                    double timePrev = bs.getTime(sacPrev.id);
                    double timeNext = bs.getTime(sacNext.id);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            logger.debug(sacEnd.id);
            if (!sacEnd.id.equals("end") && bs.getPreferedDuration() > 0.0) {
                double keyPrev = bs.getRelativeTime(sacEnd.id);
                double keyEnd = bs.getRelativeTime("end");
                OffsetPeg op = new OffsetPeg(bs.getTimePeg(sacEnd.id), (keyEnd - keyPrev) * avgStretch * bs.getPreferedDuration());
                bs.setEnd(op);
            }
        }
        return bs;
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviours();
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    private void linkSyncs(TextSpeechUnit su, ArrayList<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (String sync : su.getSyncs()) {
                if (!s.id.equals(sync)) continue;
                if (s.offset == 0.0) {
                    su.setTimePeg(sync, s.peg);
                    continue;
                }
                su.setTimePeg(sync, new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.interruptSpeechUnit(behaviourId, BMLId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String BMLId, double globalTime) {
        this.player.interruptSpeechUnit(behaviourId, BMLId, globalTime);
    }

    @Override
    public VerbalPlayer getVerbalPlayer() {
        return this.player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void addWarningListener(BMLWarningListener war) {
        this.getPlayer().addWarningListener(war);
    }

    @Override
    public void removeAllWarningListeners() {
        this.getPlayer().removeAllWarningListeners();
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(SpeechBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    @Override
    public void reset() {
        this.player.reset();
    }
}

