/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.speechengine.AbstractSpeechUnit;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TTSUnit
extends AbstractSpeechUnit {
    protected TTSBinding ttsBinding;
    private double duration;
    protected Collection<Bookmark> bookmarks;
    protected Collection<Visime> visimes;
    public int prevVisime;
    public int curVisime;
    public int nextVisime;
    public double visimeDuration;
    private final Class<? extends Behaviour> behaviourClass;
    protected TreeMap<Bookmark, TimePeg> pegs = new TreeMap();
    private static Logger logger = LoggerFactory.getLogger((String)TTSUnit.class.getName());

    @Override
    public abstract void setParameterValue(String var1, float var2);

    public Class<? extends Behaviour> getBehaviourClass() {
        return this.behaviourClass;
    }

    public TTSUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bbPeg, text, id, bmlId);
        this.ttsBinding = ttsBin;
        this.bookmarks = new ArrayList<Bookmark>();
        this.visimes = new ArrayList<Visime>();
        this.behaviourClass = behClass;
    }

    public TimePeg getBookMarkTimePeg(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b);
        }
        return null;
    }

    public double getBookMarkTime(Bookmark b) {
        TimePeg p = this.pegs.get(b);
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public TimePeg getBookMarkTimePeg(Bookmark b) {
        if (this.pegs.get(b) != null) {
            return this.pegs.get(b);
        }
        return null;
    }

    public double getBookMarkTime(String bmid) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(bmid) || this.pegs.get(b) == null) continue;
            return this.pegs.get(b).getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public double getTime(String syncId) {
        if (this.getBookMarkTime(syncId) != -1.7976931348623157E308) {
            return this.getBookMarkTime(syncId);
        }
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getStartTime();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            logger.debug("End time: {}", (Object)this.getEndTime());
            logger.debug("Start time: ", (Object)this.getStartTime());
            logger.debug("End-start: ", (Object)(this.getEndTime() - this.getStartTime()));
            logger.debug("Duration: ", (Object)this.getPreferedDuration());
            return false;
        }
        for (Bookmark b : this.getBookmarks()) {
            double bmTime = this.getBookMarkTime(b);
            if (bmTime == -1.7976931348623157E308 || !(Math.abs((double)b.getOffset() * 0.001 + this.getStartTime() - bmTime) > 1.0E-4)) continue;
            logger.debug("(b.offset*0.001+getStartTime())= {}", (Object)((double)b.getOffset() * 0.001 + this.getStartTime()));
            logger.debug("bookmarktime= {}", (Object)bmTime);
            return false;
        }
        return true;
    }

    @Override
    public double getPreferedDuration() {
        return this.duration;
    }

    protected abstract TimingInfo getTiming() throws SpeechUnitPlanningException;

    protected void setupCache() throws SpeechUnitPlanningException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() throws SpeechUnitPlanningException {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            this.ttsBinding.setCallback(null);
            TimingInfo ti = this.getTiming();
            this.setupCache();
            this.duration = ti.getDuration();
            this.bookmarks.clear();
            this.bookmarks = ti.getBookmarks();
            this.visimes.clear();
            this.visimes = ti.getVisimes();
        }
    }

    @Override
    public abstract void sendProgress(double var1, double var3);

    public void setTimePeg(Bookmark bm, TimePeg sp) {
        this.pegs.put(bm, sp);
    }

    public Collection<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public Collection<Visime> getVisimes() {
        return this.visimes;
    }
}

