/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import hmi.elckerlyc.speechengine.SpeechPlanner;
import hmi.elckerlyc.speechengine.SpeechUnitPlanningException;
import hmi.elckerlyc.speechengine.TTSUnit;
import hmi.elckerlyc.speechengine.TTSUnitFactory;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.elckerlyc.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTSPlanner
extends AbstractPlanner
implements SpeechPlanner {
    private static Logger logger = LoggerFactory.getLogger((String)TTSPlanner.class.getName());
    private VerbalPlayer player;
    private final TTSBinding ttsBinding;
    private final TTSUnitFactory suFactory;
    private static final double TIMEPEG_TOLERANCE = 0.003;
    private FacePlanner facePlanner = null;
    private AnimationPlanner animationPlanner = null;

    @Override
    public String getType() {
        return this.getClass().getName() + "[" + this.ttsBinding.getClass().getName() + ", " + this.suFactory.getClass().getName() + "]";
    }

    public TTSPlanner(TTSUnitFactory suf, VerbalPlayer p, TTSBinding ttsGen) {
        this(suf, p, ttsGen, null, null);
    }

    public TTSPlanner(TTSUnitFactory suf, VerbalPlayer p, TTSBinding ttsBin, FacePlanner fp, AnimationPlanner ap) {
        this.suFactory = suf;
        this.ttsBinding = ttsBin;
        this.player = p;
        this.facePlanner = fp;
        this.animationPlanner = ap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeaker(String speaker) {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            this.ttsBinding.setVoice(speaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVoices() {
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            return this.ttsBinding.getVoices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTSUnit createSpeechUnit(BMLBlockPeg bbPeg, Behaviour b) throws SpeechUnitPlanningException {
        SpeechBehaviour bSpeech = (SpeechBehaviour)b;
        TTSUnit bs = this.suFactory.createSpeechUnit(bbPeg, bSpeech.getContent(), bSpeech.id, bSpeech.bmlId, this.ttsBinding, b.getClass());
        TTSBinding tTSBinding = this.ttsBinding;
        synchronized (tTSBinding) {
            bs.setup();
        }
        logger.debug("Creating speech unit {} duration: {}", (Object)b.id, (Object)bs.getPreferedDuration());
        return bs;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs, PlanUnit planElement) throws BehaviourPlanningException {
        TimePeg p;
        TTSUnit bs;
        ArrayList<SyncAndTimePeg> satp = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            try {
                bs = this.createSpeechUnit(bbPeg, b);
            }
            catch (SpeechUnitPlanningException e) {
                BehaviourPlanningException bpe = new BehaviourPlanningException(b, e.getLocalizedMessage());
                bpe.initCause(e);
                throw bpe;
            }
        } else {
            bs = (TTSUnit)planElement;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) {
                if (sac.offset == 0.0) {
                    bs.setStart(sac.peg);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.peg));
                } else {
                    p = new OffsetPeg(sac.peg, -sac.offset);
                    bs.setStart(p);
                    satp.add(new SyncAndTimePeg("start", b.id, b.bmlId, p));
                }
            }
            if (!sac.id.equals("end")) continue;
            if (sac.offset == 0.0) {
                bs.setEnd(sac.peg);
                satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, sac.peg));
                continue;
            }
            p = new OffsetPeg(sac.peg, -sac.offset);
            bs.setEnd(p);
            satp.add(new SyncAndTimePeg("end", b.id, b.bmlId, p));
        }
        this.linkBookmarks(bs, sacs, bs.getStartTime(), b);
        for (Bookmark bm : bs.getBookmarks()) {
            p = bs.getBookMarkTimePeg(bm);
            if (p == null) continue;
            satp.add(new SyncAndTimePeg(bm.getName(), b.id, b.bmlId, p));
        }
        if (this.facePlanner != null && this.facePlanner.getVisemeBinding() != null) {
            this.addFaceUnits(bbPeg, b, bs);
        }
        if (this.animationPlanner != null && this.animationPlanner.hasSpeechBinding()) {
            this.addJawMovement(bbPeg, b, bs);
        }
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            bs.addFeedbackListener(fb);
        }
        this.player.addSpeechUnit(bs);
        return satp;
    }

    private void addJawMovement(BMLBlockPeg bbPeg, Behaviour beh, TTSUnit bs) {
        ArrayList<TimedMotionUnit> tmus = new ArrayList<TimedMotionUnit>();
        double totalDuration = 0.0;
        double prevDuration = 0.0;
        TimedMotionUnit tmu = this.animationPlanner.getSpeechMotionUnit(0, bbPeg, beh.id, beh.bmlId);
        tmu.resolveDefaultBMLKeyPositions();
        HashMap<TimedMotionUnit, Double> startTimes = new HashMap<TimedMotionUnit, Double>();
        HashMap<TimedMotionUnit, Double> endTimes = new HashMap<TimedMotionUnit, Double>();
        startTimes.put(tmu, new Double(0.0));
        endTimes.put(tmu, new Double(0.0));
        tmus.add(tmu);
        for (Visime vis : bs.getVisimes()) {
            double start = totalDuration / 1000.0 - prevDuration / 2000.0;
            double peak = totalDuration / 1000.0 + (double)vis.getDuration() / 2000.0;
            double end = totalDuration / 1000.0 + (double)vis.getDuration() / 1000.0;
            endTimes.put(tmu, peak);
            tmu = this.animationPlanner.getSpeechMotionUnit(vis.getNumber(), bbPeg, beh.id, beh.bmlId);
            if (tmu == null) {
                tmu = this.animationPlanner.getSpeechMotionUnit(0, bbPeg, beh.id, beh.bmlId);
            }
            logger.debug("Viseme number {}", (Object)vis.getNumber());
            startTimes.put(tmu, start);
            endTimes.put(tmu, end);
            tmus.add(tmu);
            tmu.resolveDefaultBMLKeyPositions();
            totalDuration += (double)vis.getDuration();
            prevDuration = vis.getDuration();
        }
        tmu = this.animationPlanner.getSpeechMotionUnit(0, bbPeg, beh.id, beh.bmlId);
        tmu.resolveDefaultBMLKeyPositions();
        tmus.add(tmu);
        startTimes.put(tmu, new Double(totalDuration / 1000.0));
        endTimes.put(tmu, new Double(totalDuration / 1000.0));
        this.animationPlanner.addVisemesForSpeechUnit(tmus);
        for (TimedMotionUnit plannedFU : tmus) {
            OffsetPeg startPeg = new OffsetPeg(bs.getStartPeg(), (Double)startTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("start"), (TimePeg)startPeg);
            OffsetPeg endPeg = new OffsetPeg(bs.getStartPeg(), (Double)endTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("end"), (TimePeg)endPeg);
        }
    }

    private void addFaceUnits(BMLBlockPeg bbPeg, Behaviour beh, TTSUnit bs) {
        ArrayList<TimedFaceUnit> tfus = new ArrayList<TimedFaceUnit>();
        double totalDuration = 0.0;
        double prevDuration = 0.0;
        TimedFaceUnit tfu = this.facePlanner.getVisemeBinding().getVisemeUnit(bbPeg, beh, -1, 0.0, 0.0, 0.0, 1.0f, this.facePlanner.getFacePlayer());
        tfu.setSubUnit(true);
        HashMap<TimedFaceUnit, Double> startTimes = new HashMap<TimedFaceUnit, Double>();
        HashMap<TimedFaceUnit, Double> endTimes = new HashMap<TimedFaceUnit, Double>();
        startTimes.put(tfu, new Double(0.0));
        endTimes.put(tfu, new Double(0.0));
        for (Visime vis : bs.getVisimes()) {
            double start = totalDuration / 1000.0 - prevDuration / 2000.0;
            double peak = totalDuration / 1000.0 + (double)vis.getDuration() / 2000.0;
            double end = totalDuration / 1000.0 + (double)vis.getDuration() / 1000.0;
            endTimes.put(tfu, peak);
            tfu = this.facePlanner.getVisemeBinding().getVisemeUnit(bbPeg, beh, vis.getNumber(), start, peak, end, 1.0f, this.facePlanner.getFacePlayer());
            startTimes.put(tfu, start);
            endTimes.put(tfu, end);
            tfus.add(tfu);
            totalDuration += (double)vis.getDuration();
            prevDuration = vis.getDuration();
        }
        tfu = this.facePlanner.getVisemeBinding().getVisemeUnit(bbPeg, beh, -1, totalDuration / 1000.0, totalDuration / 1000.0, totalDuration / 1000.0, 1.0f, this.facePlanner.getFacePlayer());
        tfus.add(tfu);
        startTimes.put(tfu, new Double(totalDuration / 1000.0));
        endTimes.put(tfu, new Double(totalDuration / 1000.0));
        this.facePlanner.addVisemesForSpeechUnit(tfus);
        for (TimedFaceUnit plannedFU : tfus) {
            OffsetPeg startPeg = new OffsetPeg(bs.getStartPeg(), (Double)startTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("start"), (TimePeg)startPeg);
            OffsetPeg endPeg = new OffsetPeg(bs.getStartPeg(), (Double)endTimes.get(plannedFU));
            plannedFU.setTimePeg(plannedFU.getKeyPosition("end"), (TimePeg)endPeg);
        }
    }

    @Override
    public PlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs) throws BehaviourPlanningException {
        TTSUnit bs;
        try {
            bs = this.createSpeechUnit(bbPeg, b);
        }
        catch (SpeechUnitPlanningException e) {
            BehaviourPlanningException bpe = new BehaviourPlanningException(b, e.getLocalizedMessage());
            bpe.initCause(e);
            throw bpe;
        }
        double startTime = bbPeg.getValue();
        boolean startFound = false;
        for (TimePegAndConstraint sac : sacs) {
            if (!sac.id.equals("start") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            startTime = sac.peg.getGlobalValue() - sac.offset;
            startFound = true;
        }
        if (!startFound) {
            for (TimePegAndConstraint sac : sacs) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                for (Bookmark bm : bs.getBookmarks()) {
                    if (!bm.getName().equals(sac.id)) continue;
                    startTime = sac.peg.getGlobalValue() - (double)bm.getOffset() * 0.001 - sac.offset;
                    logger.debug("Setting start time based on bookmark {} , startTime: {}, sac.offset: {}, bm.offset: {}", new Object[]{sac.id, startTime, sac.offset, bm.getOffset()});
                    break;
                }
                if (!sac.id.equals("end") || sac.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                startTime = sac.peg.getGlobalValue() - bs.getPreferedDuration() - sac.offset;
                break;
            }
        }
        this.linkBookmarks(bs, sacs, startTime, b);
        TimePegAndConstraint sacNotStart = null;
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("start")) continue;
            sacNotStart = sac;
            break;
        }
        for (TimePegAndConstraint sac : sacs) {
            if (sac.id.equals("end")) {
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    sac.peg.setGlobalValue(bs.getPreferedDuration() + startTime + sac.offset);
                } else if (Math.abs(sac.peg.getGlobalValue() - (startTime + bs.getPreferedDuration() + sac.offset)) > 0.003) {
                    throw new BehaviourPlanningException(b, "Stretching speech is not supported yet. Possibly this can be solved by moving the speech behavior up in the BML spec? Behavior omitted.");
                }
            }
            if (!sac.id.equals("start") || sac.peg.getGlobalValue() != -1.7976931348623157E308) continue;
            if (sac.resolveAsStartOffset) {
                OffsetPeg p = (OffsetPeg)sac.peg;
                p.setLink(sacNotStart.peg);
                p.setOffset(startTime - sacNotStart.peg.getGlobalValue());
                continue;
            }
            sac.peg.setGlobalValue(startTime + sac.offset);
        }
        return bs;
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviours();
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    private void linkBookmarks(TTSUnit su, ArrayList<TimePegAndConstraint> sacs, double startTime, Behaviour b) throws BehaviourPlanningException {
        for (Bookmark bm : su.getBookmarks()) {
            for (TimePegAndConstraint sac : sacs) {
                if (!sac.id.equals(bm.getName())) continue;
                if (sac.peg.getGlobalValue() == -1.7976931348623157E308) {
                    logger.debug("Setting time for bookmark {} : {}", (Object)bm.getName(), (Object)(-sac.offset + startTime + (double)bm.getOffset() * 0.001));
                    sac.peg.setGlobalValue(sac.offset + startTime + (double)bm.getOffset() * 0.001);
                    if (sac.offset == 0.0) {
                        su.setTimePeg(bm, sac.peg);
                        continue;
                    }
                    su.setTimePeg(bm, new OffsetPeg(sac.peg, -sac.offset));
                    continue;
                }
                if (Math.abs(sac.peg.getGlobalValue() - sac.offset - (startTime + (double)bm.getOffset() * 0.001)) > 0.1) {
                    throw new BehaviourPlanningException(b, "Can't set bookmark timing for bookmark: " + bm.getName() + ", functionality not yet supported. Desired time: " + (sac.peg.getGlobalValue() - sac.offset) + " Speech time: " + (startTime + (double)((float)bm.getOffset() * 0.001f)) + ". Behavior omitted.");
                }
                if (sac.offset == 0.0) {
                    su.setTimePeg(bm, sac.peg);
                    continue;
                }
                OffsetPeg p = new OffsetPeg(sac.peg, -sac.offset);
                su.setTimePeg(bm, p);
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.interruptSpeechUnit(behaviourId, BMLId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String BMLId, double globalTime) {
        this.player.interruptSpeechUnit(behaviourId, BMLId, globalTime);
    }

    @Override
    public VerbalPlayer getVerbalPlayer() {
        return this.player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void addWarningListener(BMLWarningListener war) {
        this.player.addWarningListener(war);
    }

    @Override
    public void removeAllWarningListeners() {
        this.player.removeAllWarningListeners();
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(SpeechBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        return this.ttsBinding.getSupportedBMLDescriptionExtensions();
    }

    @Override
    public void reset() {
        this.player.reset();
    }
}

