/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.speechengine;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.planunit.AbstractPlanUnit;
import hmi.elckerlyc.speechengine.SpeechUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpeechUnit
extends AbstractPlanUnit
implements SpeechUnit {
    private TimePeg startSync;
    private TimePeg endSync;
    protected String speechText;
    protected double bmlStartTime;
    private static Logger logger = LoggerFactory.getLogger((String)AbstractSpeechUnit.class.getName());

    AbstractSpeechUnit(BMLBlockPeg bbPeg, String text, String id, String bmlId) {
        super(bbPeg, id, bmlId);
        this.speechText = text;
    }

    @Override
    public double getStartTime() {
        if (this.startSync == null) {
            return -1.7976931348623157E308;
        }
        return this.startSync.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        double startTime;
        double endTime = this.endSync == null ? -1.7976931348623157E308 : this.endSync.getGlobalValue();
        if (endTime == -1.7976931348623157E308 && (startTime = this.getStartTime()) != -1.7976931348623157E308) {
            return startTime + this.getPreferedDuration();
        }
        return endTime;
    }

    public TimePeg getEndPeg() {
        return this.endSync;
    }

    public TimePeg getStartPeg() {
        return this.startSync;
    }

    @Override
    public void setStart(TimePeg s) {
        this.startSync = s;
    }

    @Override
    public void setEnd(TimePeg s) {
        this.endSync = s;
    }

    protected void sendStartProgress(double time) {
        logger.debug("Sending start progress feedback.");
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "start";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "ready";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke-start";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    @Override
    public void sendEndProgress(double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "stroke-end";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "relax";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "end";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }
}

