/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.parser.Constraint;
import hmi.bml.parser.SyncPoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartBodySchedulingStrategy
implements SchedulingStrategy {
    private static final Logger logger = LoggerFactory.getLogger((String)SmartBodySchedulingStrategy.class.getName());

    @Override
    public void schedule(BehaviourBlock bb, BMLBlockPeg bmlBlockPeg, BMLScheduler scheduler, double scheduleTime) {
        ArrayList<Behaviour> scheduledBehaviors = new ArrayList<Behaviour>();
        HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap = new HashMap<Behaviour, ArrayList<TimePegAndConstraint>>();
        for (Behaviour b : bb.behaviours) {
            ArrayList<TimePegAndConstraint> syncList;
            block22: {
                Planner p;
                syncList = new ArrayList<TimePegAndConstraint>();
                for (Constraint c : scheduler.getParser().getConstraints()) {
                    ArrayList<ConstrInfo> constraintInfo = new ArrayList<ConstrInfo>();
                    for (SyncPoint s : c.getTargets()) {
                        if (s.getBehavior() != b) continue;
                        double offset = s.getOffset();
                        String syncId = s.getName();
                        constraintInfo.add(new ConstrInfo(syncId, offset));
                        logger.debug("Constraint info:{} sync:{} offset:{}", new Object[]{b, syncId, offset});
                    }
                    for (ConstrInfo ci : constraintInfo) {
                        boolean syncExists = false;
                        block6: for (Behaviour b2 : scheduledBehaviors) {
                            for (TimePegAndConstraint said : (ArrayList)syncMap.get(b2)) {
                                if (said.constr != c) continue;
                                syncList.add(new TimePegAndConstraint(ci.syncId, said.peg, c, ci.offset));
                                syncExists = true;
                                continue block6;
                            }
                        }
                        if (syncExists) continue;
                        boolean isStaticOrAnticipator = false;
                        for (SyncPoint s : c.getTargets()) {
                            if (s.getBehavior() != null) continue;
                            String[] str = s.getName().split(":");
                            if (str.length == 2 && !str[0].equals("bml")) {
                                Anticipator ap = scheduler.getAnticipator(str[0]);
                                isStaticOrAnticipator = true;
                                if (ap != null) {
                                    TimePeg sp = ap.getSynchronisationPoint(str[1]);
                                    syncList.add(new TimePegAndConstraint(ci.syncId, sp, c, ci.offset - s.offset));
                                    logger.debug("Link to anticipator: {} at time {} with offset {}", new Object[]{str[1], sp.getGlobalValue(), ci.offset});
                                    sp.setAbsoluteTime(true);
                                    break;
                                }
                                String bmlId = bb.id;
                                String id = "w-" + b.id;
                                ArrayList modifiedBehaviours = new ArrayList();
                                ArrayList droppedBehaviours = new ArrayList();
                                ArrayList modifiedConstraints = new ArrayList();
                                String warningText = "Unknown sync point " + s.getName() + " sync ignored.";
                                scheduler.warn(new BMLWarningFeedback(id, bmlId, scheduleTime, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
                                break;
                            }
                            isStaticOrAnticipator = true;
                            TimePeg sync = new TimePeg(bmlBlockPeg);
                            sync.setAbsoluteTime(true);
                            sync.setLocalValue(s.getOffset());
                            syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
                            break;
                        }
                        if (isStaticOrAnticipator) continue;
                        TimePeg sync = new TimePeg(bmlBlockPeg);
                        sync.setGlobalValue(-1.7976931348623157E308);
                        syncList.add(new TimePegAndConstraint(ci.syncId, sync, c, ci.offset));
                    }
                }
                boolean resolveStart = true;
                for (TimePegAndConstraint sac : syncList) {
                    if (!sac.id.equals("start")) continue;
                    resolveStart = false;
                    break;
                }
                if (resolveStart) {
                    TimePeg temp = new TimePeg(bmlBlockPeg);
                    OffsetPeg sync = new OffsetPeg(temp, 0.0, bmlBlockPeg);
                    boolean offsetRes = false;
                    if (syncList.size() > 0) {
                        offsetRes = true;
                    }
                    syncList.add(new TimePegAndConstraint("start", sync, new Constraint(), 0.0, offsetRes));
                }
                if ((p = scheduler.getPlanner(b.getClass())) != null) {
                    try {
                        PlanUnit planElement = p.resolveSynchs(bmlBlockPeg, b, syncList);
                        List<SyncAndTimePeg> satp = p.addBehaviour(bmlBlockPeg, b, syncList, planElement);
                        scheduler.getPegBoard().addTimePegs(satp);
                        break block22;
                    }
                    catch (BehaviourPlanningException ex) {
                        String bmlId = bb.id;
                        String id = "w-" + b.id;
                        ArrayList modifiedBehaviours = new ArrayList();
                        ArrayList<String> droppedBehaviours = new ArrayList<String>();
                        droppedBehaviours.add(b.id);
                        ArrayList modifiedConstraints = new ArrayList();
                        String warningText = ex.getMessage();
                        scheduler.warn(new BMLWarningFeedback(id, bmlId, scheduleTime, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
                        break;
                    }
                }
                String bmlId = bb.id;
                String id = "w-" + b.id;
                ArrayList modifiedBehaviours = new ArrayList();
                ArrayList<String> droppedBehaviours = new ArrayList<String>();
                droppedBehaviours.add(b.id);
                ArrayList modifiedConstraints = new ArrayList();
                String warningText = "No planner found to plan behavior of type <" + b.getXMLTag() + ">, behavior ommitted";
                scheduler.warn(new BMLWarningFeedback(id, bmlId, scheduleTime, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
                break;
            }
            syncMap.put(b, syncList);
            scheduledBehaviors.add(b);
        }
        boolean moving = true;
        ArrayList<Behaviour> behToRemove = new ArrayList<Behaviour>();
        block10: while (moving) {
            moving = false;
            for (Behaviour b : scheduledBehaviors) {
                for (TimePegAndConstraint tpac : (ArrayList)syncMap.get(b)) {
                    double t = scheduler.getPegBoard().getRelativePegTime(bb.id, tpac.peg) - tpac.offset;
                    if (!(t < -1.0E-6) || t == -1.7976931348623157E308) continue;
                    logger.debug("negative time: {}:{}", (Object)b.id, (Object)tpac.id);
                    logger.debug("Value: {} Offset: {}", (Object)tpac.peg.getGlobalValue(), (Object)tpac.offset);
                    double move = -t;
                    if (!tpac.peg.isAbsoluteTime()) {
                        this.movePeg(move, b, syncMap);
                        moving = true;
                        break;
                    }
                    String bmlId = b.bmlId;
                    String wid = "w-" + b.id;
                    ArrayList<String> modifiedBehaviours = new ArrayList<String>();
                    modifiedBehaviours.add(b.id);
                    ArrayList<String> droppedBehaviours = new ArrayList<String>();
                    droppedBehaviours.add(b.id);
                    ArrayList modifiedConstraints = new ArrayList();
                    String warningText = "Can't satisfy time constraints on <" + b.getXMLTag() + ">, behavior ommitted";
                    scheduler.warn(new BMLWarningFeedback(wid, bmlId, scheduleTime, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
                    behToRemove.add(b);
                    break;
                }
                if (!moving) continue;
                continue block10;
            }
        }
        for (Behaviour b : behToRemove) {
            scheduler.removeBehaviour(b.id, b.bmlId);
        }
        logger.debug("Checking behavior validity");
        for (Planner p : scheduler.getPlanners()) {
            logger.debug("Checking behavior validity for planner {}", p.getClass());
            Set<String> invalidBehaviours = p.getInvalidBehaviours();
            for (String id : invalidBehaviours) {
                String bmlId = id.split(":")[0];
                String behId = id.substring(bmlId.length() + 1);
                String wid = "w-" + behId;
                ArrayList modifiedBehaviours = new ArrayList();
                ArrayList<String> droppedBehaviours = new ArrayList<String>();
                droppedBehaviours.add(behId);
                ArrayList modifiedConstraints = new ArrayList();
                String warningText = "Invalid timing for behavior " + id + ", behavior ommitted";
                scheduler.warn(new BMLWarningFeedback(wid, bmlId, scheduleTime, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
                scheduler.removeBehaviour(behId, bmlId);
            }
        }
    }

    private boolean moveBehavior(double move, Behaviour b, ArrayList<TimePeg> movedPegs, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        boolean pegAdded = false;
        TimePeg firstAbsolute = null;
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (!tpac.peg.isAbsoluteTime() || firstAbsolute != null && !(firstAbsolute.getGlobalValue() > tpac.peg.getGlobalValue())) continue;
            firstAbsolute = tpac.peg;
        }
        for (TimePegAndConstraint tpac : syncMap.get(b)) {
            if (movedPegs.contains(tpac.peg.getLink()) || firstAbsolute != null && !(firstAbsolute.getGlobalValue() < tpac.peg.getGlobalValue())) continue;
            logger.debug("Moving {} : {} from {} to {}", new Object[]{b.id, tpac.id, tpac.peg.getGlobalValue(), tpac.peg.getGlobalValue() + move});
            tpac.peg.setGlobalValue(tpac.peg.getGlobalValue() + move);
            movedPegs.add(tpac.peg.getLink());
            pegAdded = true;
        }
        return pegAdded;
    }

    private void movePeg(double move, Behaviour b, HashMap<Behaviour, ArrayList<TimePegAndConstraint>> syncMap) {
        ArrayList<TimePeg> movedPegs = new ArrayList<TimePeg>();
        ArrayList<Behaviour> movedBehaviors = new ArrayList<Behaviour>();
        this.moveBehavior(move, b, movedPegs, syncMap);
        movedBehaviors.add(b);
        boolean pegAdded = true;
        block0: while (pegAdded) {
            pegAdded = false;
            for (Map.Entry<Behaviour, ArrayList<TimePegAndConstraint>> behTpac : syncMap.entrySet()) {
                Behaviour beh = behTpac.getKey();
                if (!movedBehaviors.contains(beh)) {
                    for (TimePegAndConstraint tpac : behTpac.getValue()) {
                        if (!movedPegs.contains(tpac.peg.getLink())) continue;
                        pegAdded = this.moveBehavior(move, beh, movedPegs, syncMap);
                        movedBehaviors.add(beh);
                        if (!pegAdded) continue;
                        break;
                    }
                }
                if (!pegAdded) continue;
                continue block0;
            }
        }
    }

    private static class ConstrInfo {
        String syncId;
        double offset;

        public ConstrInfo(String s, double o) {
            this.syncId = s;
            this.offset = o;
        }
    }
}

