/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningFinishedFeedback;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningListener;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningStartFeedback;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PegBoard;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.planunit.PlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLBlockManager;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SchedulingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BMLScheduler {
    private final Logger logger = LoggerFactory.getLogger((String)BMLScheduler.class.getName());
    private final BMLParser parser;
    private final BMLBlockManager bmlBlocksManager;
    private final Map<Class<? extends Behaviour>, Planner> planSelector;
    @GuardedBy(value="warningListeners")
    private final List<BMLWarningListener> warningListeners;
    @GuardedBy(value="exceptionListeners")
    private final List<BMLExceptionListener> exceptionListeners;
    @GuardedBy(value="feedbackListeners")
    private final List<BMLFeedbackListener> feedbackListeners;
    @GuardedBy(value="planningListeners")
    private final List<BMLTPlanningListener> planningListeners;
    private final Map<String, Anticipator> anticipators;
    private final PegBoard pegBoard;
    private final SchedulingClock schedulingClock;
    private final SchedulingStrategy schedulingStrategy;

    public BMLScheduler(BMLParser s, SchedulingClock c, SchedulingStrategy ss) {
        this.parser = s;
        this.schedulingClock = c;
        this.schedulingStrategy = ss;
        this.pegBoard = new PegBoard();
        this.planSelector = new HashMap<Class<? extends Behaviour>, Planner>();
        this.anticipators = new HashMap<String, Anticipator>();
        this.warningListeners = Collections.synchronizedList(new ArrayList());
        this.exceptionListeners = Collections.synchronizedList(new ArrayList());
        this.feedbackListeners = Collections.synchronizedList(new ArrayList());
        this.planningListeners = Collections.synchronizedList(new ArrayList());
        this.bmlBlocksManager = new BMLBlockManager();
        this.addFeedbackListener(this.bmlBlocksManager);
    }

    public Set<String> getTimedSyncs(String behId, String bmlId) {
        return this.pegBoard.getTimedSyncs(behId, bmlId);
    }

    public PegBoard getPegBoard() {
        return this.pegBoard;
    }

    public List<Planner> getPlanners() {
        ArrayList<Planner> planners = new ArrayList<Planner>();
        for (Planner p : this.planSelector.values()) {
            if (planners.contains(p)) continue;
            planners.add(p);
        }
        return planners;
    }

    public void reset() {
        List<Planner> planners = this.getPlanners();
        for (Planner p : planners) {
            p.reset();
        }
        this.bmlBlocksManager.reset();
    }

    public void clear() {
        for (Planner p : this.getPlanners()) {
            this.logger.debug("clearing {}", p.getClass());
            p.clearAll(this.schedulingClock.getTime());
        }
        this.bmlBlocksManager.clear();
        this.getPegBoard().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlanner(Class<? extends Behaviour> c, Planner p) {
        this.planSelector.put(c, p);
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fb : this.feedbackListeners) {
                p.addFeedbackListener(fb);
            }
        }
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.anticipators.put(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.anticipators.remove(aid);
    }

    public int getNumberOfAnticipators() {
        return this.anticipators.values().size();
    }

    public void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
        for (Planner p : this.getPlanners()) {
            p.addWarningListener(ws);
        }
    }

    public void removeWarningListener(BMLWarningListener ws) {
        this.warningListeners.remove(ws);
    }

    public void removeAllWarningListeners() {
        this.warningListeners.clear();
        for (Planner p : this.getPlanners()) {
            p.removeAllWarningListeners();
        }
    }

    public void removeAllExceptionListeners() {
        this.exceptionListeners.clear();
    }

    public void addExceptionListener(BMLExceptionListener e) {
        this.exceptionListeners.add(e);
    }

    public void removeExceptionListener(BMLExceptionListener e) {
        this.exceptionListeners.remove(e);
    }

    public void addPlanningListener(BMLTPlanningListener p) {
        this.planningListeners.add(p);
    }

    public void addFeedbackListener(BMLFeedbackListener e) {
        this.feedbackListeners.add(e);
        for (Planner p : this.getPlanners()) {
            p.addFeedbackListener(e);
        }
    }

    public void removeFeedbackListener(BMLFeedbackListener e) {
        this.feedbackListeners.remove(e);
        for (Planner p : this.getPlanners()) {
            p.removeFeedbackListener(e);
        }
    }

    public void removeAllFeedbackListeners() {
        this.feedbackListeners.clear();
        for (Planner p : this.getPlanners()) {
            p.removeAllFeedbackListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(BMLWarningFeedback w) {
        List<BMLWarningListener> list = this.warningListeners;
        synchronized (list) {
            for (BMLWarningListener wl : this.warningListeners) {
                wl.warn(w);
            }
        }
    }

    public void planningStart(String bmlId) {
        this.planningStart(new BMLTPlanningStartFeedback("ps-" + bmlId, bmlId, this.schedulingClock.getTime()));
    }

    public void planningFinished(String bmlId) {
        this.planningFinished(new BMLTPlanningFinishedFeedback("ps-" + bmlId, bmlId, this.schedulingClock.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void planningStart(BMLTPlanningStartFeedback bpsf) {
        List<BMLTPlanningListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTPlanningListener pl : this.planningListeners) {
                pl.planningStart(bpsf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void planningFinished(BMLTPlanningFinishedFeedback bpff) {
        List<BMLTPlanningListener> list = this.planningListeners;
        synchronized (list) {
            for (BMLTPlanningListener pl : this.planningListeners) {
                pl.planningFinished(bpff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(BMLExceptionFeedback e) {
        List<BMLExceptionListener> list = this.exceptionListeners;
        synchronized (list) {
            for (BMLExceptionListener e1 : this.exceptionListeners) {
                e1.exception(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockStopFeedback(String bmlId) {
        BMLPerformanceStopFeedback psf = new BMLPerformanceStopFeedback("pfs-" + bmlId, bmlId, "", this.schedulingClock.getTime());
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            ListIterator<BMLFeedbackListener> listIter = this.feedbackListeners.listIterator(this.feedbackListeners.size());
            while (listIter.hasPrevious()) {
                listIter.previous().performanceStop(psf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockStartFeedback(String bmlId) {
        BMLPerformanceStartFeedback psf = new BMLPerformanceStartFeedback("pfs-" + bmlId, bmlId, this.schedulingClock.getTime());
        List<BMLFeedbackListener> list = this.feedbackListeners;
        synchronized (list) {
            for (BMLFeedbackListener fbl : this.feedbackListeners) {
                fbl.performanceStart(psf);
            }
        }
    }

    public Planner getPlanner(Class<? extends Behaviour> c) {
        return this.planSelector.get(c);
    }

    public void removeBehaviour(String id, String bmlId) {
        for (Planner p : this.getPlanners()) {
            p.removeBehaviour(id, bmlId);
        }
        this.pegBoard.removeBehaviour(id, bmlId);
    }

    public double getEndTime(String behId, String bmlId) {
        for (Planner p : this.getPlanners()) {
            double endTime = p.getEndTime(behId, bmlId);
            if (endTime == -1.7976931348623157E308) continue;
            return endTime;
        }
        return -1.7976931348623157E308;
    }

    public Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        for (Planner p : this.getPlanners()) {
            behaviours.addAll(p.getBehaviours(bmlId));
        }
        return behaviours;
    }

    public void schedule() {
        for (BehaviourBlock bb : this.parser.getBehaviourBlocks()) {
            HashSet<String> appendAfter = new HashSet<String>();
            this.planningStart(bb.id);
            switch (bb.getSchedulingMechanism()) {
                case REPLACE: {
                    this.clear();
                    this.reset();
                    break;
                }
                case MERGE: {
                    break;
                }
                case INTERRUPT: {
                    for (String bmlId : bb.getInterruptList()) {
                        this.logger.debug("interrupting {}", (Object)bmlId);
                        this.interruptBlock(bmlId);
                    }
                    break;
                }
                case APPEND: {
                    appendAfter.addAll(this.bmlBlocksManager.getBMLBlocks());
                    break;
                }
                case APPEND_AFTER: {
                    appendAfter.addAll(bb.getAppendList());
                    appendAfter.retainAll(this.bmlBlocksManager.getBMLBlocks());
                }
            }
            BMLBlock bbm = new BMLBlock(bb.id, this, appendAfter, bb.getOnStartList());
            BMLBlockPeg bmlBlockPeg = new BMLBlockPeg(bb.id, this.schedulingClock.getTime());
            this.addFeedbackListener(bbm);
            this.pegBoard.addBMLBlockPeg(bmlBlockPeg);
            this.schedulingStrategy.schedule(bb, bmlBlockPeg, this, this.schedulingClock.getTime());
            this.logger.debug("Scheduling finished at: {}", (Object)this.schedulingClock.getTime());
            this.planningFinished(bb.id);
            this.bmlBlocksManager.addBMLBlock(bbm);
            this.addWarningListener(bbm);
            this.addExceptionListener(bbm);
            if (bb.isPrePlanned()) {
                this.logger.debug("Preplanning {}.", (Object)bb.id);
                bbm.setState(PlanUnitState.PENDING);
            } else {
                switch (bb.getSchedulingMechanism()) {
                    case REPLACE: 
                    case MERGE: 
                    case INTERRUPT: {
                        this.startBlock(bb.id);
                        break;
                    }
                    case APPEND: 
                    case APPEND_AFTER: {
                        bbm.setState(PlanUnitState.LURKING);
                    }
                }
            }
            this.bmlBlocksManager.updateBlocks();
        }
        this.parser.clear();
    }

    public void interruptBehavior(String behaviourId, String bmlId) {
        for (Planner p : this.getPlanners()) {
            p.interruptBehaviour(behaviourId, bmlId, this.schedulingClock.getTime());
        }
        this.bmlBlocksManager.updateBlocks(this.schedulingClock.getTime());
    }

    public void interruptBlock(String bmlId) {
        if (!this.bmlBlocksManager.getBMLBlocks().contains(bmlId)) {
            this.logger.warn("Attempting to stop non existing bml block {}", (Object)bmlId);
            return;
        }
        for (Planner p : this.getPlanners()) {
            p.interruptBehaviourBlock(bmlId, this.schedulingClock.getTime());
        }
        if (this.bmlBlocksManager.getBMLBlockState(bmlId) == PlanUnitState.IN_EXEC || this.bmlBlocksManager.getBMLBlockState(bmlId) == PlanUnitState.SUBSIDING) {
            this.bmlBlocksManager.setBMLBlockState(bmlId, PlanUnitState.DONE);
            this.blockStopFeedback(bmlId);
        }
        this.bmlBlocksManager.removeBMLBlock(bmlId);
    }

    public void startBlock(String bmlId) {
        if (!this.bmlBlocksManager.getBMLBlocks().contains(bmlId)) {
            this.logger.warn("Attempting to start non existing bml block {}", (Object)bmlId);
            return;
        }
        this.pegBoard.setBMLBlockTime(bmlId, this.schedulingClock.getTime());
        this.logger.debug("Starting bml block {}", (Object)bmlId);
        this.bmlBlocksManager.startBlock(bmlId);
        for (Planner p : this.getPlanners()) {
            p.setBMLBlockState(bmlId, PlanUnitState.LURKING);
        }
        this.blockStartFeedback(bmlId);
        this.bmlBlocksManager.activateOnStartBlocks(bmlId, this.schedulingClock.getTime());
        this.bmlBlocksManager.updateBlocks(this.schedulingClock.getTime());
    }

    public Anticipator getAnticipator(String a) {
        return this.anticipators.get(a);
    }

    public BMLParser getParser() {
        return this.parser;
    }

    public Set<BMLSyncPointProgressFeedback> getSyncProgress(String bmlId, String behaviorId) {
        return this.bmlBlocksManager.getSyncProgress(bmlId, behaviorId);
    }

    public Set<String> getSyncsPassed(String bmlId, String behaviorId) {
        return this.bmlBlocksManager.getSyncsPassed(bmlId, behaviorId);
    }
}

