/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.planunit.PlanUnitState;
import hmi.elckerlyc.scheduler.BMLBlock;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLBlockManager
implements BMLFeedbackListener {
    private final ConcurrentHashMap<String, BMLBlock> finishedBMLBlocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BMLBlock> BMLBlocks = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger((String)BMLScheduler.class.getName());
    private final ConcurrentHashMap<BehaviorKey, Set<BMLSyncPointProgressFeedback>> behaviorProgress = new ConcurrentHashMap();

    public void addBMLBlock(BMLBlock bbm) {
        this.BMLBlocks.put(bbm.getBMLId(), bbm);
    }

    public void removeBMLBlock(String bmlId) {
        this.BMLBlocks.remove(bmlId);
        this.finishedBMLBlocks.remove(bmlId);
        this.updateBlocks();
    }

    public void setBMLBlockState(String bmlId, PlanUnitState state) {
        if (this.BMLBlocks.get(bmlId) != null) {
            this.BMLBlocks.get(bmlId).setState(state);
        }
    }

    public void startBlock(String bmlId) {
        this.setBMLBlockState(bmlId, PlanUnitState.IN_EXEC);
    }

    public void activateOnStartBlocks(String bmlId, double time) {
        for (String onStart : this.BMLBlocks.get(bmlId).getOnStartSet()) {
            this.activate(onStart, time);
        }
    }

    public PlanUnitState getBMLBlockState(String bmlId) {
        return this.BMLBlocks.get(bmlId).getState();
    }

    public Set<String> getBMLBlocks() {
        HashSet<String> bmlBlocks = new HashSet<String>();
        for (String bmlId : this.BMLBlocks.keySet()) {
            bmlBlocks.add(bmlId);
        }
        return bmlBlocks;
    }

    void updateBlocks() {
        for (BMLBlock blockMan : this.BMLBlocks.values()) {
            blockMan.update(this.finishedBMLBlocks.keySet(), this.BMLBlocks.keySet());
        }
    }

    void updateBlocks(double time) {
        for (BMLBlock blockMan : this.BMLBlocks.values()) {
            blockMan.updateState(time);
            blockMan.update(this.finishedBMLBlocks.keySet(), this.BMLBlocks.keySet());
        }
    }

    public void clear() {
        for (BMLBlock block : this.BMLBlocks.values()) {
            block.clear();
        }
        this.finishedBMLBlocks.clear();
        this.BMLBlocks.clear();
        this.behaviorProgress.clear();
    }

    public void activate(String bmlId, double time) {
        BMLBlock bb = this.BMLBlocks.get(bmlId);
        if (bb == null) {
            this.logger.warn("Attempting to activate unknown block {}", (Object)bmlId);
            return;
        }
        if (bb.getState() == PlanUnitState.PENDING) {
            bb.setState(PlanUnitState.LURKING);
        }
        this.updateBlocks(time);
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        BMLBlock blockMan = this.BMLBlocks.get(psf.bmlId);
        if (blockMan == null) {
            return;
        }
        this.finishedBMLBlocks.put(psf.bmlId, blockMan);
        this.updateBlocks();
    }

    public void reset() {
        this.behaviorProgress.clear();
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        this.updateBlocks();
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        Set<Object> syncs = this.behaviorProgress.get(new BehaviorKey(spp.behaviorId, spp.bmlId));
        if (syncs == null) {
            syncs = Collections.synchronizedSet(new HashSet());
            this.behaviorProgress.put(new BehaviorKey(spp.behaviorId, spp.bmlId), syncs);
        }
        this.logger.debug("Adding sync {}:{}:{} to behaviorProgress", (Object[])new String[]{spp.bmlId, spp.behaviorId, spp.syncId});
        syncs.add(spp);
    }

    public Set<BMLSyncPointProgressFeedback> getSyncProgress(String bmlId, String behaviorId) {
        HashSet<BMLSyncPointProgressFeedback> progress = new HashSet<BMLSyncPointProgressFeedback>();
        Set<BMLSyncPointProgressFeedback> sppf = this.behaviorProgress.get(new BehaviorKey(behaviorId, bmlId));
        if (sppf == null) {
            return progress;
        }
        for (BMLSyncPointProgressFeedback spp : sppf) {
            progress.add(new BMLSyncPointProgressFeedback(spp));
        }
        return progress;
    }

    public Set<String> getSyncsPassed(String bmlId, String behaviorId) {
        HashSet<String> progress = new HashSet<String>();
        Set<BMLSyncPointProgressFeedback> sppf = this.behaviorProgress.get(new BehaviorKey(behaviorId, bmlId));
        if (sppf == null) {
            return progress;
        }
        for (BMLSyncPointProgressFeedback spp : sppf) {
            progress.add(spp.syncId);
        }
        return progress;
    }

    private static class BehaviorKey {
        final String id;
        final String bmlId;

        public BehaviorKey(String id, String bmlId) {
            this.id = id;
            this.bmlId = bmlId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BehaviorKey)) {
                return false;
            }
            BehaviorKey pk = (BehaviorKey)o;
            return pk.bmlId.equals(this.bmlId) && pk.id.equals(this.id);
        }

        public int hashCode() {
            return 17 + this.id.hashCode() * 31 + this.bmlId.hashCode() * 31 * 31;
        }
    }
}

