/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.scheduler;

import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.planunit.PlanUnitState;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMLBlock
implements BMLWarningListener,
BMLFeedbackListener,
BMLExceptionListener {
    private final String bmlId;
    private final BMLScheduler scheduler;
    private PlanUnitState state;
    private static Logger logger = LoggerFactory.getLogger((String)BMLBlock.class.getName());
    private final ConcurrentHashMap<String, Set<String>> behaviorInfo = new ConcurrentHashMap();
    private final Set<String> appendSet = new CopyOnWriteArraySet<String>();
    private final Set<String> onStartSet = new CopyOnWriteArraySet<String>();
    private final Set<String> droppedBehaviours = new CopyOnWriteArraySet<String>();

    public Set<String> getOnStartSet() {
        return Collections.unmodifiableSet(this.onStartSet);
    }

    public BMLBlock(String id, BMLScheduler s, Set<String> appendAfter, Set<String> onStart) {
        this.bmlId = id;
        this.scheduler = s;
        this.appendSet.addAll(appendAfter);
        this.onStartSet.addAll(onStart);
        this.state = PlanUnitState.IN_PREP;
    }

    public BMLBlock(String id, BMLScheduler s) {
        this(id, s, new HashSet<String>(), new HashSet<String>());
    }

    public void clear() {
        this.scheduler.removeFeedbackListener(this);
        this.scheduler.removeWarningListener(this);
        this.scheduler.removeExceptionListener(this);
        this.droppedBehaviours.clear();
    }

    public void update(Set<String> finishedBMLBlocks, Set<String> allBlocks) {
        this.appendSet.retainAll(allBlocks);
        for (String apId : this.appendSet) {
            if (finishedBMLBlocks.contains(apId)) continue;
            return;
        }
        if (this.state == PlanUnitState.LURKING) {
            this.scheduler.startBlock(this.bmlId);
        }
    }

    private boolean isFinished(double timeStamp) {
        for (String behId : this.scheduler.getBehaviours(this.bmlId)) {
            if (this.droppedBehaviours.contains(behId)) continue;
            logger.debug("isFinished {}:{}", (Object)this.bmlId, (Object)behId);
            for (String syncId : this.scheduler.getTimedSyncs(behId, this.bmlId)) {
                if (this.behaviorInfo.get(behId) == null) {
                    return false;
                }
                if (this.behaviorInfo.get(behId).contains(syncId)) continue;
                return false;
            }
            if (this.scheduler.getEndTime(behId, this.bmlId) == -1.7976931348623157E308) continue;
            if (this.scheduler.getEndTime(behId, this.bmlId) > timeStamp) {
                return false;
            }
            if (this.behaviorInfo.get(behId).contains("end")) continue;
            return false;
        }
        return true;
    }

    void updateState(double timeStamp) {
        if (this.state == PlanUnitState.DONE) {
            return;
        }
        if (this.state == PlanUnitState.PENDING) {
            return;
        }
        if (this.state == PlanUnitState.LURKING) {
            return;
        }
        if (this.isFinished(timeStamp)) {
            logger.debug("bml block {} finished", (Object)this.bmlId);
            this.scheduler.blockStopFeedback(this.bmlId);
            this.state = PlanUnitState.DONE;
        }
    }

    public void warn(BMLWarningFeedback bw) {
        if (bw.bmlId.equals(this.bmlId)) {
            logger.debug("Warning reached BML block {}.", (Object)this.bmlId);
            this.droppedBehaviours.addAll(bw.droppedBehaviours);
            this.updateState(bw.timeStamp);
        }
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        if (spp.bmlId.equals(this.bmlId)) {
            if (this.behaviorInfo.get(spp.behaviorId) == null) {
                this.behaviorInfo.put(spp.behaviorId, new HashSet());
            }
            this.behaviorInfo.get(spp.behaviorId).add(spp.syncId);
            this.updateState(spp.timeStamp);
        }
    }

    public void setState(PlanUnitState state) {
        this.state = state;
    }

    public PlanUnitState getState() {
        return this.state;
    }

    public void exception(BMLExceptionFeedback be) {
        if (be.bmlId.equals(this.bmlId)) {
            // empty if block
        }
    }

    public String getBMLId() {
        return this.bmlId;
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
    }
}

