/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.planunit.PUWarningCallback;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PlanPlayer {
    private List<PlanUnit> planUnits = new ArrayList<PlanUnit>();
    private List<PlanUnit> playingPlanUnits = new ArrayList<PlanUnit>();
    private static final Logger logger = LoggerFactory.getLogger((String)PlanUnitTimeManager.class.getName());

    public synchronized void play(double t) {
        this.play(t, null);
    }

    private boolean updatePlayingPU(PlanUnit pu, PUWarningCallback puWc, double t) {
        ArrayList<PlanUnit> remove = new ArrayList<PlanUnit>();
        boolean play = true;
        PlanUnit replacementOverlap = null;
        for (PlanUnit planUnitPlay : this.playingPlanUnits) {
            if (planUnitPlay.getReplacementGroup() == null || !planUnitPlay.getReplacementGroup().equals(pu.getReplacementGroup())) continue;
            boolean runPuPlay = false;
            double puPlayEnd = planUnitPlay.getEndTime();
            double puEnd = pu.getEndTime();
            if (t >= planUnitPlay.getEndTime() && planUnitPlay.getEndTime() != -1.7976931348623157E308) {
                try {
                    planUnitPlay.stop(t);
                }
                catch (PlayException e) {
                    // empty catch block
                }
                runPuPlay = false;
            } else if (t >= pu.getEndTime() && pu.getEndTime() != -1.7976931348623157E308) {
                try {
                    pu.stop(t);
                }
                catch (PlayException e) {
                    // empty catch block
                }
                runPuPlay = true;
            } else if (planUnitPlay.getStartTime() > pu.getStartTime()) {
                runPuPlay = true;
            } else if (planUnitPlay.getStartTime() < pu.getStartTime()) {
                runPuPlay = false;
            } else if (puEnd == -1.7976931348623157E308 && puPlayEnd != -1.7976931348623157E308) {
                runPuPlay = true;
            } else if (puEnd != -1.7976931348623157E308 && puPlayEnd == -1.7976931348623157E308) {
                runPuPlay = false;
            } else if (puEnd == -1.7976931348623157E308 && puPlayEnd == -1.7976931348623157E308) {
                replacementOverlap = planUnitPlay;
                runPuPlay = false;
            } else if (puPlayEnd < puEnd) {
                runPuPlay = true;
            } else if (puPlayEnd == puEnd) {
                replacementOverlap = planUnitPlay;
                runPuPlay = false;
            }
            if (runPuPlay) {
                play = false;
                break;
            }
            remove.add(planUnitPlay);
            if (replacementOverlap == null) continue;
            break;
        }
        this.playingPlanUnits.removeAll(remove);
        if (replacementOverlap != null) {
            puWc.puWarning(replacementOverlap, "Replacement group overlap between " + pu.getBMLId() + ":" + pu.getId() + " and " + replacementOverlap.getBMLId() + ":" + replacementOverlap.getId(), t);
        }
        return play;
    }

    public synchronized void play(double t, PUWarningCallback puWc) {
        this.playingPlanUnits.clear();
        for (PlanUnit pu : this.planUnits) {
            if (!(t >= pu.getStartTime()) || !pu.isPlaying() && !pu.isLurking() || !this.updatePlayingPU(pu, puWc, t)) continue;
            this.playingPlanUnits.add(pu);
        }
        for (PlanUnit pu : this.playingPlanUnits) {
            try {
                if (pu.isLurking()) {
                    pu.start(t);
                }
                pu.play(t);
            }
            catch (PlayException ex) {
                if (puWc == null) continue;
                puWc.puWarning(pu, "Runtime exception for behavior " + pu.getBMLId() + ":" + pu.getId() + ":" + ex.getLocalizedMessage() + ".", t);
            }
        }
    }

    public synchronized Set<String> getInvalidBehaviors() {
        HashSet<String> invalidBehaviours = new HashSet<String>();
        for (PlanUnit pu : this.planUnits) {
            if (pu.hasValidTiming()) continue;
            invalidBehaviours.add(pu.getBMLId() + ":" + pu.getId());
        }
        return invalidBehaviours;
    }

    public synchronized void addPlanUnit(PlanUnit pu) {
        this.planUnits.add(pu);
    }

    public synchronized void removePlanUnits(Collection<PlanUnit> puRemove, double time) {
        for (PlanUnit pu : puRemove) {
            logger.debug("Removing planunit {}:{}", (Object)pu.getBMLId(), (Object)pu.getId());
            if (!pu.isPlaying()) continue;
            try {
                pu.stop(time);
            }
            catch (PlayException e) {
                logger.warn("Exception stopping behaviour: ", (Throwable)e);
            }
        }
        this.planUnits.removeAll(puRemove);
    }

    public synchronized void interruptPlanUnit(String id, String bmlId, double globalTime) {
        PlanUnit pu = this.getPlanUnit(id, bmlId);
        while (pu != null) {
            if (pu.isPlaying()) {
                try {
                    pu.stop(globalTime);
                }
                catch (PlayException e) {
                    logger.warn("Exception stopping behaviour: ", (Throwable)e);
                }
            }
            this.planUnits.remove(pu);
            pu = this.getPlanUnit(id, bmlId);
        }
    }

    public synchronized void setBMLBlockState(String bmlId, PlanUnitState state) {
        for (PlanUnit pu : this.planUnits) {
            if (!pu.getBMLId().equals(bmlId)) continue;
            logger.debug("Setting BML block state of {}:{} to {}.", (Object[])new String[]{pu.getBMLId(), pu.getId(), state.toString()});
            pu.setState(state);
        }
    }

    public synchronized int getNumberOfPlanUnits() {
        return this.planUnits.size();
    }

    private synchronized PlanUnit getPlanUnit(String id, String bmlId) {
        for (PlanUnit pu : this.planUnits) {
            if (!pu.getId().equals(id) || !pu.getBMLId().equals(bmlId)) continue;
            return pu;
        }
        return null;
    }

    public synchronized void reset() {
        for (PlanUnit pu : this.planUnits) {
            pu.reset();
        }
    }

    public synchronized void clearAll(double time) {
        this.removePlanUnits(this.planUnits, time);
    }

    public synchronized Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        for (PlanUnit pu : this.planUnits) {
            if (!pu.getBMLId().equals(bmlId)) continue;
            behaviours.add(pu.getId());
        }
        return behaviours;
    }

    public synchronized double getEndTime(String behId, String bmlId) {
        PlanUnit pu = this.getPlanUnit(behId, bmlId);
        if (pu == null) {
            return -1.7976931348623157E308;
        }
        return pu.getEndTime();
    }

    public synchronized void interruptBehaviourBlock(String bmlId, double time) {
        ArrayList<PlanUnit> removeUnits = new ArrayList<PlanUnit>();
        for (PlanUnit pu : this.planUnits) {
            if (!pu.getBMLId().equals(bmlId)) continue;
            removeUnits.add(pu);
            try {
                pu.stop(time);
            }
            catch (PlayException e) {
                logger.warn("Exception when interrupting behavior " + pu, (Throwable)e);
            }
        }
        this.removePlanUnits(removeUnits, time);
    }
}

