/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.planunit;

import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import java.util.ArrayList;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPlanUnit
implements PlanUnit {
    protected final BMLBlockPeg bmlBlockPeg;
    private boolean subUnit;
    private final String id;
    private final String bmlBlockId;
    private final ArrayList<BMLFeedbackListener> feedbackListeners = new ArrayList();
    private static Logger logger = LoggerFactory.getLogger((String)AbstractPlanUnit.class.getName());
    @GuardedBy(value="this")
    private PlanUnitState state;

    public AbstractPlanUnit(BMLBlockPeg bmlPeg, String i, String bmlId, boolean sub) {
        this.bmlBlockPeg = bmlPeg;
        this.id = i;
        this.bmlBlockId = bmlId;
        this.state = PlanUnitState.IN_PREP;
        this.subUnit = sub;
    }

    public AbstractPlanUnit(BMLBlockPeg bmlPeg, String i, String bmlId) {
        this(bmlPeg, i, bmlId, false);
    }

    public void setSubUnit(boolean sub) {
        this.subUnit = sub;
    }

    protected abstract void playUnit(double var1) throws PlayException;

    protected abstract void stopUnit(double var1) throws PlayException;

    protected void startUnit(double time) throws PlayException {
    }

    protected void resetUnit() {
    }

    @Override
    public boolean isSubUnit() {
        return this.subUnit;
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public final void play(double time) throws PlayException {
        if (!this.isPlaying()) {
            return;
        }
        if (time < this.getStartTime() || this.getStartTime() == -1.7976931348623157E308) {
            if (!this.isSubUnit()) {
                throw new PlayException("Calling play with time :" + time + "< startTime(" + this.getStartTime() + ").");
            }
            logger.warn("Calling sub unit play with time : {} < startTime({}).", (Object)time, (Object)this.getStartTime());
        }
        if (time < this.getEndTime() || this.getEndTime() == -1.7976931348623157E308) {
            this.playUnit(time);
        } else {
            this.stop(time);
        }
    }

    @Override
    public final void reset() {
        switch (this.getState()) {
            case IN_EXEC: 
            case SUBSIDING: 
            case DONE: {
                this.resetUnit();
                this.setState(PlanUnitState.LURKING);
            }
        }
    }

    @Override
    public final void stop(double time) throws PlayException {
        if (this.isPlaying()) {
            this.setState(PlanUnitState.DONE);
            this.stopUnit(time);
        }
    }

    @Override
    public final void start(double time) throws PlayException {
        logger.debug("attempting to start planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
        if (!this.isLurking()) {
            return;
        }
        if (time > this.getEndTime() && this.getEndTime() != -1.7976931348623157E308) {
            this.setState(PlanUnitState.DONE);
            if (!this.isSubUnit()) {
                throw new PlayException("Starting behaviour at time " + time + " past end time " + this.getEndTime() + ", behaviour was never executed.");
            }
            logger.warn("Starting behaviour at time {} past end time {}, behaviour was never executed.", (Object)time, (Object)this.getEndTime());
        } else {
            this.setState(PlanUnitState.IN_EXEC);
            this.startUnit(time);
        }
        logger.debug("started planunit {}:{}", (Object)this.bmlBlockId, (Object)this.id);
    }

    @Override
    public BMLBlockPeg getBMLBlockPeg() {
        return this.bmlBlockPeg;
    }

    @Override
    public String getBMLId() {
        return this.bmlBlockId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void feedback(BMLSyncPointProgressFeedback fb) {
        for (BMLFeedbackListener fbl : this.feedbackListeners) {
            fbl.syncProgress(fb);
        }
    }

    @Override
    public void addFeedbackListener(BMLFeedbackListener fb) {
        this.feedbackListeners.add(fb);
    }

    @Override
    public synchronized void setState(PlanUnitState newState) {
        this.state = newState;
    }

    @Override
    public synchronized PlanUnitState getState() {
        return this.state;
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.state.isPlaying();
    }

    @Override
    public synchronized boolean isLurking() {
        return this.state.isLurking();
    }

    @Override
    public synchronized boolean isDone() {
        return this.state.isDone();
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }
}

