/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.interrupt.InterruptSpec;
import hmi.elckerlyc.planunit.AbstractPlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptUnit
extends AbstractPlanUnit {
    private static final Logger logger = LoggerFactory.getLogger((String)InterruptUnit.class.getName());
    private TimePeg startPeg;
    private final BMLScheduler scheduler;
    private final String target;
    private Map<String, InterruptSpec> interruptSpecMap = new HashMap<String, InterruptSpec>();

    public void setStartPeg(TimePeg startPeg) {
        this.startPeg = startPeg;
        logger.debug("Setting start peg to {}", (Object)startPeg);
    }

    public InterruptUnit(BMLBlockPeg bmlPeg, String i, String bmlId, String iTarget, BMLScheduler s) {
        super(bmlPeg, i, bmlId);
        this.scheduler = s;
        this.target = iTarget;
        logger.debug("Created interrupt unit {} {} {}", (Object[])new String[]{this.getBMLId(), this.getId(), this.target});
    }

    public void addInterruptSpec(InterruptSpec s) {
        this.interruptSpecMap.put(s.getBehaviour(), s);
    }

    @Override
    protected void startUnit(double time) throws PlayException {
        logger.debug("Starting interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        Set<String> stopBehs = this.scheduler.getBehaviours(this.target);
        stopBehs.removeAll(this.interruptSpecMap.keySet());
        for (String beh : stopBehs) {
            logger.debug("Immidiatly interrupting behavior {}:{}", (Object)this.target, (Object)beh);
            this.scheduler.interruptBehavior(beh, this.target);
        }
        this.sendFeedback("start", time);
        this.sendFeedback("ready", time);
        this.sendFeedback("stroke-start", time);
        this.sendFeedback("stroke", time);
    }

    private void sendFeedback(String syncId, double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    @Override
    protected void playUnit(double time) throws PlayException {
        for (String beh : this.interruptSpecMap.keySet()) {
            if (!this.scheduler.getBehaviours(this.target).contains(beh)) {
                logger.debug("Behavior {}:{} not planned, prematurely removed from interrupt unit", (Object)this.target, (Object)beh);
                this.interruptSpecMap.remove(beh);
                break;
            }
            Set<String> syncsFinished = this.scheduler.getSyncsPassed(this.target, beh);
            if (!syncsFinished.contains(this.interruptSpecMap.get(beh).getSyncPoint())) continue;
            logger.debug("Interrupting {}:{}", (Object)this.target, (Object)beh);
            this.scheduler.interruptBehavior(beh, this.target);
            for (String onStartBlock : this.interruptSpecMap.get(beh).getOnStartList()) {
                this.scheduler.startBlock(onStartBlock);
            }
            this.interruptSpecMap.remove(beh);
        }
        if (this.interruptSpecMap.isEmpty()) {
            this.stop(time);
        }
    }

    @Override
    protected void stopUnit(double time) throws PlayException {
        logger.debug("stopping interrupt unit {} {}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendFeedback("stroke-end", time);
        this.sendFeedback("relax", time);
        this.sendFeedback("end", time);
    }

    @Override
    public double getEndTime() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getStartTime() {
        return this.startPeg.getGlobalValue();
    }

    @Override
    public boolean hasValidTiming() {
        return true;
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getStartTime();
        }
        return -1.7976931348623157E308;
    }
}

