/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.WarningManager;
import hmi.elckerlyc.interrupt.InterruptUnit;
import hmi.elckerlyc.planunit.PUWarningCallback;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptPlayer
implements PUWarningCallback,
Player {
    private final PlanPlayer planPlayer;
    private final WarningManager warningManager = new WarningManager();
    private static final Logger logger = LoggerFactory.getLogger((String)InterruptPlayer.class.getName());

    public InterruptPlayer() {
        this.planPlayer = new PlanPlayer();
    }

    public synchronized void play(double time) {
        this.planPlayer.play(time);
    }

    @Override
    public void puWarning(PlanUnit pu, String message, double time) {
        this.warningManager.puWarning(pu, message, time);
    }

    @Override
    public void addWarningListener(BMLWarningListener ws) {
        this.warningManager.addWarningListener(ws);
    }

    @Override
    public void removeAllWarningListeners() {
        this.warningManager.removeAllWarningListeners();
    }

    public synchronized void clearAll(double time) {
        this.planPlayer.clearAll(time);
    }

    public synchronized void interruptBehaviour(String behaviourId, String bmlId, double globalTime) {
        this.planPlayer.interruptPlanUnit(behaviourId, bmlId, globalTime);
    }

    public synchronized void addPlanUnit(InterruptUnit iu) {
        logger.debug("InterruptPlayer.addPlanUnit {} {}", (Object)iu.getBMLId(), (Object)iu.getId());
        this.planPlayer.addPlanUnit(iu);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.planPlayer.getBehaviours(bmlId);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.planPlayer.getEndTime(behId, bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.planPlayer.interruptBehaviourBlock(bmlId, time);
    }

    @Override
    public void reset() {
        this.planPlayer.reset();
    }

    @Override
    public void setBMLBlockState(String bmlId, PlanUnitState state) {
        this.planPlayer.setBMLBlockState(bmlId, state);
    }
}

