/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.interrupt;

import hmi.bml.core.Behaviour;
import hmi.bml.ext.bmlt.BMLTInterruptBehaviour;
import hmi.bml.ext.bmlt.BMLTInterruptSpec;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.interrupt.InterruptPlayer;
import hmi.elckerlyc.interrupt.InterruptSpec;
import hmi.elckerlyc.interrupt.InterruptUnit;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InterruptPlanner
extends AbstractPlanner {
    private BMLScheduler scheduler;
    private final InterruptPlayer player;

    public InterruptPlanner(InterruptPlayer p, BMLScheduler s) {
        this.player = p;
        this.scheduler = s;
    }

    public InterruptPlanner(InterruptPlayer p) {
        this.player = p;
    }

    public void setScheduler(BMLScheduler s) {
        this.scheduler = s;
    }

    public InterruptPlayer getInterruptPlayer() {
        return this.player;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sac, PlanUnit planElement) throws BehaviourPlanningException {
        if (!(b instanceof BMLTInterruptBehaviour)) {
            throw new BehaviourPlanningException(b, "Behaviour is not a BMLTInterruptBehaviour");
        }
        BMLTInterruptBehaviour ib = (BMLTInterruptBehaviour)b;
        InterruptUnit iu = planElement == null ? new InterruptUnit(bbPeg, b.id, b.bmlId, ib.getTarget(), this.scheduler) : (InterruptUnit)planElement;
        for (BMLTInterruptSpec s : ib.getInterruptSpecs()) {
            iu.addInterruptSpec(new InterruptSpec(s.getBehavior(), s.getInterruptSync(), s.getOnStartList()));
        }
        this.validateSacs(b, sac);
        iu.setStartPeg(sac.get((int)0).peg);
        this.player.addPlanUnit(iu);
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            iu.addFeedbackListener(fb);
        }
        ArrayList<SyncAndTimePeg> list = new ArrayList<SyncAndTimePeg>();
        list.add(new SyncAndTimePeg("start", b.id, b.bmlId, sac.get((int)0).peg));
        return list;
    }

    private void validateSacs(Behaviour b, ArrayList<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        if (sac.size() > 1) {
            throw new BehaviourPlanningException(b, "Multiple synchronization constraints on to interrupt behavior " + b);
        }
        if (!sac.get((int)0).id.equals("start")) {
            throw new BehaviourPlanningException(b, "Interrupt behavior " + b + " has a synchronization constraint other than start.");
        }
    }

    @Override
    public InterruptUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        InterruptUnit iu = new InterruptUnit(bbPeg, b.id, b.bmlId, b.getStringParameterValue("target"), this.scheduler);
        this.validateSacs(b, sac);
        TimePegAndConstraint sacStart = sac.get(0);
        if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
            sacStart.peg.setLocalValue(0.0);
        }
        iu.setStartPeg(sacStart.peg);
        return iu;
    }

    @Override
    public void addWarningListener(BMLWarningListener war) {
        this.player.addWarningListener(war);
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return new HashSet<String>();
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTInterruptBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        return list;
    }

    @Override
    public void removeAllWarningListeners() {
        this.player.removeAllWarningListeners();
    }

    @Override
    public void removeBehaviour(String behaviourId, String bmlId) {
        this.player.interruptBehaviour(behaviourId, bmlId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String bmlId, double globalTime) {
        this.player.interruptBehaviour(behaviourId, bmlId, globalTime);
    }

    @Override
    public void reset() {
        this.player.reset();
    }
}

