/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine.faceunit;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.faceunit.FUPlayException;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TFUPlayException;
import hmi.elckerlyc.planunit.AbstractPlanUnit;
import hmi.elckerlyc.planunit.PlanUnitTimeManager;
import java.util.ArrayList;
import java.util.Map;

public class TimedFaceUnit
extends AbstractPlanUnit {
    public final FaceUnit fu;
    protected ArrayList<KeyPosition> progressHandled = new ArrayList();
    private final PlanUnitTimeManager puTimeManager;

    public TimedFaceUnit(BMLBlockPeg bbPeg, String i, String bmlId, FaceUnit f) {
        super(bbPeg, i, bmlId);
        this.fu = f;
        this.puTimeManager = new PlanUnitTimeManager(f);
    }

    @Override
    public boolean hasValidTiming() {
        return this.puTimeManager.hasValidTiming();
    }

    public Map<KeyPosition, TimePeg> getPegs() {
        return this.puTimeManager.getPegs();
    }

    public KeyPosition getKeyPosition(TimePeg sp) {
        return this.puTimeManager.getKeyPosition(sp);
    }

    public double getPrevPegTime(String pid) {
        return this.puTimeManager.getPrevPegTime(pid);
    }

    public double getNextPegTime(String pid) {
        return this.puTimeManager.getNextPegTime(pid);
    }

    public double getPegTime(String pid) {
        return this.puTimeManager.getPegTime(pid);
    }

    public TimePeg getTimePeg(String pid) {
        return this.puTimeManager.getTimePeg(pid);
    }

    @Override
    public double getEndTime() {
        return this.puTimeManager.getEndTime();
    }

    public void setTimePeg(String kid, TimePeg sp) {
        this.puTimeManager.setTimePeg(kid, sp);
    }

    public void setTimePeg(KeyPosition kp, TimePeg sp) {
        this.puTimeManager.setTimePeg(kp, sp);
    }

    @Override
    public double getStartTime() {
        return this.puTimeManager.getStartTime();
    }

    @Override
    public double getTime(String syncId) {
        return this.puTimeManager.getPegTime(syncId);
    }

    public KeyPosition getKeyPosition(String kid) {
        return this.fu.getKeyPosition(kid);
    }

    private void sendProgress(double t, double time) {
        for (KeyPosition k : this.fu.getKeyPositions()) {
            if (k.time <= t) {
                if (this.progressHandled.contains(k)) continue;
                String bmlId = this.getBMLId();
                String behaviorId = this.getId();
                String syncId = k.id;
                String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(k);
                continue;
            }
            if (!this.progressHandled.contains(k)) continue;
            this.progressHandled.remove(k);
        }
    }

    @Override
    public void playUnit(double time) throws PlayException {
        double t = this.puTimeManager.getRelativeTime(time);
        try {
            this.fu.play(t);
        }
        catch (FUPlayException ex) {
            TFUPlayException tfpe = new TFUPlayException(ex.getLocalizedMessage(), this);
            tfpe.initCause(ex);
            throw tfpe;
        }
        this.sendProgress(t, time);
    }

    public void cleanup() {
        this.fu.cleanup();
    }

    public FaceUnit getFaceUnit() {
        return this.fu;
    }

    @Override
    protected void stopUnit(double time) throws PlayException {
        this.sendProgress(1.0, time);
        this.cleanup();
    }

    @Override
    public String getReplacementGroup() {
        return this.fu.getReplacementGroup();
    }

    @Override
    public double getPreferedDuration() {
        return this.fu.getPreferedDuration();
    }
}

