/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.animation.AnimationSync;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.faceunit.FUPlayException;
import hmi.elckerlyc.faceengine.faceunit.FaceUnit;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import java.util.List;

public class MorphFU
implements FaceUnit {
    private float intensity = 1.0f;
    private String targetName = "";
    private boolean multiple = false;
    private final KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private String[] morphTargets = new String[]{""};
    private FacePlayer facePlayer;
    private float prevMorphedWeight = 0.0f;

    public MorphFU() {
        KeyPosition ready = new KeyPosition("ready", 0.1, 1.0);
        KeyPosition relax = new KeyPosition("relax", 0.9, 1.0);
        KeyPosition start = new KeyPosition("start", 0.0, 1.0);
        KeyPosition end = new KeyPosition("end", 1.0, 1.0);
        this.addKeyPosition(start);
        this.addKeyPosition(ready);
        this.addKeyPosition(relax);
        this.addKeyPosition(end);
    }

    public void setFacePlayer(FacePlayer fp) {
        this.facePlayer = fp;
    }

    @Override
    public void setParameterValue(String name, float value) {
        if (name.equals("intensity")) {
            this.intensity = value;
        }
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("targetname")) {
            this.targetName = value;
            this.updateMorphTargets();
        } else if (name.equals("multiple")) {
            this.multiple = Boolean.parseBoolean(value);
            this.updateMorphTargets();
        } else {
            this.setParameterValue(name, Float.parseFloat(value));
        }
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("intensity")) {
            return "" + this.intensity;
        }
        if (name.equals("targetname")) {
            return "" + this.targetName;
        }
        if (name.equals("multiple")) {
            return "" + this.multiple;
        }
        return null;
    }

    @Override
    public boolean hasValidParameters() {
        return true;
    }

    private void updateMorphTargets() {
        this.morphTargets = !this.multiple ? new String[]{this.targetName} : this.targetName.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(double t) throws FUPlayException {
        double ready = this.getKeyPosition((String)"ready").time;
        double relax = this.getKeyPosition((String)"relax").time;
        float newMorphedWeight = 0.0f;
        if (t < ready && t > 0.0) {
            newMorphedWeight = this.intensity * (float)(t / ready);
        } else if (t >= ready && t <= relax) {
            newMorphedWeight = this.intensity;
        } else if (t > relax && t < 1.0) {
            newMorphedWeight = this.intensity * (float)(1.0 - (t - relax) / (1.0 - relax));
        }
        float[] prevWeights = new float[this.morphTargets.length];
        for (int i = 0; i < prevWeights.length; ++i) {
            prevWeights[i] = this.prevMorphedWeight;
        }
        Object object = AnimationSync.getSync();
        synchronized (object) {
            this.facePlayer.getFaceController().removeMorphTargets(this.morphTargets, prevWeights);
            float[] newWeights = new float[this.morphTargets.length];
            for (int i = 0; i < newWeights.length; ++i) {
                newWeights[i] = newMorphedWeight;
            }
            this.facePlayer.getFaceController().addMorphTargets(this.morphTargets, newWeights);
        }
        this.prevMorphedWeight = newMorphedWeight;
    }

    @Override
    public void cleanup() {
        float[] prevWeights = new float[this.morphTargets.length];
        for (int i = 0; i < prevWeights.length; ++i) {
            prevWeights[i] = this.prevMorphedWeight;
        }
        this.facePlayer.getFaceController().removeMorphTargets(this.morphTargets, prevWeights);
        this.prevMorphedWeight = 0.0f;
    }

    @Override
    public TimedFaceUnit createTFU(BMLBlockPeg bbPeg, String i, String bmlId) {
        return new TimedFaceUnit(bbPeg, i, bmlId, this);
    }

    @Override
    public String getReplacementGroup() {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 1.0;
    }

    @Override
    public FaceUnit copy(FacePlayer fp) {
        MorphFU result = new MorphFU();
        result.setFacePlayer(fp);
        result.setParameterValue("intensity", this.intensity);
        result.setParameterValue("targetname", this.targetName);
        result.setParameterValue("multiple", "" + this.multiple);
        for (KeyPosition keypos : this.getKeyPositions()) {
            result.addKeyPosition(keypos.deepCopy());
        }
        return result;
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

