/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.faceengine;

import hmi.bml.BMLSync;
import hmi.bml.core.Behaviour;
import hmi.bml.core.FaceBehaviour;
import hmi.bml.ext.bmlt.BMLTBlinkModelChangeBehaviour;
import hmi.bml.ext.bmlt.BMLTGazePatternChangeBehaviour;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.AbstractPlanner;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.BehaviourPlanningException;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.SyncAndTimePeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.faceengine.FacePlayer;
import hmi.elckerlyc.faceengine.facebinding.FaceBinding;
import hmi.elckerlyc.faceengine.faceunit.TimedFaceUnit;
import hmi.elckerlyc.faceengine.viseme.VisemeBinding;
import hmi.elckerlyc.planunit.PlanUnit;
import hmi.elckerlyc.scheduler.TimePegAndConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacePlanner
extends AbstractPlanner {
    private static Logger logger = LoggerFactory.getLogger((String)FacePlanner.class.getName());
    private FacePlayer player;
    private FaceBinding faceBinding;
    private VisemeBinding visemeBinding;

    public FacePlanner(FacePlayer p, FaceBinding fb, VisemeBinding vb) {
        this.faceBinding = fb;
        this.player = p;
        this.visemeBinding = vb;
    }

    public FacePlayer getFacePlayer() {
        return this.player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public FaceBinding getFaceBinding() {
        return this.faceBinding;
    }

    public VisemeBinding getVisemeBinding() {
        return this.visemeBinding;
    }

    @Override
    public List<SyncAndTimePeg> addBehaviour(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sacs, PlanUnit planElement) throws BehaviourPlanningException {
        TimedFaceUnit tfu;
        ArrayList<SyncAndTimePeg> satps = new ArrayList<SyncAndTimePeg>();
        if (planElement == null) {
            List<TimedFaceUnit> tfus = this.faceBinding.getFaceUnit(bbPeg, b, this.player);
            if (tfus.isEmpty()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding (no matching constraints), behavior omitted.");
            }
            tfu = tfus.get(0);
            if (!tfu.getFaceUnit().hasValidParameters()) {
                throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding because the parameters are not valid, behavior omitted.");
            }
        } else {
            tfu = (TimedFaceUnit)planElement;
        }
        this.resolveDefaultBMLKeyPositions(tfu);
        this.linkSynchs(tfu, sacs);
        for (BMLFeedbackListener fb : this.getFeedbackListeners()) {
            tfu.addFeedbackListener(fb);
        }
        this.player.addTimedFaceUnit(tfu);
        for (KeyPosition kp : tfu.getPegs().keySet()) {
            TimePeg p = tfu.getPegs().get(kp);
            satps.add(new SyncAndTimePeg(kp.id, b.id, b.bmlId, p));
        }
        return satps;
    }

    public void resolveDefaultBMLKeyPositions(TimedFaceUnit tfu) {
        double left = 0.0;
        double right = 1.0;
        KeyPosition kp = tfu.getKeyPosition(BMLSync.START.getId());
        if (kp == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.START.getId(), 0.0, 0.0));
        }
        if ((kp = tfu.getKeyPosition(BMLSync.END.getId())) == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.END.getId(), 1.0, 1.0));
        }
        if ((kp = tfu.getKeyPosition(BMLSync.READY.getId())) == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.READY.getId(), 0.0, 0.01));
        } else {
            left = kp.time;
        }
        kp = tfu.getKeyPosition(BMLSync.RELAX.getId());
        if (kp == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.RELAX.getId(), 1.0, 0.01));
        } else {
            right = kp.time;
        }
        kp = tfu.getKeyPosition(BMLSync.STROKE_START.getId());
        if (kp == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE_START.getId(), left, 0.01));
        } else {
            left = kp.time;
        }
        kp = tfu.getKeyPosition(BMLSync.STROKE_END.getId());
        if (kp == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE_END.getId(), right, 0.01));
        }
        if ((kp = tfu.getKeyPosition(BMLSync.STROKE.getId())) == null) {
            tfu.getFaceUnit().addKeyPosition(new KeyPosition(BMLSync.STROKE.getId(), left, 0.01));
        }
    }

    @Override
    public PlanUnit resolveSynchs(BMLBlockPeg bbPeg, Behaviour b, ArrayList<TimePegAndConstraint> sac) throws BehaviourPlanningException {
        List<TimedFaceUnit> tfus = this.faceBinding.getFaceUnit(bbPeg, b, this.player);
        if (tfus.isEmpty()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding (no matching constraints), behavior omitted.");
        }
        TimedFaceUnit tfu = tfus.get(0);
        if (!tfu.getFaceUnit().hasValidParameters()) {
            throw new BehaviourPlanningException(b, "Behavior " + b.id + " could not be constructed from the face binding because the parameters are not valid, behavior omitted.");
        }
        ArrayList<TimePegAndConstraint> sortedSac = new ArrayList<TimePegAndConstraint>();
        block0: for (KeyPosition kp : tfu.getFaceUnit().getKeyPositions()) {
            for (TimePegAndConstraint s : sac) {
                if (!s.id.equals(kp.id)) continue;
                sortedSac.add(s);
                continue block0;
            }
        }
        this.resolveDefaultBMLKeyPositions(tfu);
        this.linkSynchs(tfu, sortedSac);
        int sections = 0;
        double totalStretch = 0.0;
        TimePegAndConstraint sPrev = null;
        for (TimePegAndConstraint s : sortedSac) {
            if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
            if (sPrev != null) {
                double duration = tfu.getPegTime(s.id) - tfu.getPegTime(sPrev.id);
                double startKey = 0.0;
                double endKey = 0.0;
                for (KeyPosition kp : tfu.getPegs().keySet()) {
                    if (tfu.getPegs().get(kp).getLink() == sPrev.peg.getLink()) {
                        startKey = kp.time;
                    }
                    if (tfu.getPegs().get(kp).getLink() != s.peg.getLink()) continue;
                    endKey = kp.time;
                }
                double nominalDuration = (endKey - startKey) * tfu.getFaceUnit().getPreferedDuration();
                if (!(nominalDuration > 0.0)) continue;
                totalStretch += duration / nominalDuration;
                ++sections;
                continue;
            }
            sPrev = s;
        }
        double avgStretch = 1.0;
        if (sections > 0) {
            avgStretch = totalStretch / (double)sections;
        }
        if (sortedSac.size() > 0) {
            TimePegAndConstraint sacStart = sortedSac.get(0);
            if (sacStart.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacNext = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacNext = s;
                    break;
                }
                if (sacNext == null) {
                    sacStart.peg.setLocalValue(0.0);
                } else {
                    double nextKey = tfu.getKeyPosition((String)sacNext.id).time;
                    double nextTime = tfu.getPegTime(sacNext.id);
                    double tStart = nextTime - nextKey * avgStretch * tfu.getFaceUnit().getPreferedDuration();
                    if (sacStart.resolveAsStartOffset) {
                        OffsetPeg os = (OffsetPeg)sacStart.peg;
                        os.setLink(tfu.getTimePeg(sacNext.id));
                        os.setOffset(tStart - nextTime);
                    } else {
                        sacStart.peg.setGlobalValue(tStart + sacStart.offset);
                    }
                }
            }
            TimePegAndConstraint sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (sacEnd.peg.getGlobalValue() == -1.7976931348623157E308) {
                TimePegAndConstraint sacPrev = null;
                for (TimePegAndConstraint s : sortedSac) {
                    if (s.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                    sacPrev = s;
                }
                if (sacPrev == null) {
                    sacEnd.peg.setGlobalValue(tfu.getFaceUnit().getPreferedDuration());
                } else {
                    double prevDur = 1.0 - tfu.getKeyPosition((String)sacPrev.id).time;
                    sacEnd.peg.setGlobalValue(tfu.getPegTime(sacPrev.id) + prevDur * avgStretch * tfu.getFaceUnit().getPreferedDuration() + sacEnd.offset);
                }
            }
            TimePegAndConstraint sacPrev = sacStart;
            TimePegAndConstraint sacNext = null;
            for (TimePegAndConstraint s : sortedSac) {
                if (s.peg.getGlobalValue() == -1.7976931348623157E308) {
                    for (TimePegAndConstraint s2 : sortedSac.subList(sortedSac.indexOf(s), sortedSac.size())) {
                        if (s2.peg.getGlobalValue() == -1.7976931348623157E308) continue;
                        sacNext = s2;
                        break;
                    }
                    double keyPrev = tfu.getKeyPosition((String)sacPrev.id).time;
                    double keyNext = tfu.getKeyPosition((String)sacNext.id).time;
                    double keyCurr = tfu.getKeyPosition((String)s.id).time;
                    double timePrev = tfu.getPegTime(sacPrev.id);
                    double timeNext = tfu.getPegTime(sacNext.id);
                    s.peg.setGlobalValue(timePrev + (keyCurr - keyPrev) * (timeNext - timePrev) / (keyNext - keyPrev) + s.offset);
                }
                sacPrev = s;
            }
            sacEnd = sortedSac.get(sortedSac.size() - 1);
            if (!sacEnd.id.equals("end") && tfu.getFaceUnit().getPreferedDuration() > 0.0) {
                double keyPrev = tfu.getKeyPosition((String)sacEnd.id).time;
                double keyEnd = tfu.getKeyPosition((String)"end").time;
                logger.debug("Behavior: {}", (Object)b);
                logger.debug("sacEnd: {}", (Object)sacEnd.id);
                logger.debug("keypos {}", tfu.getFaceUnit().getKeyPositions());
                logger.debug("keyEnd-keyPrev {} stretch {}", (Object)(keyEnd - keyPrev), (Object)avgStretch);
                logger.debug("adding offset peg to tfu, offset {} peg: {} ", (Object)((keyEnd - keyPrev) * avgStretch * tfu.getFaceUnit().getPreferedDuration()), (Object)sacEnd.peg.toString());
                OffsetPeg op = new OffsetPeg(tfu.getTimePeg(sacEnd.id), (keyEnd - keyPrev) * avgStretch * tfu.getFaceUnit().getPreferedDuration());
                tfu.setTimePeg(tfu.getKeyPosition("end"), (TimePeg)op);
            }
        }
        return tfu;
    }

    @Override
    public void clearAll(double time) {
        this.player.clearAll(time);
    }

    private void linkSynchs(TimedFaceUnit tfu, ArrayList<TimePegAndConstraint> sacs) {
        for (TimePegAndConstraint s : sacs) {
            for (KeyPosition kp : tfu.getFaceUnit().getKeyPositions()) {
                if (!s.id.equals(kp.id)) continue;
                if (s.offset == 0.0) {
                    tfu.setTimePeg(kp, s.peg);
                    continue;
                }
                tfu.setTimePeg(kp, (TimePeg)new OffsetPeg(s.peg, -s.offset));
            }
        }
    }

    @Override
    public void removeBehaviour(String behaviourId, String BMLId) {
        this.player.interruptTimedFaceUnit(behaviourId, BMLId, 0.0);
    }

    @Override
    public void interruptBehaviour(String behaviourId, String BMLId, double globalTime) {
        this.player.interruptTimedFaceUnit(behaviourId, BMLId, globalTime);
    }

    @Override
    public Set<String> getInvalidBehaviours() {
        return this.player.getInvalidBehaviors();
    }

    public void addVisemesForSpeechUnit(ArrayList<TimedFaceUnit> visemeFUs) {
        for (TimedFaceUnit vfu : visemeFUs) {
            vfu.setSubUnit(true);
            this.player.addTimedFaceUnit(vfu);
        }
    }

    @Override
    public void addWarningListener(BMLWarningListener war) {
        this.player.addWarningListener(war);
    }

    @Override
    public void removeAllWarningListeners() {
        this.player.removeAllWarningListeners();
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedBehaviours() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(FaceBehaviour.class);
        list.add(BMLTBlinkModelChangeBehaviour.class);
        list.add(BMLTGazePatternChangeBehaviour.class);
        return list;
    }

    @Override
    public List<Class<? extends Behaviour>> getSupportedDescriptionExtensions() {
        ArrayList<Class<? extends Behaviour>> list = new ArrayList<Class<? extends Behaviour>>();
        list.add(BMLTBlinkModelChangeBehaviour.class);
        list.add(BMLTGazePatternChangeBehaviour.class);
        return list;
    }

    @Override
    public void reset() {
        this.player.reset();
    }
}

