/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerBridge;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.bridge.ConnectionStateListener;
import hmi.elckerlyc.bridge.XMLBMLExceptionFeedback;
import hmi.elckerlyc.bridge.XMLBMLPerformanceStartFeedback;
import hmi.elckerlyc.bridge.XMLBMLPerformanceStopFeedback;
import hmi.elckerlyc.bridge.XMLBMLSyncPointProgressFeedback;
import hmi.elckerlyc.bridge.XMLBMLWarningFeedback;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPIPRealizerBridgeServer
implements Runnable,
BMLExceptionListener,
BMLWarningListener,
BMLFeedbackListener {
    private static Logger logger = LoggerFactory.getLogger((String)TCPIPRealizerBridgeServer.class.getName());
    private static final long BML_REDIRECT_WAIT_MILLI = 100L;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final int CONNECT_RETRY_WAIT = 1000;
    private static final int WAIT_IF_NO_BML = 100;
    private static final int WAIT_AFTER_DROPPED_CLIENT = 3000;
    private ServerState serverState = ServerState.NOT_RUNNING;
    protected List<ConnectionStateListener> connectionStateListeners = new ArrayList<ConnectionStateListener>();
    private ConcurrentLinkedQueue<String> feedbackQ = new ConcurrentLinkedQueue();
    private Object connectionLock = new Object();
    private boolean isconnected = false;
    private boolean mustshutdown = false;
    private boolean mustdisconnect = false;
    private boolean mustconnect = false;
    private long nextMainLoopWait = 100L;
    private InetSocketAddress feedbackSendSocketAddress = null;
    private Socket feedbackSendSocket = null;
    private PrintWriter feedbackSendWriter = null;
    private ServerSocket bmlReadServerSocket = null;
    private Socket bmlReadSocket = null;
    private BufferedReader bmlReadReader = null;
    private BMLReader bmlReader = null;
    private Thread bmlReaderThread = null;
    private int bmlPort = 7500;
    private int feedbackPort = 7501;
    private BMLRedirector bmlRedirector = null;
    private Thread bmlRedirectorThread = null;
    private RealizerBridge realizerBridge = null;
    private ConcurrentLinkedQueue<String> bmlQ = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.mustshutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedToClient() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.isconnected;
        }
    }

    public ServerState getStatus() {
        return this.serverState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionStateListener(ConnectionStateListener l) {
        List<ConnectionStateListener> list = this.connectionStateListeners;
        synchronized (list) {
            this.connectionStateListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerState(ServerState state) {
        List<ConnectionStateListener> list = this.connectionStateListeners;
        synchronized (list) {
            if (state == this.serverState) {
                return;
            }
            if (this.serverState == ServerState.WAITING && state == ServerState.DISCONNECTING) {
                return;
            }
            this.serverState = state;
            for (ConnectionStateListener l : this.connectionStateListeners) {
                l.stateChanged(state);
            }
        }
    }

    public void exception(BMLExceptionFeedback be) {
        this.queueFeedback(new XMLBMLExceptionFeedback(be).toXMLString());
    }

    public void warn(BMLWarningFeedback bw) {
        this.queueFeedback(new XMLBMLWarningFeedback(bw).toXMLString());
    }

    public void syncProgress(BMLSyncPointProgressFeedback spp) {
        this.queueFeedback(new XMLBMLSyncPointProgressFeedback(spp).toXMLString());
    }

    public void performanceStop(BMLPerformanceStopFeedback psf) {
        this.queueFeedback(new XMLBMLPerformanceStopFeedback(psf).toXMLString());
    }

    public void performanceStart(BMLPerformanceStartFeedback psf) {
        this.queueFeedback(new XMLBMLPerformanceStartFeedback(psf).toXMLString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFeedback(String fb) {
        boolean send = true;
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.isconnected && !this.mustconnect) {
                send = false;
            }
        }
        if (send) {
            logger.debug("Putting feedback on queue: {}", (Object)fb);
            this.feedbackQ.add(fb);
        } else {
            logger.debug("Dropped feedback, as no client is connected!");
        }
    }

    public void stopBmlReadSockets() {
        try {
            logger.debug("Stop BML Read sockets: Close bml read socket");
            if (this.bmlReadSocket != null) {
                this.bmlReadSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            logger.debug("Stop BML Read sockets: Close server socket");
            if (this.bmlReadServerSocket != null) {
                this.bmlReadServerSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stopFeedbackWriteSockets() {
        try {
            if (this.feedbackSendSocket != null) {
                this.feedbackSendSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setServerState(ServerState.WAITING);
        while (true) {
            Object object = this.connectionLock;
            synchronized (object) {
                String nextFeedback;
                this.nextMainLoopWait = 100L;
                if (this.mustdisconnect) {
                    this.dodisconnect();
                }
                if (this.mustconnect) {
                    this.doconnect();
                }
                if (this.mustshutdown) {
                    this.doshutdown();
                }
                if (this.isconnected && (nextFeedback = this.feedbackQ.poll()) != null) {
                    this.dosendFeedback(nextFeedback);
                }
            }
            if (this.mustshutdown) break;
            try {
                Thread.sleep(this.nextMainLoopWait);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug("Server shutdown finished");
    }

    private void dodisconnect() {
        this.setServerState(ServerState.DISCONNECTING);
        logger.debug("Closing feedback sender");
        this.stopFeedbackWriteSockets();
        logger.debug("Feedback sender closed");
        this.mustdisconnect = false;
        this.isconnected = false;
        this.feedbackQ.clear();
        this.nextMainLoopWait = 1L;
        if (!this.mustshutdown) {
            this.setServerState(ServerState.WAITING);
        }
    }

    private void doconnect() {
        this.setServerState(ServerState.CONNECTING);
        logger.debug("Connecting feedback sender");
        this.feedbackSendSocketAddress = new InetSocketAddress(((InetSocketAddress)this.bmlReadSocket.getRemoteSocketAddress()).getAddress(), this.feedbackPort);
        this.feedbackSendSocket = new Socket();
        try {
            this.feedbackSendSocket.connect(this.feedbackSendSocketAddress, 5000);
            this.feedbackSendWriter = new PrintWriter(this.feedbackSendSocket.getOutputStream(), true);
        }
        catch (SocketTimeoutException e) {
            this.retryConnect("Timeout while attempting to connect.");
            return;
        }
        catch (IllegalBlockingModeException e) {
            this.bmlReader.dropClient(e.getMessage());
            return;
        }
        catch (IllegalArgumentException e) {
            this.bmlReader.dropClient(e.getMessage());
            return;
        }
        catch (IOException e) {
            this.bmlReader.dropClient(e.getMessage());
            return;
        }
        logger.debug("Feedback sender connected");
        this.mustconnect = false;
        this.isconnected = true;
        this.setServerState(ServerState.CONNECTED);
    }

    private void retryConnect(String msg) {
        logger.debug("Error connecting to client feedback channel: {}\nWill try again in msec...", (Object)msg, (Object)1000);
        this.nextMainLoopWait = 1000L;
    }

    private void doshutdown() {
        this.setServerState(ServerState.DISCONNECTING);
        logger.debug("Enter shutdown...");
        this.bmlReader.stopReading();
        this.stopBmlReadSockets();
        this.dodisconnect();
        logger.debug("Stopping bmlReaderThread...");
        try {
            this.bmlReaderThread.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.debug("Stopping bmlRedirectorThread...");
        try {
            this.bmlRedirectorThread.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.debug("Shutdown almost done.");
        this.setServerState(ServerState.NOT_RUNNING);
    }

    private void dosendFeedback(String feedback) {
        try {
            logger.debug("Sending feedback");
            this.feedbackSendWriter.println(feedback);
        }
        catch (Exception e) {
            logger.warn("Error sending feedback; dropping client");
            this.mustdisconnect = true;
            this.bmlReader.dropClient("feedbackchannel broken");
        }
        this.nextMainLoopWait = 1L;
    }

    public TCPIPRealizerBridgeServer(RealizerBridge bridge, int bmlPort, int feedbackPort) {
        if (bridge == null) {
            throw new IllegalArgumentException("Server cannot have null realizer");
        }
        this.realizerBridge = bridge;
        this.realizerBridge.setupListeners((BMLExceptionListener)this, (BMLWarningListener)this, (BMLFeedbackListener)this);
        this.bmlPort = bmlPort;
        this.feedbackPort = feedbackPort;
        this.bmlRedirector = new BMLRedirector();
        this.bmlRedirectorThread = new Thread(this.bmlRedirector);
        this.bmlRedirectorThread.start();
        new Thread(this).start();
        this.bmlReader = new BMLReader();
        this.bmlReaderThread = new Thread(this.bmlReader);
        this.bmlReaderThread.start();
    }

    private class BMLRedirector
    implements Runnable {
        private BMLRedirector() {
        }

        @Override
        public void run() {
            while (!TCPIPRealizerBridgeServer.this.mustshutdown) {
                String nextBml = (String)TCPIPRealizerBridgeServer.this.bmlQ.poll();
                if (nextBml != null) {
                    try {
                        logger.debug("New BML in queue, send to realizer.");
                        TCPIPRealizerBridgeServer.this.realizerBridge.performBML(nextBml);
                    }
                    catch (Exception ex) {
                        logger.warn("Error sending BML to realizer -- shutting down server! {}", (Object)ex.getMessage());
                        ex.printStackTrace();
                        TCPIPRealizerBridgeServer.this.mustshutdown = true;
                        TCPIPRealizerBridgeServer.this.nextMainLoopWait = 1L;
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug("Shutdown BML Redirection queue");
        }
    }

    private class BMLReader
    implements Runnable {
        private boolean stop = false;
        boolean bmlconnected = false;

        public void stopReading() {
            this.stop = true;
        }

        @Override
        public void run() {
            logger.debug("Starting BML Reader");
            while (!this.stop) {
                while (!this.bmlconnected && !this.stop) {
                    logger.debug("Opening server socket");
                    try {
                        TCPIPRealizerBridgeServer.this.bmlReadServerSocket = new ServerSocket(TCPIPRealizerBridgeServer.this.bmlPort);
                    }
                    catch (IOException e) {
                        this.failBmlConnect(e.getMessage());
                        return;
                    }
                    logger.debug("Server socket opened");
                    try {
                        TCPIPRealizerBridgeServer.this.bmlReadServerSocket.setSoTimeout(0);
                    }
                    catch (SocketException e) {
                        this.failBmlConnect(e.getMessage());
                        return;
                    }
                    try {
                        TCPIPRealizerBridgeServer.this.bmlReadServerSocket.setSoTimeout(5000);
                    }
                    catch (SocketException e) {
                        this.failBmlConnect(e.getMessage());
                        return;
                    }
                    try {
                        TCPIPRealizerBridgeServer.this.setServerState(ServerState.WAITING);
                        logger.debug("Waiting for client to connect");
                        TCPIPRealizerBridgeServer.this.bmlReadSocket = TCPIPRealizerBridgeServer.this.bmlReadServerSocket.accept();
                        this.bmlconnected = true;
                        TCPIPRealizerBridgeServer.this.setServerState(ServerState.CONNECTING);
                        logger.debug("Incoming client; preparing reader");
                        TCPIPRealizerBridgeServer.this.bmlReadReader = new BufferedReader(new InputStreamReader(TCPIPRealizerBridgeServer.this.bmlReadSocket.getInputStream()));
                        logger.debug("Client connected, starting lo listen for BML at port " + TCPIPRealizerBridgeServer.this.bmlPort);
                    }
                    catch (SocketTimeoutException e) {
                        this.dropClient("Timeout while accepting incoming client. going back to listen.");
                        continue;
                    }
                    catch (IllegalBlockingModeException e) {
                        this.failBmlConnect(e.getMessage());
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.failBmlConnect(e.getMessage());
                        return;
                    }
                    catch (IOException e) {
                        this.dropClient(e.getMessage());
                        continue;
                    }
                    TCPIPRealizerBridgeServer.this.mustconnect = true;
                    XMLTokenizer tok = new XMLTokenizer((Reader)TCPIPRealizerBridgeServer.this.bmlReadReader);
                    while (this.bmlconnected && !this.stop) {
                        logger.debug("Connected -- keep trying to read");
                        try {
                            if (!tok.atSTag("bml")) {
                                this.dropClient("Client sent wrong format data over bml channel, dropping client. BML tag: ");
                                continue;
                            }
                            String bmlRequest = tok.getXMLSection();
                            TCPIPRealizerBridgeServer.this.bmlQ.add(bmlRequest);
                            logger.debug("Gotten BML request, putting it on queue");
                            try {
                                TCPIPRealizerBridgeServer.this.bmlRedirectorThread.interrupt();
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (IOException e) {
                            this.dropClient("Error while reading bml from client. " + e.getMessage());
                        }
                    }
                }
            }
            logger.debug("Closing sockets and readers in BML reader");
            TCPIPRealizerBridgeServer.this.stopBmlReadSockets();
            logger.debug("Leaving BML Reader");
        }

        private void failBmlConnect(String msg) {
            logger.warn("Failed to start listening to clients: {}.  Shutting server down.", (Object)msg);
            TCPIPRealizerBridgeServer.this.mustshutdown = true;
            TCPIPRealizerBridgeServer.this.nextMainLoopWait = 1L;
        }

        private void dropClient(String msg) {
            logger.info("Dropping client: {}.", (Object)msg);
            TCPIPRealizerBridgeServer.this.stopBmlReadSockets();
            this.bmlconnected = false;
            TCPIPRealizerBridgeServer.this.mustdisconnect = true;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static enum ServerState {
        WAITING,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        NOT_RUNNING;

    }
}

