/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.bridge;

import hmi.bml.bridge.RealizerBridge;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedback;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLPerformanceStartFeedback;
import hmi.bml.feedback.BMLPerformanceStopFeedback;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.bridge.ServerInfo;
import hmi.elckerlyc.bridge.XMLBMLExceptionFeedback;
import hmi.elckerlyc.bridge.XMLBMLPerformanceStartFeedback;
import hmi.elckerlyc.bridge.XMLBMLPerformanceStopFeedback;
import hmi.elckerlyc.bridge.XMLBMLSyncPointProgressFeedback;
import hmi.elckerlyc.bridge.XMLBMLWarningFeedback;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPIPRealizerBridgeClient
implements RealizerBridge,
Runnable {
    private static Logger logger = LoggerFactory.getLogger((String)TCPIPRealizerBridgeClient.class.getName());
    private static final long FEEDBACK_REDIRECT_WAIT_MILLI = 100L;
    private static final int SOCKET_TIMEOUT = 500;
    private static final int CONNECT_RETRY_WAIT = 1000;
    private static final int WAIT_IF_NO_FEEDBACK = 100;
    private ConcurrentLinkedQueue<String> bmlRequestQ = new ConcurrentLinkedQueue();
    private Object connectionLock = new Object();
    private boolean isconnected = false;
    private boolean mustshutdown = false;
    private boolean mustconnect = false;
    private ServerInfo serverInfo = null;
    private boolean mustdisconnect = false;
    private long nextMainLoopWait = 100L;
    private InetSocketAddress bmlSendSocketAddress = null;
    private Socket bmlSendSocket = null;
    private PrintWriter bmlSendWriter = null;
    private ServerSocket feedbackReadServerSocket = null;
    private Socket feedbackReadSocket = null;
    private BufferedReader feedbackReadReader = null;
    private FeedbackReader feedbackReader = null;
    private Thread feedbackReaderThread = null;
    private Object feedbackLock = new Object();
    private FeedbackRedirector feedbackRedirector = null;
    private Thread feedbackRedirectorThread = null;
    private BMLExceptionListener bel = null;
    private BMLWarningListener bwl = null;
    private BMLFeedbackListener bfl = null;
    private ConcurrentLinkedQueue<BMLFeedback> feedbackQ = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.mustdisconnect = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ServerInfo serverInfo) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.mustconnect = true;
            this.serverInfo = serverInfo;
            if (this.isconnected) {
                this.mustdisconnect = true;
            }
        }
    }

    protected ServerInfo getServerInfo() {
        return this.serverInfo.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.mustshutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.isconnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupListeners(BMLExceptionListener bel, BMLWarningListener bwl, BMLFeedbackListener bfl) {
        Object object = this.feedbackLock;
        synchronized (object) {
            this.bel = bel;
            this.bwl = bwl;
            this.bfl = bfl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBML(String bmlString) {
        boolean send = true;
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.isconnected && !this.mustconnect) {
                send = false;
            }
        }
        if (send) {
            this.bmlRequestQ.add(bmlString);
        } else {
            BMLExceptionFeedback feedback = new BMLExceptionFeedback(null, null, new ArrayList(), new ArrayList(), "Failure to send BML: no connection to BML Realizer Server.", true);
            Object object2 = this.feedbackLock;
            synchronized (object2) {
                if (this.bel != null) {
                    try {
                        this.bel.exception(feedback);
                    }
                    catch (Exception ex) {
                        logger.warn("Error sending BMLErrorFeedback to listeners!");
                    }
                } else {
                    logger.info(feedback.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this.connectionLock;
            synchronized (object) {
                String nextBMLRequest;
                this.nextMainLoopWait = 100L;
                if (this.mustdisconnect) {
                    this.dodisconnect();
                }
                if (this.mustconnect) {
                    this.doconnect();
                }
                if (this.mustshutdown) {
                    this.doshutdown();
                }
                if (this.isconnected && (nextBMLRequest = this.bmlRequestQ.poll()) != null) {
                    this.dosendBML(nextBMLRequest);
                }
            }
            if (this.mustshutdown) break;
            try {
                Thread.sleep(this.nextMainLoopWait);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.debug("Client shutdown finished");
    }

    private void dodisconnect() {
        logger.debug("Starting to disconnect from server");
        this.feedbackReader.stopReading();
        logger.debug("Waiting for feedbackreader to end...");
        try {
            if (this.feedbackReaderThread != null) {
                this.feedbackReaderThread.join();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.debug("Trying to close bml sending sockets...");
        try {
            if (this.bmlSendSocket != null) {
                this.bmlSendSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.debug("Trying to close feedback reading socket...");
        try {
            if (this.feedbackReadSocket != null) {
                this.feedbackReadSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (this.feedbackReadServerSocket != null) {
                this.feedbackReadServerSocket.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mustdisconnect = false;
        this.isconnected = false;
        this.bmlRequestQ.clear();
        this.nextMainLoopWait = 1L;
        logger.debug("Disconnected from server");
    }

    private void doconnect() {
        logger.debug("Connecting to server...");
        ServerInfo info = this.getServerInfo();
        if (info == null || info.getServerName() == null) {
            this.failConnect("No Server Info");
            return;
        }
        this.bmlSendSocketAddress = new InetSocketAddress(info.getServerName(), info.getBmlPort());
        this.bmlSendSocket = new Socket();
        try {
            logger.debug("Making socket");
            this.bmlSendSocket.connect(this.bmlSendSocketAddress, 500);
            logger.debug("Making bml writer");
            this.bmlSendWriter = new PrintWriter(this.bmlSendSocket.getOutputStream(), true);
        }
        catch (SocketTimeoutException e) {
            this.retryConnect("Timeout while attempting to connect.");
            return;
        }
        catch (IllegalBlockingModeException e) {
            this.failConnect(e.getMessage());
            return;
        }
        catch (IllegalArgumentException e) {
            this.failConnect(e.getMessage());
            return;
        }
        catch (IOException e) {
            this.failConnect(e.getMessage());
            return;
        }
        this.mustconnect = false;
        this.isconnected = true;
        logger.debug("Preparing feedback channel");
        this.feedbackReader = new FeedbackReader();
        this.feedbackReaderThread = new Thread(this.feedbackReader);
        this.feedbackReaderThread.start();
        logger.debug("Connected to server");
    }

    private void failConnect(String msg) {
        logger.warn("Cannot connect to server {}: {}", (Object)this.getServerInfo(), (Object)msg);
        this.mustconnect = false;
        this.nextMainLoopWait = 1L;
    }

    private void retryConnect(String msg) {
        logger.debug("Error connecting to server: {}\nWill try again in {} msec...", (Object)msg, (Object)1000);
        this.nextMainLoopWait = 1000L;
    }

    private void doshutdown() {
        logger.debug("Disconnect before shutdown");
        this.dodisconnect();
        logger.debug("Wait till feedbackredirectorthread finished");
        try {
            if (this.feedbackRedirectorThread != null) {
                this.feedbackRedirectorThread.join();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.debug("Shutdown client almost finished");
    }

    private void dosendBML(String bmlRequest) {
        try {
            this.bmlSendWriter.println(bmlRequest);
        }
        catch (Exception e) {
            logger.warn("Error sending BML; disconnecting from server");
            this.mustdisconnect = true;
            this.mustconnect = true;
        }
        this.nextMainLoopWait = 1L;
    }

    public TCPIPRealizerBridgeClient() {
        this.feedbackRedirector = new FeedbackRedirector();
        this.feedbackRedirectorThread = new Thread(this.feedbackRedirector);
        this.feedbackRedirectorThread.start();
        new Thread(this).start();
    }

    private class FeedbackRedirector
    implements Runnable {
        private FeedbackRedirector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TCPIPRealizerBridgeClient.this.mustshutdown) {
                BMLFeedback nextFeedback = (BMLFeedback)TCPIPRealizerBridgeClient.this.feedbackQ.poll();
                if (nextFeedback != null) {
                    Object object = TCPIPRealizerBridgeClient.this.feedbackLock;
                    synchronized (object) {
                        if (nextFeedback instanceof BMLExceptionFeedback) {
                            if (TCPIPRealizerBridgeClient.this.bel != null) {
                                try {
                                    TCPIPRealizerBridgeClient.this.bel.exception((BMLExceptionFeedback)nextFeedback);
                                }
                                catch (Exception ex) {
                                    logger.warn("Error sending BMLErrorFeedback to listeners!");
                                }
                            } else {
                                logger.debug(nextFeedback.toString());
                            }
                        } else if (nextFeedback instanceof BMLWarningFeedback) {
                            if (TCPIPRealizerBridgeClient.this.bwl != null) {
                                try {
                                    TCPIPRealizerBridgeClient.this.bwl.warn((BMLWarningFeedback)nextFeedback);
                                }
                                catch (Exception ex) {
                                    logger.warn("Error sending BMLErrorFeedback to listeners!");
                                }
                            } else {
                                logger.debug(nextFeedback.toString());
                            }
                        } else if (TCPIPRealizerBridgeClient.this.bfl != null) {
                            try {
                                if (nextFeedback instanceof BMLSyncPointProgressFeedback) {
                                    TCPIPRealizerBridgeClient.this.bfl.syncProgress((BMLSyncPointProgressFeedback)nextFeedback);
                                } else if (nextFeedback instanceof BMLPerformanceStopFeedback) {
                                    TCPIPRealizerBridgeClient.this.bfl.performanceStop((BMLPerformanceStopFeedback)nextFeedback);
                                } else if (nextFeedback instanceof BMLPerformanceStartFeedback) {
                                    TCPIPRealizerBridgeClient.this.bfl.performanceStart((BMLPerformanceStartFeedback)nextFeedback);
                                }
                            }
                            catch (Exception ex) {
                                logger.warn("Error sending BMLErrorFeedback to listeners!");
                            }
                        } else {
                            logger.debug(nextFeedback.toString());
                        }
                        continue;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class FeedbackReader
    implements Runnable {
        private boolean stop = false;

        public void stopReading() {
            this.stop = true;
        }

        @Override
        public void run() {
            logger.debug("Starting feedback reader");
            ServerInfo info = TCPIPRealizerBridgeClient.this.getServerInfo();
            try {
                TCPIPRealizerBridgeClient.this.feedbackReadServerSocket = new ServerSocket(info.getFeedbackPort());
            }
            catch (IOException e) {
                this.failFeedbackConnect(e.getMessage());
                return;
            }
            logger.debug("Server socket ready");
            try {
                TCPIPRealizerBridgeClient.this.feedbackReadServerSocket.setSoTimeout(500);
            }
            catch (SocketException e) {
                this.failFeedbackConnect(e.getMessage());
                return;
            }
            boolean feedbackconnected = false;
            while (!feedbackconnected) {
                try {
                    logger.debug("Waiting for server to connect to feedback channel");
                    TCPIPRealizerBridgeClient.this.feedbackReadSocket = TCPIPRealizerBridgeClient.this.feedbackReadServerSocket.accept();
                    feedbackconnected = true;
                    logger.debug("Making BufferedReader");
                    TCPIPRealizerBridgeClient.this.feedbackReadReader = new BufferedReader(new InputStreamReader(TCPIPRealizerBridgeClient.this.feedbackReadSocket.getInputStream()));
                }
                catch (SocketTimeoutException e) {
                    this.retryFeedbackConnect("Timeout while attempting to connect to feedback channel.");
                }
                catch (IllegalBlockingModeException e) {
                    this.failFeedbackConnect(e.getMessage());
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.failFeedbackConnect(e.getMessage());
                    return;
                }
                catch (IOException e) {
                    this.failFeedbackConnect(e.getMessage());
                    return;
                }
                if (feedbackconnected) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
            logger.debug("Feedback channel open, starting to read");
            XMLTokenizer tok = new XMLTokenizer((Reader)TCPIPRealizerBridgeClient.this.feedbackReadReader);
            while (!this.stop) {
                try {
                    XMLStructureAdapter feedback;
                    if (tok.atSTag(XMLBMLWarningFeedback.xmlTag())) {
                        feedback = new XMLBMLWarningFeedback();
                        feedback.readXML(tok);
                        TCPIPRealizerBridgeClient.this.feedbackQ.add(feedback.getBMLWarningFeedback());
                        continue;
                    }
                    if (tok.atSTag(XMLBMLExceptionFeedback.xmlTag())) {
                        feedback = new XMLBMLExceptionFeedback();
                        feedback.readXML(tok);
                        TCPIPRealizerBridgeClient.this.feedbackQ.add(feedback.getBMLExceptionFeedback());
                        continue;
                    }
                    if (tok.atSTag(XMLBMLPerformanceStartFeedback.xmlTag())) {
                        feedback = new XMLBMLPerformanceStartFeedback();
                        feedback.readXML(tok);
                        TCPIPRealizerBridgeClient.this.feedbackQ.add(feedback.getBMLPerformanceStartFeedback());
                        continue;
                    }
                    if (tok.atSTag(XMLBMLPerformanceStopFeedback.xmlTag())) {
                        feedback = new XMLBMLPerformanceStopFeedback();
                        feedback.readXML(tok);
                        TCPIPRealizerBridgeClient.this.feedbackQ.add(feedback.getBMLPerformanceStopFeedback());
                        continue;
                    }
                    if (tok.atSTag(XMLBMLSyncPointProgressFeedback.xmlTag())) {
                        feedback = new XMLBMLSyncPointProgressFeedback();
                        feedback.readXML(tok);
                        TCPIPRealizerBridgeClient.this.feedbackQ.add(feedback.getBMLSyncPointProgressFeedback());
                        continue;
                    }
                    logger.warn("Failed to read feedback from server, unexpected feedback format. Disconnecting from server.");
                    this.stop = true;
                    TCPIPRealizerBridgeClient.this.mustdisconnect = true;
                    TCPIPRealizerBridgeClient.this.mustconnect = true;
                    TCPIPRealizerBridgeClient.this.nextMainLoopWait = 1L;
                }
                catch (IOException e) {
                    logger.warn("Error reading feedback from server, error: {}. Disconnecting from server.", (Object)e.getMessage());
                    this.stop = true;
                    TCPIPRealizerBridgeClient.this.mustdisconnect = true;
                    TCPIPRealizerBridgeClient.this.mustconnect = true;
                    TCPIPRealizerBridgeClient.this.nextMainLoopWait = 1L;
                }
            }
            logger.debug("Leaving the feedback channel reader");
        }

        private void failFeedbackConnect(String msg) {
            logger.warn("Failed to connect feedback reader to server {}: {}.  Disconnecting from server.", (Object)TCPIPRealizerBridgeClient.this.getServerInfo(), (Object)msg);
            TCPIPRealizerBridgeClient.this.mustdisconnect = true;
            TCPIPRealizerBridgeClient.this.nextMainLoopWait = 1L;
        }

        private void retryFeedbackConnect(String msg) {
            logger.debug("Problem connecting to feedback channel: {}\nWill try again in {} msec...", (Object)msg, (Object)1000);
        }
    }
}

