/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.audioengine.AudioUnit;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.audioengine.AudioUnitPlayException;
import hmi.elckerlyc.audioengine.WavClipUnit;
import hmi.elckerlyc.audioengine.WavUnitPlanningException;
import hmi.elckerlyc.audioengine.WavUnitPlayException;
import java.io.File;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavAudioUnit
extends AudioUnit {
    private static Logger logger = LoggerFactory.getLogger((String)WavAudioUnit.class.getName());
    protected WavClipUnit wavUnit;

    public WavAudioUnit(BMLBlockPeg bbPeg, String fname, String id, String bmlId) {
        super(bbPeg, fname, id, bmlId);
    }

    @Override
    public void sendProgress(double playTime, double time) {
    }

    @Override
    public void playUnit(double time) throws PlayException {
        if (!this.isPlaying()) {
            this.start(time);
            this.sendStartProgress(time);
            this.bmlStartTime = time;
            this.systemStartTime = (double)System.nanoTime() / 1.0E9;
        }
        double playTime = time - this.getStartTime();
        try {
            this.wavUnit.play(playTime);
        }
        catch (WavUnitPlayException e) {
            AudioUnitPlayException aupe = new AudioUnitPlayException(e.getLocalizedMessage(), this);
            aupe.initCause(e);
            throw aupe;
        }
        this.sendProgress(playTime, time);
    }

    @Override
    public void stopUnit(double time) {
        if (this.wavUnit != null) {
            this.wavUnit.stop();
        }
    }

    @Override
    protected void resetUnit() {
        if (this.wavUnit != null) {
            this.wavUnit.reset();
        }
    }

    @Override
    protected void startUnit(double time) throws PlayException {
        if (this.wavUnit == null) {
            throw new AudioUnitPlayException("Null wavUnit unit", this);
        }
        this.wavUnit.setPlaying(true);
    }

    @Override
    protected void setupCache() throws AudioUnitPlanningException {
        try {
            this.wavUnit = new WavClipUnit(new File(this.fileName).toURI().toURL());
        }
        catch (MalformedURLException e) {
            AudioUnitPlanningException aupe = new AudioUnitPlanningException(e.getLocalizedMessage(), this);
            aupe.initCause(e);
            throw aupe;
        }
        catch (WavUnitPlanningException e) {
            AudioUnitPlanningException aupe = new AudioUnitPlanningException(e.getLocalizedMessage(), this);
            aupe.initCause(e);
            throw aupe;
        }
        this.setPrefferedDuration(this.wavUnit.getDuration());
        logger.debug("WAVUNIT DURATION: {}", (Object)this.wavUnit.getDuration());
    }

    @Override
    public void setParameterValue(String parameter, float value) {
        logger.debug("Setting wav parameter {}, value: {}", (Object)parameter, (Object)Float.valueOf(value));
        this.wavUnit.setParameterValue(parameter, value);
    }
}

