/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.audioengine.AudioUnitPlanningException;
import hmi.elckerlyc.planunit.AbstractPlanUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioUnit
extends AbstractPlanUnit {
    private static Logger logger = LoggerFactory.getLogger((String)AudioUnit.class.getName());
    protected String fileName;
    private double duration;
    protected double systemStartTime;
    protected double bmlStartTime;
    protected TimePeg startSync;
    protected TimePeg endSync;

    public void setStart(TimePeg start) {
        this.startSync = start;
    }

    public void setEnd(TimePeg end) {
        this.endSync = end;
    }

    public abstract void setParameterValue(String var1, float var2);

    public AudioUnit(BMLBlockPeg bbPeg, String fname, String id, String bmlId) {
        super(bbPeg, id, bmlId);
        this.fileName = fname;
    }

    public void stop() {
        if (this.isPlaying()) {
            this.setState(PlanUnitState.DONE);
        }
    }

    @Override
    public double getStartTime() {
        if (this.startSync == null) {
            return -1.7976931348623157E308;
        }
        return this.startSync.getGlobalValue();
    }

    @Override
    public double getEndTime() {
        if (this.endSync == null || this.endSync.getGlobalValue() == -1.7976931348623157E308) {
            double startTime = this.getStartTime();
            if (startTime != -1.7976931348623157E308) {
                return startTime + this.getPreferedDuration();
            }
        } else {
            return this.endSync.getGlobalValue();
        }
        return -1.7976931348623157E308;
    }

    @Override
    public boolean hasValidTiming() {
        if (this.getStartTime() > this.getEndTime()) {
            return false;
        }
        if (Math.abs(this.getEndTime() - this.getStartTime() - this.getPreferedDuration()) > 1.0E-4) {
            logger.debug("End time: {}", (Object)this.getEndTime());
            logger.debug("Start time: {}", (Object)this.getStartTime());
            logger.debug("End-start: {}", (Object)(this.getEndTime() - this.getStartTime()));
            logger.debug("Duration: {}", (Object)this.getPreferedDuration());
            return false;
        }
        return true;
    }

    @Override
    public double getPreferedDuration() {
        return this.duration;
    }

    protected void setupCache() throws AudioUnitPlanningException {
    }

    public void setup() throws AudioUnitPlanningException {
        this.setupCache();
    }

    protected void sendStartProgress(double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "start";
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "ready";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke-start";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "stroke";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    public abstract void sendProgress(double var1, double var3);

    public void sendEndProgress(double time) {
        String bmlId = this.getBMLId();
        String behaviorId = this.getId();
        String syncId = "stroke-end";
        double bmlBlockTime = time - this.bmlBlockPeg.getValue();
        String id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "relax";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
        syncId = "end";
        id = "fb-" + bmlId + ":" + behaviorId + ":" + syncId;
        this.feedback(new BMLSyncPointProgressFeedback(id, bmlId, behaviorId, syncId, bmlBlockTime, time));
    }

    @Override
    public double getTime(String syncId) {
        if (syncId.equals("start") || syncId.equals("ready") || syncId.equals("stroke-start") || syncId.equals("stroke")) {
            return this.getStartTime();
        }
        if (syncId.equals("stroke-end") || syncId.equals("relax") || syncId.equals("end")) {
            return this.getStartTime();
        }
        return -1.7976931348623157E308;
    }

    public void setPrefferedDuration(double duration) {
        this.duration = duration;
    }
}

