/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.audioengine.AudioPlanPlayer;
import hmi.elckerlyc.audioengine.AudioUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer
implements Player {
    private final AudioPlanPlayer app = new AudioPlanPlayer();
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlayer.class.getName());

    public void play(double time) {
        this.app.play(time);
    }

    @Override
    public void addWarningListener(BMLWarningListener ws) {
        this.app.addWarningListener(ws);
    }

    @Override
    public void removeAllWarningListeners() {
        this.app.removeAllWarningListeners();
    }

    public void addAudioUnit(AudioUnit au) {
        this.app.addAudioUnit(au);
    }

    public int getNumberOfAudioUnits() {
        return this.app.getNumberOfAudioUnits();
    }

    public void setAudioParameter(String id, String bmlId, String parameter, float value) {
        this.app.setAudioParameter(id, bmlId, parameter, value);
    }

    public void removeAudioUnit(String id, String bmlId) {
        this.app.removeAudioUnit(id, bmlId);
    }

    @Override
    public void reset() {
        this.app.stop();
        logger.debug("AudioPlayer reset");
        this.app.reset();
    }

    public void shutdown() throws InterruptedException {
        this.app.shutdown();
    }

    public void clearAll(double absoluteTime) {
        this.app.clearAll(absoluteTime);
        logger.debug("AudioPlayer cleared");
    }

    public void cleanup() {
        logger.debug("AudioPlayer cleanup");
        this.app.scheduleStop();
    }

    public Set<String> getInvalidBehaviours() {
        return this.app.getInvalidBehaviors();
    }

    @Override
    public void setBMLBlockState(String bmlId, PlanUnitState state) {
        this.app.setBMLBlockState(bmlId, state);
    }

    @Override
    public double getEndTime(String behId, String bmlId) {
        return this.app.getEndTime(behId, bmlId);
    }

    @Override
    public Set<String> getBehaviours(String bmlId) {
        return this.app.getBehaviours(bmlId);
    }

    @Override
    public void interruptBehaviourBlock(String bmlId, double time) {
        this.app.interruptBehaviourBlock(bmlId, time);
    }
}

