/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.audioengine;

import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.audioengine.AudioUnit;
import hmi.elckerlyc.planunit.PlanUnitState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlanPlayer {
    private static Logger logger = LoggerFactory.getLogger((String)AudioPlanPlayer.class.getName());
    @GuardedBy(value="audioUnits")
    private double time;
    @GuardedBy(value="audioUnits")
    private ArrayList<AudioUnit> audioUnits;
    @GuardedBy(value="audioUnits")
    private boolean doStop = false;
    private Future<?> audioRunner = null;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    @GuardedBy(value="this")
    private List<BMLWarningListener> warningListeners = new ArrayList<BMLWarningListener>();

    public synchronized void warn(BMLWarningFeedback w) {
        for (BMLWarningListener wl : this.warningListeners) {
            wl.warn(w);
        }
    }

    public synchronized void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    public synchronized void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    private void auWarning(AudioUnit au, String message, double time) {
        String bmlId = au.getBMLId();
        String id = "w-" + au.getId();
        ArrayList modifiedBehaviours = new ArrayList();
        ArrayList<String> droppedBehaviours = new ArrayList<String>();
        droppedBehaviours.add(au.getId());
        ArrayList modifiedConstraints = new ArrayList();
        String warningText = message + "\nBehavior " + au.getBMLId() + ":" + au.getId() + " dropped.";
        this.warn(new BMLWarningFeedback(id, bmlId, time, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
    }

    public void setAudioParameter(String id, String bmlId, String parameter, float value) {
        logger.debug("Setting audio param {}, value: {}", (Object)parameter, (Object)Float.valueOf(value));
        AudioUnit au = this.getAudioUnit(id, bmlId);
        if (au != null) {
            au.setParameterValue(parameter, value);
        }
    }

    public AudioPlanPlayer() {
        this.audioUnits = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioUnit getAudioUnit(String id, String bmlId) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (AudioUnit au : this.audioUnits) {
                if (!au.getId().equals(id) || !au.getBMLId().equals(bmlId)) continue;
                return au;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioUnit(AudioUnit au) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.audioUnits.add(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAudioUnits() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            return this.audioUnits.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAudioUnit(AudioUnit au) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            au.stop();
            this.audioUnits.remove(au);
        }
    }

    public void removeAudioUnit(String id, String bmlId) {
        AudioUnit au = this.getAudioUnit(id, bmlId);
        if (au != null) {
            this.removeAudioUnit(au);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(double t) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.time = t;
        }
        if (this.audioRunner == null || this.audioRunner.isDone()) {
            this.audioRunner = this.exec.submit(new AudioRunner());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleStop() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = true;
        }
        if (this.audioRunner != null) {
            try {
                this.audioRunner.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                logger.warn("ExecutionException in scheduleStop when stopping the audioRunnter thread:\n {}", (Throwable)e);
            }
        }
        arrayList = this.audioUnits;
        synchronized (arrayList) {
            this.doStop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAudioUnits(List<AudioUnit> auList) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (AudioUnit au : auList) {
                if (!au.isPlaying()) continue;
                try {
                    au.stop(0.0);
                }
                catch (PlayException e) {
                    logger.warn("SpeechUnit won't stop: {}", (Throwable)e);
                }
            }
            this.audioUnits.removeAll(auList);
        }
    }

    public void shutdown() throws InterruptedException {
        this.exec.shutdown();
        this.exec.awaitTermination(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.debug("AudioPP stop()");
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            logger.debug("Stopping audiounits");
            for (AudioUnit au : this.audioUnits) {
                au.stop();
            }
        }
        this.scheduleStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            for (AudioUnit au : this.audioUnits) {
                au.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInvalidBehaviors() {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            HashSet<String> invalidBehaviors = new HashSet<String>();
            for (AudioUnit au : this.audioUnits) {
                if (au.hasValidTiming()) continue;
                invalidBehaviors.add(au.getBMLId() + ":" + au.getId());
            }
            return invalidBehaviors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(double absoluteTime) {
        ArrayList<AudioUnit> arrayList = this.audioUnits;
        synchronized (arrayList) {
            logger.debug("Stopping audiounits");
            for (AudioUnit au : this.audioUnits) {
                try {
                    au.stop(absoluteTime - au.getBMLBlockPeg().getValue());
                }
                catch (PlayException e) {
                    logger.warn("Error stopping behavior " + au.getBMLId() + ":" + au.getId(), (Throwable)e);
                }
            }
            logger.debug("Clearing audiounits");
            this.audioUnits.clear();
        }
        logger.debug("Schedule AudioPP stop");
        this.scheduleStop();
        logger.debug("AudioPP cleared");
    }

    public synchronized void setBMLBlockState(String bmlId, PlanUnitState state) {
        for (AudioUnit au : this.audioUnits) {
            if (!au.getBMLId().equals(bmlId)) continue;
            au.setState(state);
        }
    }

    public synchronized double getEndTime(String behId, String bmlId) {
        AudioUnit pu = this.getAudioUnit(behId, bmlId);
        if (pu == null) {
            return -1.7976931348623157E308;
        }
        return pu.getEndTime();
    }

    public synchronized Set<String> getBehaviours(String bmlId) {
        HashSet<String> behaviours = new HashSet<String>();
        for (AudioUnit au : this.audioUnits) {
            if (!au.getBMLId().equals(bmlId)) continue;
            behaviours.add(au.getId());
        }
        return behaviours;
    }

    public synchronized void interruptBehaviourBlock(String bmlId, double time) {
        ArrayList<AudioUnit> removeUnits = new ArrayList<AudioUnit>();
        for (AudioUnit au : this.audioUnits) {
            if (!au.getBMLId().equals(bmlId)) continue;
            try {
                au.stop(time);
            }
            catch (PlayException e) {
                logger.warn("Exception when interrupting behavior " + au, (Throwable)e);
            }
            removeUnits.add(au);
        }
        this.removeAudioUnits(removeUnits);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ ArrayList access$100(AudioPlanPlayer x0) {
        return x0.audioUnits;
    }

    static /* synthetic */ boolean access$200(AudioPlanPlayer x0) {
        return x0.doStop;
    }

    static /* synthetic */ double access$300(AudioPlanPlayer x0) {
        return x0.time;
    }

    static /* synthetic */ void access$400(AudioPlanPlayer x0, AudioUnit x1, String x2, double x3) {
        x0.auWarning(x1, x2, x3);
    }

    class AudioRunner
    implements Runnable {
        AudioRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            AudioPlanPlayer.access$000().debug("start audioplanplayer");
            oldTime = -1.0;
            audioUnitsCache = new ArrayList<E>();
            audioUnitsRemove = new ArrayList<AudioUnit>();
            block7: while (true) {
                var7_5 = AudioPlanPlayer.access$100(AudioPlanPlayer.this);
                synchronized (var7_5) {
                    AudioPlanPlayer.access$100(AudioPlanPlayer.this).removeAll(audioUnitsRemove);
                    if (AudioPlanPlayer.access$200(AudioPlanPlayer.this)) {
                        AudioPlanPlayer.access$000().debug("break");
                        break;
                    }
                    t = AudioPlanPlayer.access$300(AudioPlanPlayer.this);
                    audioUnitsCache.clear();
                    audioUnitsCache.addAll(AudioPlanPlayer.access$100(AudioPlanPlayer.this));
                }
                if (t == oldTime) continue;
                oldTime = t;
                audioUnitsRemove.clear();
                i$ = audioUnitsCache.iterator();
                while (true) {
                    if (i$.hasNext()) ** break;
                    continue block7;
                    au = (AudioUnit)i$.next();
                    AudioPlanPlayer.access$000().debug("checking au {}:{}", (Object)au.getId(), (Object)au.getBMLId());
                    if (!(t >= au.getStartTime())) continue;
                    if (au.getState().isLurking()) {
                        try {
                            au.start(t);
                        }
                        catch (PlayException e) {
                            AudioPlanPlayer.access$400(AudioPlanPlayer.this, au, e.getLocalizedMessage(), t);
                            audioUnitsRemove.add(au);
                        }
                    }
                    if (!au.getState().isPlaying()) continue;
                    try {
                        au.play(t);
                    }
                    catch (PlayException e) {
                        AudioPlanPlayer.access$400(AudioPlanPlayer.this, au, e.getLocalizedMessage(), t);
                        audioUnitsRemove.add(au);
                    }
                }
                break;
            }
            AudioPlanPlayer.access$000().debug("stop audioplanplayer");
        }
    }
}

