/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.mixed;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.mixed.MixedSystem;
import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.inversedynamics.IDSegment;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedSystemGenerator {
    private static final Logger logger = LoggerFactory.getLogger((String)MixedSystemGenerator.class.getName());
    private final PhysicalHumanoid fullBodyPh;
    private final float[] gravity;

    public MixedSystemGenerator(PhysicalHumanoid fbPh, float[] g) {
        this.fullBodyPh = fbPh;
        this.gravity = g;
    }

    private void addPhysicalSegments(String jointName, PhysicalHumanoid pHuman, VJoint human) {
        List path = human.getPath(human.getPart(jointName));
        for (VJoint vj : path) {
            PhysicalSegment ps;
            if (pHuman.getSegment(vj.getSid()) != null || (ps = this.fullBodyPh.getSegment(vj.getSid())) == null) continue;
            PhysicalSegment newSeg = this.fullBodyPh.createSegment(pHuman.getId() + "-" + ps.getSid(), ps.getSid());
            newSeg.set(ps);
            pHuman.addSegment(newSeg);
        }
    }

    private PhysicalSegment getParent(PhysicalSegment ph, VJoint human) {
        VJoint vj = human.getPart(ph.getSid());
        VJoint parent = vj.getParent();
        while (this.fullBodyPh.getSegment(parent.getSid()) == null) {
            parent = parent.getParent();
        }
        return this.fullBodyPh.getSegment(parent.getSid());
    }

    public MixedSystem generateMixedSystem(String phId, Collection<String> requiredJoints, Collection<String> desiredJoints, VJoint human) {
        PhysicalHumanoid pHuman = this.fullBodyPh.createNew(phId);
        PhysicalSegment rootSegment = this.fullBodyPh.createSegment(phId + "-HumanoidRoot", "HumanoidRoot");
        rootSegment.set(this.fullBodyPh.getRootSegment());
        pHuman.addRootSegment(rootSegment);
        for (String jointName : requiredJoints) {
            this.addPhysicalSegments(jointName, pHuman, human);
        }
        for (String jointName : desiredJoints) {
            this.addPhysicalSegments(jointName, pHuman, human);
        }
        for (PhysicalSegment ps : pHuman.getSegments()) {
            if (ps.equals(rootSegment)) continue;
            PhysicalSegment parent = this.getParent(ps, human);
            float[] center = Vec3f.getVec3f();
            ps.getTranslation(center);
            Vec3f.add((float[])center, (float[])ps.startJointOffset);
            pHuman.setupJoint(ps.getSid(), parent, ps, center);
        }
        MixedSystem ms = new MixedSystem(this.gravity, pHuman);
        for (PhysicalSegment ps : this.fullBodyPh.getSegments()) {
            if (pHuman.getSegment(ps.getSid()) != null) continue;
            IDSegment idSeg = new IDSegment();
            idSeg.mass = ps.box.getMass();
            float[] jointPos = Vec3f.getVec3f();
            human.getPart(ps.getSid()).getPathTranslation(human.getParent(), jointPos);
            ps.getTranslation(idSeg.com);
            Vec3f.sub((float[])idSeg.com, (float[])jointPos);
            ps.box.getInertiaTensor(idSeg.I);
            idSeg.name = ps.getSid();
        }
        return ms;
    }
}

