/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gesturebinding;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitAssembler;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitParameter;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitParameterDefault;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitSpecConstraint;
import hmi.elckerlyc.animationengine.gesturebinding.MotionUnitSpecConstraints;
import hmi.elckerlyc.animationengine.gesturebinding.ParameterDefaults;
import hmi.elckerlyc.animationengine.gesturebinding.ParameterDefaultsHandler;
import hmi.elckerlyc.animationengine.gesturebinding.ParameterMap;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotionUnitSpec
extends XMLStructureAdapter
implements ParameterDefaultsHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)MotionUnitSpec.class.getName());
    public MotionUnit motionUnit;
    private String type;
    private String specnamespace;
    private ArrayList<MotionUnitSpecConstraint> constraints = new ArrayList();
    private HashMap<String, String> parametermap = new HashMap();
    private HashMap<String, MotionUnitParameterDefault> parameterdefault = new HashMap();
    private final Resources resources;
    private static final String XMLTAG = "MotionUnitSpec";

    public boolean satisfiesConstraints(Behaviour b) {
        for (MotionUnitSpecConstraint c : this.constraints) {
            if (b.satisfiesConstraint(c.name, c.value)) continue;
            return false;
        }
        return true;
    }

    public String getSpecnamespace() {
        return this.specnamespace;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getParameters() {
        return this.parametermap.keySet();
    }

    public MotionUnitSpec(Resources r) {
        this.resources = r;
    }

    public void addConstraint(MotionUnitSpecConstraint c) {
        this.constraints.add(c);
    }

    public void addParameter(MotionUnitParameter p) {
        this.parametermap.put(p.src, p.dst);
    }

    @Override
    public void addParameterDefault(MotionUnitParameterDefault p) {
        this.parameterdefault.put(p.name, p);
    }

    public String getParameter(String src) {
        return this.parametermap.get(src);
    }

    public Collection<MotionUnitParameterDefault> getParameterDefaults() {
        return this.parameterdefault.values();
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getRequiredAttribute("type", attrMap, tokenizer);
        this.specnamespace = this.getOptionalAttribute("namespace", attrMap, null);
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String tag = "";
        try {
            while (tokenizer.atSTag()) {
                tag = tokenizer.getTagName();
                if (tag.equals(MotionUnitSpecConstraints.xmlTag())) {
                    MotionUnitSpecConstraints musc = new MotionUnitSpecConstraints(this);
                    musc.readXML(tokenizer);
                    continue;
                }
                if (tag.equals(ParameterMap.xmlTag())) {
                    ParameterMap map = new ParameterMap(this);
                    map.readXML(tokenizer);
                    continue;
                }
                if (tag.equals(ParameterDefaults.xmlTag())) {
                    ParameterDefaults def = new ParameterDefaults(this);
                    def.readXML(tokenizer);
                    continue;
                }
                if (!tag.equals(MotionUnitAssembler.xmlTag())) continue;
                MotionUnitAssembler mua = new MotionUnitAssembler(this.resources);
                mua.readXML(tokenizer);
                this.motionUnit = mua.getMotionUnit();
            }
        }
        catch (Exception ex) {
            logger.warn("Cannot read motion unit spec, dropping element from gesture binding. Tag: {} ", (Object)tag);
            this.motionUnit = null;
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

