/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine.gaze;

import hmi.animation.VJoint;
import hmi.bml.core.OffsetDirection;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.KeyPositionManager;
import hmi.elckerlyc.animationengine.KeyPositionManagerImpl;
import hmi.elckerlyc.animationengine.gaze.GazeTMU;
import hmi.elckerlyc.animationengine.motionunit.KeyPosition;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.elckerlyc.util.timemanipulator.SigmoidManipulator;
import hmi.elckerlyc.util.timemanipulator.TimeManipulator;
import hmi.elckerlyc.world.WorldObject;
import hmi.elckerlyc.world.WorldObjectManager;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.neurophysics.DondersLaw;
import hmi.neurophysics.EyeSaturation;
import hmi.neurophysics.ListingsLaw;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GazeMU
implements MotionUnit {
    protected float[] qGaze;
    protected float[] qTemp;
    protected float[] qStart;
    protected float[] qStartLeftEye;
    protected float[] qStartRightEye;
    protected float[] vecTemp;
    protected KeyPosition ready;
    protected KeyPosition relax;
    protected VJoint neck;
    protected VJoint rEye;
    protected VJoint lEye;
    protected AnimationPlayer player;
    protected WorldObjectManager woManager;
    protected String target;
    protected TimeManipulator tmp;
    protected WorldObject woTarget;
    protected double preparationDuration;
    protected double relaxDuration = -1.7976931348623157E308;
    private static Logger logger = LoggerFactory.getLogger((String)GazeMU.class.getName());
    private KeyPositionManager keyPositionManager = new KeyPositionManagerImpl();
    private float[] localGaze = new float[3];
    protected double offsetAngle = 0.0;
    protected OffsetDirection offsetDirection = OffsetDirection.NONE;

    public GazeMU() {
        this.qGaze = new float[4];
        this.qTemp = new float[4];
        this.qStart = new float[4];
        this.qStartLeftEye = new float[4];
        this.qStartRightEye = new float[4];
        this.vecTemp = new float[3];
        this.ready = new KeyPosition("ready", 0.25, 1.0);
        this.relax = new KeyPosition("relax", 0.75, 1.0);
        this.addKeyPosition(this.ready);
        this.addKeyPosition(this.relax);
        this.addKeyPosition(new KeyPosition("start", 0.0, 1.0));
        this.addKeyPosition(new KeyPosition("end", 1.0, 1.0));
        this.target = "";
        this.tmp = new SigmoidManipulator(5.0, 1.0);
    }

    protected float[] getOffsetRotation() {
        float[] q = Quat4f.getQuat4f();
        Quat4f.setIdentity((float[])q);
        switch (this.offsetDirection) {
            case NONE: {
                break;
            }
            case RIGHT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)0.0f, (float)-1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case LEFT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)0.0f, (float)1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case UP: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)-1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case DOWN: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case UPRIGHT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case UPLEFT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)-1.0f, (float)1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case DOWNLEFT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)1.0f, (float)1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
            case DOWNRIGHT: {
                Quat4f.setFromAxisAngle4f((float[])q, (float)1.0f, (float)-1.0f, (float)0.0f, (float)((float)Math.toRadians(this.offsetAngle)));
                break;
            }
        }
        return q;
    }

    @Override
    public GazeMU copy(AnimationPlayer p) {
        GazeMU gmu = new GazeMU();
        gmu.neck = p.getVNext().getPart("skullbase");
        gmu.lEye = p.getVNext().getPart("l_eyeball_joint");
        gmu.rEye = p.getVNext().getPart("r_eyeball_joint");
        gmu.offsetAngle = this.offsetAngle;
        gmu.offsetDirection = this.offsetDirection;
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        return gmu;
    }

    public void setTarget(String target) throws MUPlayException {
        if (this.woManager == null) {
            throw new MUPlayException("Gaze target not found, no WorldObjectManager set up.", this);
        }
        this.woTarget = this.woManager.getWorldObject(target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(this.localGaze, this.neck);
        Quat4f.transformVec3f((float[])this.getOffsetRotation(), (float[])this.localGaze);
        this.setEndRotation(this.localGaze);
    }

    public void setStartPose(double prepDur, double relaxDur) throws MUPlayException {
        this.preparationDuration = prepDur;
        this.relaxDuration = relaxDur;
        this.player.getVCurr().getPart("skullbase").getRotation(this.qStart);
        if (this.lEye != null && this.rEye != null) {
            this.lEye.getRotation(this.qStartLeftEye);
            this.rEye.getRotation(this.qStartRightEye);
        }
        this.setTarget(this.target);
    }

    void setEndRotation(float[] gazeDir) throws MUPlayException {
        float[] normDir = new float[3];
        Vec3f.normalize((float[])normDir, (float[])gazeDir);
        DondersLaw.dondersHead((float[])normDir, (float[])this.qGaze);
    }

    void setEndRotation(float[] gazeDir, float[] q) throws MUPlayException {
        float[] normDir = new float[3];
        Vec3f.normalize((float[])normDir, (float[])gazeDir);
        DondersLaw.dondersHead((float[])normDir, (float[])q);
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        GazeMU predictor = this.copy(this.player);
        predictor.neck = predict.getPart("skullbase");
        Quat4f.set((float[])predictor.qStart, (float[])Quat4f.getIdentity());
        return predictor;
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    private void playEye(double t, float[] qDesNeck, float[] qStartEye, VJoint eye) throws MUPlayException {
        float[] gazeDir = Vec3f.getVec3f();
        Vec3f.set((float[])gazeDir, (float[])this.localGaze);
        Vec3f.normalize((float[])gazeDir);
        float[] eyeRotationDes = Quat4f.getQuat4f();
        float[] qDesNeckConj = Quat4f.getQuat4f();
        Quat4f.conjugate((float[])qDesNeckConj, (float[])qDesNeck);
        Quat4f.transformVec3f((float[])qDesNeckConj, (float[])gazeDir);
        ListingsLaw.listingsEye((float[])gazeDir, (float[])eyeRotationDes);
        float[] eyeRotationSpace = Quat4f.getQuat4f();
        Quat4f.mul((float[])eyeRotationSpace, (float[])qDesNeck, (float[])eyeRotationDes);
        float[] eyeRotationDesCur = Quat4f.getQuat4f();
        float[] qNeck = Quat4f.getQuat4f();
        this.neck.getRotation(qNeck);
        Quat4f.conjugate((float[])qNeck);
        Quat4f.mul((float[])eyeRotationDesCur, (float[])qNeck, (float[])eyeRotationSpace);
        float[] eyeRotationSat = Quat4f.getQuat4f();
        if (!EyeSaturation.isSaturized((float[])eyeRotationDes)) {
            throw new MUPlayException("Eye gaze at target violates eye saturation constraints.", this);
        }
        EyeSaturation.sat((float[])eyeRotationDesCur, (float[])eyeRotationDes, (float[])eyeRotationSat);
        float[] qCurr = Quat4f.getQuat4f();
        eye.getRotation(qCurr);
        if (t < 0.25) {
            double remDuration = (0.25 - t) / 0.25 * this.preparationDuration;
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            Quat4f.interpolate((float[])this.qTemp, (float[])qCurr, (float[])eyeRotationSat, (float)deltaT);
            eye.setRotation(this.qTemp);
        } else if (t > 0.75) {
            double remDuration = (1.0 - t) / 0.25 * this.relaxDuration;
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            Quat4f.interpolate((float[])this.qTemp, (float[])qCurr, (float[])qStartEye, (float)deltaT);
            eye.setRotation(this.qTemp);
        } else {
            eye.setRotation(eyeRotationSat);
        }
    }

    @Override
    public void play(double t) throws MUPlayException {
        if (this.rEye != null && this.lEye != null) {
            this.playEye(t, this.qGaze, this.qStartLeftEye, this.lEye);
            this.playEye(t, this.qGaze, this.qStartRightEye, this.rEye);
        }
        if (t < 0.25) {
            float tManip = (float)this.tmp.manip(t / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qStart, (float[])this.qGaze, (float)tManip);
            this.neck.setRotation(this.qTemp);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            Quat4f.interpolate((float[])this.qTemp, (float[])this.qGaze, (float[])this.qStart, (float)tManip);
            this.neck.setRotation(this.qTemp);
        } else {
            this.neck.setRotation(this.qGaze);
        }
    }

    @Override
    public TimedMotionUnit createTMU(BMLBlockPeg bmlBlockPeg, String i, String bmlId) {
        return new GazeTMU(bmlBlockPeg, i, bmlId, this);
    }

    @Override
    public void setParameterValue(String name, String value) {
        if (name.equals("target")) {
            this.target = value;
        } else if (name.equals("offsetangle")) {
            this.offsetAngle = Double.parseDouble(value);
        } else if (name.equals("offsetdirection")) {
            this.offsetDirection = OffsetDirection.valueOf((String)value);
        }
    }

    @Override
    public String getParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        return null;
    }

    @Override
    public void setParameterValue(String name, float value) {
    }

    public void setTimeManipulator(TimeManipulator tmp) {
        this.tmp = tmp;
    }

    @Override
    public String getReplacementGroup() {
        return "gaze";
    }

    @Override
    public void addKeyPosition(KeyPosition kp) {
        this.keyPositionManager.addKeyPosition(kp);
    }

    @Override
    public List<KeyPosition> getKeyPositions() {
        return this.keyPositionManager.getKeyPositions();
    }

    @Override
    public void setKeyPositions(List<KeyPosition> p) {
        this.keyPositionManager.setKeyPositions(p);
    }

    @Override
    public KeyPosition getKeyPosition(String name) {
        return this.keyPositionManager.getKeyPosition(name);
    }

    @Override
    public void removeKeyPosition(String id) {
        this.keyPositionManager.removeKeyPosition(id);
    }
}

