/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.OffsetPeg;
import hmi.elckerlyc.PlayException;
import hmi.elckerlyc.TimePeg;
import hmi.elckerlyc.animationengine.PointingMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TMUPlayException;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointingTMU
extends TimedMotionUnit {
    private PointingMU pmu;
    private static Logger logger = LoggerFactory.getLogger((String)PointingTMU.class.getName());

    public PointingTMU(BMLBlockPeg bbPeg, String i, String bmlId, PointingMU mu) {
        super(bbPeg, i, bmlId, mu);
        this.pmu = mu;
    }

    @Override
    public void startUnit(double time) throws PlayException {
        try {
            double readyDuration;
            double readyTime = this.getPegTime("ready");
            double relaxTime = this.getPegTime("relax");
            if (readyTime != -1.7976931348623157E308) {
                readyDuration = readyTime - this.getStartTime();
            } else {
                TimePeg startPeg;
                readyDuration = 1.0;
                double afterReady = this.getNextPegTime("ready");
                logger.debug("after ready: {}", (Object)afterReady);
                if (afterReady != -1.7976931348623157E308) {
                    double preparationDur = afterReady - this.getPrevPegTime("ready");
                    logger.debug("preparationDur {}", (Object)preparationDur);
                    if (readyDuration > preparationDur * 0.5) {
                        readyDuration = preparationDur * 0.5;
                    }
                }
                if ((startPeg = this.getTimePeg("start")) == null) {
                    // empty if block
                }
                OffsetPeg tpReady = new OffsetPeg(startPeg, readyDuration);
                this.setTimePeg("ready", (TimePeg)tpReady);
            }
            if (relaxTime != -1.7976931348623157E308) {
                double relaxDuration = this.getEndTime() - relaxTime;
            } else {
                TimePeg endPeg;
                double relaxDuration = readyDuration;
                double retractionDur = this.getNextPegTime("relax") - this.getPrevPegTime("relax");
                logger.debug("retractionDur: {}= {} - {}", new Object[]{retractionDur, this.getNextPegTime("relax"), this.getPrevPegTime("relax")});
                if (relaxDuration > retractionDur) {
                    relaxDuration = retractionDur;
                }
                if ((endPeg = this.getTimePeg("end")) != null && this.getEndTime() != -1.7976931348623157E308) {
                    OffsetPeg tpRelax = new OffsetPeg(endPeg, -relaxDuration);
                    this.setTimePeg("relax", (TimePeg)tpRelax);
                }
            }
            this.pmu.setStartPose(readyDuration);
        }
        catch (MUPlayException ex) {
            TMUPlayException texp = new TMUPlayException(ex.getLocalizedMessage(), this);
            texp.initCause(ex);
            throw texp;
        }
    }
}

