/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.elckerlyc.BMLBlockPeg;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.GazeMU;
import hmi.elckerlyc.animationengine.GazeTMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.elckerlyc.animationengine.motionunit.TimedMotionUnit;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.neurophysics.EyeSaturation;
import hmi.neurophysics.ListingsLaw;

public class EyeGazeMU
extends GazeMU {
    private float[] qEyeLeft = Quat4f.getQuat4f();
    private float[] qEyeRight = Quat4f.getQuat4f();

    @Override
    public EyeGazeMU copy(AnimationPlayer p) {
        EyeGazeMU gmu = new EyeGazeMU();
        gmu.lEye = p.getVNext().getPart("l_eyeball_joint");
        gmu.rEye = p.getVNext().getPart("r_eyeball_joint");
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        return gmu;
    }

    @Override
    public TimedMotionUnit createTMU(BMLBlockPeg bmlBlockPeg, String i, String bmlId) {
        return new GazeTMU(bmlBlockPeg, i, bmlId, this);
    }

    @Override
    void setEndRotation(float[] gazeDir) throws MUPlayException {
        this.woTarget = this.woManager.getWorldObject(this.target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(gazeDir, this.rEye);
        Vec3f.normalize((float[])gazeDir);
        float[] q = Quat4f.getQuat4f();
        ListingsLaw.listingsEye((float[])gazeDir, (float[])q);
        EyeSaturation.sat((float[])q, (float[])Quat4f.getIdentity(), (float[])this.qEyeRight);
        this.woTarget.getTranslation2(gazeDir, this.lEye);
        Vec3f.normalize((float[])gazeDir);
        ListingsLaw.listingsEye((float[])gazeDir, (float[])q);
        EyeSaturation.sat((float[])q, (float[])Quat4f.getIdentity(), (float[])this.qEyeLeft);
    }

    @Override
    public void play(double t) throws MUPlayException {
        float[] qLeft = Quat4f.getQuat4f();
        float[] qRight = Quat4f.getQuat4f();
        if (t < 0.25) {
            Quat4f.interpolate((float[])qLeft, (float[])this.qStartLeftEye, (float[])this.qEyeLeft, (float)((float)t / 0.25f));
            Quat4f.interpolate((float[])qRight, (float[])this.qStartRightEye, (float[])this.qEyeRight, (float)((float)t / 0.25f));
        } else if (t > 0.75) {
            Quat4f.interpolate((float[])qLeft, (float[])this.qStartLeftEye, (float[])this.qEyeLeft, (float)((float)(1.0 - t) / 0.25f));
            Quat4f.interpolate((float[])qRight, (float[])this.qStartRightEye, (float[])this.qEyeRight, (float)((float)(1.0 - t) / 0.25f));
        } else {
            Quat4f.set((float[])qLeft, (float[])this.qEyeLeft);
            Quat4f.set((float[])qRight, (float[])this.qEyeRight);
        }
        this.rEye.setRotation(qRight);
        this.lEye.setRotation(qLeft);
    }

    @Override
    public MotionUnit getPredictor(VJoint vPredict) {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }
}

