/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc.animationengine;

import hmi.animation.VJoint;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.animationengine.DynamicGazeMU;
import hmi.elckerlyc.animationengine.motionunit.MUPlayException;
import hmi.elckerlyc.animationengine.motionunit.MotionUnit;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.neurophysics.EyeSaturation;
import hmi.neurophysics.ListingsLaw;

public class DynamicEyeGazeMU
extends DynamicGazeMU {
    @Override
    public DynamicEyeGazeMU copy(AnimationPlayer p) {
        DynamicEyeGazeMU gmu = new DynamicEyeGazeMU();
        gmu.lEye = p.getVNext().getPart("l_eyeball_joint");
        gmu.rEye = p.getVNext().getPart("r_eyeball_joint");
        gmu.player = p;
        gmu.woManager = p.getWoManager();
        gmu.target = this.target;
        return gmu;
    }

    @Override
    public MotionUnit getPredictor(VJoint predict) {
        return null;
    }

    @Override
    public double getPreferedDuration() {
        return 0.0;
    }

    void setEndRotation(float[] gazeDir, VJoint eye, float[] qEye) throws MUPlayException {
        this.woTarget = this.woManager.getWorldObject(this.target);
        if (this.woTarget == null) {
            throw new MUPlayException("Gaze target not found", this);
        }
        this.woTarget.getTranslation2(gazeDir, eye);
        Vec3f.normalize((float[])gazeDir);
        float[] q = Quat4f.getQuat4f();
        ListingsLaw.listingsEye((float[])gazeDir, (float[])q);
        EyeSaturation.sat((float[])q, (float[])Quat4f.getIdentity(), (float[])qEye);
    }

    @Override
    public void play(double t) throws MUPlayException {
        float[] targetPosCurrL = Vec3f.getVec3f();
        float[] targetPosCurrR = Vec3f.getVec3f();
        this.woTarget.getTranslation2(targetPosCurrL, this.lEye);
        this.woTarget.getTranslation2(targetPosCurrR, this.rEye);
        float[] qGazeL = Quat4f.getQuat4f();
        float[] qGazeR = Quat4f.getQuat4f();
        float[] qEndCurr = Quat4f.getQuat4f();
        float[] qCurr = Quat4f.getQuat4f();
        if (t < 0.25) {
            double remDuration = (0.25 - t) / 0.25 * this.preparationDuration;
            float deltaT = (float)((double)this.player.getStepTime() / remDuration);
            this.setEndRotation(targetPosCurrL, this.lEye, qEndCurr);
            this.lEye.getRotation(qCurr);
            Quat4f.interpolate((float[])qGazeL, (float[])qCurr, (float[])qEndCurr, (float)deltaT);
            this.setEndRotation(targetPosCurrR, this.rEye, qEndCurr);
            this.rEye.getRotation(qCurr);
            Quat4f.interpolate((float[])qGazeR, (float[])qCurr, (float[])qEndCurr, (float)deltaT);
        } else if (t > 0.75) {
            float tManip = (float)this.tmp.manip((t - 0.75) / 0.25);
            this.lEye.getRotation(qCurr);
            Quat4f.interpolate((float[])qGazeL, (float[])qCurr, (float[])this.qStartLeftEye, (float)tManip);
            this.rEye.getRotation(qCurr);
            Quat4f.interpolate((float[])qGazeR, (float[])qCurr, (float[])this.qStartRightEye, (float)tManip);
        } else {
            this.setEndRotation(targetPosCurrL, this.lEye, qGazeL);
            this.setEndRotation(targetPosCurrR, this.rEye, qGazeR);
        }
        this.lEye.setRotation(qGazeL);
        this.rEye.setRotation(qGazeR);
    }
}

