/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.feedback.BMLWarningFeedback;
import hmi.bml.feedback.BMLWarningListener;
import hmi.elckerlyc.planunit.PlanUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.GuardedBy;

public final class WarningManager {
    @GuardedBy(value="warningListeners")
    private final List<BMLWarningListener> warningListeners = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(BMLWarningFeedback w) {
        List<BMLWarningListener> list = this.warningListeners;
        synchronized (list) {
            for (BMLWarningListener wl : this.warningListeners) {
                wl.warn(w);
            }
        }
    }

    public void addWarningListener(BMLWarningListener ws) {
        this.warningListeners.add(ws);
    }

    public void removeAllWarningListeners() {
        this.warningListeners.clear();
    }

    public void puWarning(PlanUnit timedMU, String message, double time) {
        String bmlId = timedMU.getBMLId();
        String id = "w-" + timedMU.getId();
        ArrayList modifiedBehaviours = new ArrayList();
        ArrayList<String> droppedBehaviours = new ArrayList<String>();
        droppedBehaviours.add(timedMU.getId());
        ArrayList modifiedConstraints = new ArrayList();
        String warningText = message + "\nBehavior " + timedMU.getBMLId() + ":" + timedMU.getId() + " dropped.";
        this.warn(new BMLWarningFeedback(id, bmlId, time, droppedBehaviours, modifiedBehaviours, modifiedConstraints, warningText));
    }
}

