/*
 * Decompiled with CFR 0.152.
 */
package hmi.elckerlyc;

import hmi.bml.BMLInfo;
import hmi.bml.core.Behaviour;
import hmi.bml.core.BehaviourBlock;
import hmi.bml.ext.bmlt.feedback.BMLTPlanningListener;
import hmi.bml.feedback.BMLExceptionFeedback;
import hmi.bml.feedback.BMLExceptionListener;
import hmi.bml.feedback.BMLFeedbackListener;
import hmi.bml.feedback.BMLWarningListener;
import hmi.bml.feedback.StdoutWarningListener;
import hmi.bml.parser.BMLParser;
import hmi.elckerlyc.ElckerlycRealizerBridge;
import hmi.elckerlyc.FeedbackLogger;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.animationengine.AnimationPlanner;
import hmi.elckerlyc.animationengine.AnimationPlayer;
import hmi.elckerlyc.anticipator.Anticipator;
import hmi.elckerlyc.audioengine.AudioPlanner;
import hmi.elckerlyc.audioengine.AudioPlayer;
import hmi.elckerlyc.faceengine.FacePlanner;
import hmi.elckerlyc.interrupt.InterruptPlanner;
import hmi.elckerlyc.scheduler.BMLScheduler;
import hmi.elckerlyc.scheduler.SchedulingClock;
import hmi.elckerlyc.scheduler.SmartBodySchedulingStrategy;
import hmi.elckerlyc.speechengine.SpeechPlanner;
import hmi.elckerlyc.speechengine.VerbalPlayer;
import hmi.elckerlyc.wait.WaitPlanner;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElckerlycRealizer
implements Runnable {
    LinkedBlockingQueue<String> bmlRequestQueue = new LinkedBlockingQueue();
    private boolean running = true;
    private static Logger logger = LoggerFactory.getLogger((String)ElckerlycRealizer.class.getName());
    private static Logger bmlRequestLogger;
    private static Logger bmlFeedbackLogger;
    private final SchedulingClock schedulingClock;
    private BMLParser parser = null;
    private AudioPlanner audioPlanner = null;
    private SpeechPlanner speechPlanner = null;
    private FacePlanner facePlanner = null;
    private InterruptPlanner interruptPlanner = null;
    private WaitPlanner waitPlanner = null;
    private String id = "no_id";
    private AnimationPlanner animationPlanner = null;
    private BMLScheduler scheduler = null;

    public ElckerlycRealizer(AudioPlanner newAudioPlanner, SpeechPlanner newSpeechPlanner, FacePlanner newFacePlanner, AnimationPlanner newAnimationPlanner, InterruptPlanner newInterruptPlanner, WaitPlanner newWaitPlanner, SchedulingClock c, String id) {
        this.schedulingClock = c;
        this.audioPlanner = newAudioPlanner;
        this.speechPlanner = newSpeechPlanner;
        this.facePlanner = newFacePlanner;
        this.animationPlanner = newAnimationPlanner;
        this.interruptPlanner = newInterruptPlanner;
        this.waitPlanner = newWaitPlanner;
        this.id = id;
        this.init();
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlanner.getAudioPlayer();
    }

    public AnimationPlayer getAnimationPlayer() {
        return (AnimationPlayer)this.animationPlanner.getPlayer();
    }

    public VerbalPlayer getVerbalPlayer() {
        return this.speechPlanner.getVerbalPlayer();
    }

    public ElckerlycRealizer(AnimationPlanner ap, SpeechPlanner tp, SchedulingClock c) {
        this(null, tp, null, ap, null, null, c, "no_id");
    }

    public void setFeedbackListener(BMLFeedbackListener f) {
        for (Planner p : this.scheduler.getPlanners()) {
            p.removeAllFeedbackListeners();
            p.addFeedbackListener(f);
        }
    }

    public void setWarningListener(BMLWarningListener w) {
        this.scheduler.removeAllWarningListeners();
        this.scheduler.addWarningListener(w);
        for (Planner p : this.scheduler.getPlanners()) {
            p.removeAllWarningListeners();
            p.addWarningListener(w);
        }
    }

    public void setExceptionListener(BMLExceptionListener e) {
        this.scheduler.removeAllExceptionListeners();
        this.scheduler.addExceptionListener(e);
    }

    public void addExceptionListener(BMLExceptionListener newListener) {
        this.scheduler.addExceptionListener(newListener);
    }

    public void addPlanningListener(BMLTPlanningListener bp) {
        this.scheduler.addPlanningListener(bp);
    }

    public void addWarningListener(BMLWarningListener newListener) {
        this.scheduler.addWarningListener(newListener);
        for (Planner p : this.scheduler.getPlanners()) {
            p.addWarningListener(newListener);
        }
    }

    public void addFeedbackListener(BMLFeedbackListener newListener) {
        this.scheduler.addFeedbackListener(newListener);
    }

    protected void init() {
        this.initParser();
        this.initScheduler();
        this.initBMLInfo();
        StdoutWarningListener listener = new StdoutWarningListener();
        this.setWarningListener((BMLWarningListener)listener);
        this.initLoggers();
        new Thread(this).start();
    }

    protected void initLoggers() {
        bmlRequestLogger = LoggerFactory.getLogger((String)(ElckerlycRealizer.class.getName() + ".BmlRequests." + this.id));
        bmlFeedbackLogger = LoggerFactory.getLogger((String)(ElckerlycRealizer.class.getName() + ".BmlFeedback." + this.id));
        new FeedbackLogger(new ElckerlycRealizerBridge(this), bmlFeedbackLogger);
    }

    protected void initBMLInfo() {
        new BMLInfo();
        for (Planner p : this.scheduler.getPlanners()) {
            for (Class<? extends Behaviour> beh : p.getSupportedDescriptionExtensions()) {
                if (BMLInfo.supportedExtensions.contains(beh)) continue;
                BMLInfo.supportedExtensions.add(beh);
            }
        }
    }

    protected void initParser() {
        this.parser = new BMLParser();
    }

    private void addPlanner(Planner p) {
        for (Class<? extends Behaviour> beh : p.getSupportedBehaviours()) {
            this.scheduler.addPlanner(beh, p);
        }
        for (Class<? extends Behaviour> beh : p.getSupportedDescriptionExtensions()) {
            this.scheduler.addPlanner(beh, p);
        }
    }

    protected void initScheduler() {
        logger.info("Initializing Elckerlyc Scheduler");
        this.scheduler = new BMLScheduler(this.parser, this.schedulingClock, new SmartBodySchedulingStrategy());
        if (this.animationPlanner != null) {
            this.addPlanner(this.animationPlanner);
            logger.info("Adding animation planner");
        } else {
            logger.info("NO ANIMATION PLANNER");
        }
        if (this.speechPlanner != null) {
            this.addPlanner(this.speechPlanner);
            logger.info("Adding speech planner");
        } else {
            logger.info("NO SPEECH PLANNER");
        }
        if (this.audioPlanner != null) {
            this.addPlanner(this.audioPlanner);
            logger.info("Adding audio planner");
        } else {
            logger.info("NO AUDIO PLANNER");
        }
        if (this.facePlanner != null) {
            this.addPlanner(this.facePlanner);
            logger.info("Adding face planner");
        } else {
            logger.info("NO FACE PLANNER");
        }
        if (this.interruptPlanner != null) {
            this.addPlanner(this.interruptPlanner);
        } else {
            logger.info("NO INTERRUPT PLANNER");
        }
        if (this.waitPlanner != null) {
            this.addPlanner(this.waitPlanner);
        } else {
            logger.info("NO WAIT PLANNER");
        }
    }

    public void addAnticipator(String id, Anticipator ap) {
        this.scheduler.addAnticipator(id, ap);
    }

    public void removeAnticipator(String aid) {
        this.scheduler.removeAnticipator(aid);
    }

    public String parseXML(Reader in) {
        return this.parseXML(new XMLTokenizer(in));
    }

    public String parseXML(XMLTokenizer in) {
        String result = "";
        try {
            if (!in.atSTag(BehaviourBlock.xmlTag())) {
                throw in.getXMLScanException("Expected bml start tag, got something else");
            }
            String blockContent = in.getXMLSection();
            this.parseXML(blockContent);
            result = "BML offered to scheduler";
        }
        catch (XMLScanException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            ArrayList failedBehaviours = new ArrayList();
            ArrayList failedConstraints = new ArrayList();
            String exceptionText = "Parsing XML failed: see stack trace for more info. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            result = "BML Not scheduled.\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            return result;
        }
        catch (IOException e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            ArrayList failedBehaviours = new ArrayList();
            ArrayList failedConstraints = new ArrayList();
            String exceptionText = "IO Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            result = "BML Not scheduled.\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            return result;
        }
        catch (Exception e) {
            String id = "<no id>";
            String bmlId = "<no id>";
            ArrayList failedBehaviours = new ArrayList();
            ArrayList failedConstraints = new ArrayList();
            String exceptionText = "General Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
            e.printStackTrace();
            result = "BML Not scheduled.\n";
            this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            return result;
        }
        return result;
    }

    public String parseXML(String in) {
        this.bmlRequestQueue.offer(in);
        return "BML offered to scheduler.";
    }

    @Override
    public void run() {
        String blockContent = "";
        while (this.running) {
            String exceptionText;
            ArrayList failedConstraints;
            ArrayList failedBehaviours;
            String bmlId;
            String id;
            try {
                blockContent = this.bmlRequestQueue.poll(1000L, TimeUnit.MILLISECONDS);
                if (blockContent == null) continue;
                bmlRequestLogger.info("<entry name=\"{}\" time=\"{}\">", (Object)bmlRequestLogger.getName(), (Object)this.schedulingClock.getTime());
                bmlRequestLogger.info(blockContent);
                bmlRequestLogger.info("</entry>");
                XMLTokenizer in = new XMLTokenizer(blockContent);
                BehaviourBlock block = new BehaviourBlock();
                block.readXML(in);
                this.parser.addBehaviourBlock(block);
                this.scheduler.schedule();
            }
            catch (InterruptedException ex) {
            }
            catch (XMLScanException e) {
                id = "<no id>";
                bmlId = "<no id>";
                failedBehaviours = new ArrayList();
                failedConstraints = new ArrayList();
                exceptionText = "Parsing XML failed: see stack trace for more info. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
                this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            }
            catch (IOException e) {
                id = "<no id>";
                bmlId = "<no id>";
                failedBehaviours = new ArrayList();
                failedConstraints = new ArrayList();
                exceptionText = "IO Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
                this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            }
            catch (Exception e) {
                id = "<no id>";
                bmlId = "<no id>";
                failedBehaviours = new ArrayList();
                failedConstraints = new ArrayList();
                exceptionText = "General Exception. " + e.getLocalizedMessage() + "\n" + Arrays.toString(e.getStackTrace()) + "\n";
                this.scheduler.exception(new BMLExceptionFeedback(id, bmlId, failedBehaviours, failedConstraints, exceptionText, true));
            }
        }
        logger.debug("Stopping Elckerlyc realizer thread");
    }

    public void stopRunning() {
        this.running = false;
    }

    public void clear() {
        this.parser.clear();
        this.scheduler.clear();
    }

    public void reset() {
        this.scheduler.reset();
    }

    public Planner getPlanner(Class<? extends Behaviour> c) {
        return this.scheduler.getPlanner(c);
    }

    public BMLScheduler getScheduler() {
        return this.scheduler;
    }
}

