/*
 * Decompiled with CFR 0.152.
 */
package hmi.debug.physics;

import hmi.animation.VJoint;
import hmi.debug.physics.COMGeometry;
import hmi.debug.physics.COMOffsetGeometry;
import hmi.debug.physics.PhysicalHumanVGLNode;
import hmi.debug.physics.RigidBodyToVJoint;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.geometry.BoxGeometry;
import hmi.graphics.opengl.geometry.CapsuleGeometry;
import hmi.graphics.opengl.geometry.DiscGeometry;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.opengl.state.GLLine;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.physics.CollisionBox;
import hmi.physics.CollisionCapsule;
import hmi.physics.CollisionShape;
import hmi.physics.CollisionSphere;
import hmi.physics.JointType;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicalSegment;
import hmi.physics.PhysicsSync;
import hmi.physics.RigidBody;
import java.util.ArrayList;

public final class PhysicsDebugVisualisations {
    private PhysicsDebugVisualisations() {
    }

    public static VGLNode getRigidBodyDebugVisualisation(RigidBody rb) {
        float[] grey = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(grey);
        material.setDiffuseColor(grey);
        material.setSpecularColor(grey);
        material.setAmbientColor(grey);
        material.setGLShader(new GLShader("simplePhongShader", new String[0]));
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return PhysicsDebugVisualisations.getRigidBodyDebugVisualisation(rb, renderStates, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VGLNode getRigidBodyDebugVisualisation(RigidBody rigidBody, ArrayList<GLRenderObject> renderStates, boolean renderCenter) {
        VJoint rbVJoint = new VJoint("Rigid body");
        GLRenderList shapeList = new GLRenderList(1);
        shapeList.add((GLRenderObject)new RigidBodyToVJoint(rigidBody, rbVJoint));
        if (renderStates != null) {
            GLShape glsShape = new GLShape("states");
            for (GLRenderObject state : renderStates) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(rbVJoint.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        if (renderCenter) {
            float[] grey = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
            GLMaterial material = new GLMaterial();
            material.setEmissionColor(grey);
            material.setDiffuseColor(grey);
            material.setSpecularColor(grey);
            material.setAmbientColor(grey);
            material.setGLShader(new GLShader("simplePhongShader", new String[0]));
            GLShape glsShape = new GLShape("center shape");
            glsShape.addGLState((GLRenderObject)new NoTexture2DState());
            glsShape.addGLState((GLRenderObject)new GLFill());
            glsShape.addGLState((GLRenderObject)material);
            SphereGeometry geometry = null;
            geometry = new SphereGeometry(0.02f, 4, 4);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(rbVJoint.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        VGLNode theVGLNode = new VGLNode(rbVJoint, shapeList);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            shapeList.add((GLRenderObject)new GLLine());
            for (CollisionShape collShape : rigidBody.getCollisionShapes()) {
                VGLNode vglCollision = PhysicsDebugVisualisations.getCollisionShapeDebugVisualisation(collShape);
                theVGLNode.addChild(vglCollision);
            }
        }
        return theVGLNode;
    }

    public static VGLNode getCollisionShapeDebugVisualisation(CollisionShape collShape) {
        VJoint shapeVJoint = new VJoint("Collision shape");
        GLShape glsShape = new GLShape("shape");
        BoxGeometry geometry = null;
        GLRenderList shapeList = new GLRenderList(1);
        if (collShape instanceof CollisionBox) {
            CollisionBox box = (CollisionBox)collShape;
            geometry = new BoxGeometry(box.halfExtends);
        } else if (collShape instanceof CollisionSphere) {
            CollisionSphere s = (CollisionSphere)collShape;
            geometry = new SphereGeometry(s.radius, 8, 8);
        } else if (collShape instanceof CollisionCapsule) {
            CollisionCapsule c = (CollisionCapsule)collShape;
            geometry = new CapsuleGeometry(c.radius, c.height, 8, 8);
        }
        glsShape.addGLGeometry((GLRenderObject)geometry);
        VJoint csVJoint = new VJoint("Collision shape plus offset");
        csVJoint.addChild(shapeVJoint);
        float[] tr = new float[3];
        collShape.getTranslation(tr);
        csVJoint.setTranslation(tr);
        float[] q = new float[4];
        collShape.getRotation(q);
        csVJoint.setRotation(q);
        glsShape.linkToTransformMatrix(csVJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        VGLNode theVGLNode = new VGLNode(csVJoint, shapeList);
        return theVGLNode;
    }

    public static VGLNode getPhysicalHumanDebugVisualisation(PhysicalHumanoid ph) {
        float[] grey = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(grey);
        material.setDiffuseColor(grey);
        material.setSpecularColor(grey);
        material.setAmbientColor(grey);
        material.setGLShader(new GLShader("simplePhongShader", new String[0]));
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return PhysicsDebugVisualisations.getPhysicalHumanDebugVisualisation(ph, renderStates);
    }

    public static VGLNode getPhysicalSegmentDebugVisualisation(PhysicalSegment ps, ArrayList<GLRenderObject> rigidBodyRenderStates) {
        VGLNode node = PhysicsDebugVisualisations.getRigidBodyDebugVisualisation(ps.box, rigidBodyRenderStates, true);
        if (ps.startJoint != null && ps.startJoint.getType() != JointType.FIXED) {
            float[] jointOffset = new float[3];
            float[] pos = new float[3];
            float[] rot = new float[4];
            ps.box.getTranslation(pos);
            ps.box.getRotation(rot);
            ps.startJoint.getAnchor(jointOffset);
            Vec3f.sub((float[])jointOffset, (float[])pos);
            Quat4f.inverse((float[])rot);
            Quat4f.transformVec3f((float[])rot, (float[])jointOffset);
            GLShape jointShape = new GLShape();
            jointShape.addGLState((GLRenderObject)new NoTexture2DState());
            jointShape.addGLState((GLRenderObject)new GLFill());
            GLMaterial m = new GLMaterial();
            float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] diffuse = new float[4];
            switch (ps.startJoint.getType()) {
                case HINGE: {
                    jointShape.addGLGeometry((GLRenderObject)new DiscGeometry(0.01f, 0.03f, 0.03f, 10, 10));
                    Vec3f.set((float[])diffuse, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case UNIVERSAL: {
                    jointShape.addGLGeometry((GLRenderObject)new BoxGeometry(0.01f, 0.01f, 0.01f));
                    Vec3f.set((float[])diffuse, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case BALL: {
                    jointShape.addGLGeometry((GLRenderObject)new SphereGeometry(0.03f, 10, 10));
                    Vec3f.set((float[])diffuse, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
            }
            float[] emission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] specular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            m.setAmbientColor(ambient);
            m.setDiffuseColor(diffuse);
            m.setEmissionColor(emission);
            m.setSpecularColor(specular);
            m.setGLShader(new GLShader("simplePhongShader", new String[0]));
            jointShape.addGLState((GLRenderObject)m);
            VJoint shapeVJoint = new VJoint("joint");
            shapeVJoint.setTranslation(jointOffset);
            GLRenderList jointShapeList = new GLRenderList(1);
            jointShapeList.add((GLRenderObject)jointShape);
            jointShape.linkToTransformMatrix(shapeVJoint.getGlobalMatrix());
            VGLNode jointVGLNode = new VGLNode(shapeVJoint, jointShapeList);
            node.addChild(jointVGLNode);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VGLNode getPhysicalHumanDebugVisualisation(PhysicalHumanoid ph, ArrayList<GLRenderObject> renderStates) {
        VJoint phVJoint = new VJoint("Physical Humanoid");
        GLRenderList shapeList = new GLRenderList(0);
        if (renderStates != null) {
            GLShape glsShape = new GLShape("states");
            for (GLRenderObject state : renderStates) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(phVJoint.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        PhysicalHumanVGLNode theVGLNode = new PhysicalHumanVGLNode(ph, phVJoint, shapeList);
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            if (ph.getRootSegment() != null) {
                theVGLNode.addChild(PhysicsDebugVisualisations.getRigidBodyDebugVisualisation(ph.getRootSegment().box, renderStates, true));
            }
            for (PhysicalSegment ps : ph.getSegments()) {
                VGLNode child = PhysicsDebugVisualisations.getRigidBodyDebugVisualisation(ps.box, renderStates, true);
                if (ps.startJoint == null || ps.startJoint.getType() == JointType.FIXED) continue;
                float[] jointOffset = new float[3];
                float[] pos = new float[3];
                float[] rot = new float[4];
                ps.box.getTranslation(pos);
                ps.box.getRotation(rot);
                ps.startJoint.getAnchor(jointOffset);
                Vec3f.sub((float[])jointOffset, (float[])pos);
                Quat4f.inverse((float[])rot);
                Quat4f.transformVec3f((float[])rot, (float[])jointOffset);
                GLShape jointShape = new GLShape();
                jointShape.addGLState((GLRenderObject)new NoTexture2DState());
                jointShape.addGLState((GLRenderObject)new GLFill());
                GLMaterial m = new GLMaterial();
                float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] diffuse = new float[4];
                switch (ps.startJoint.getType()) {
                    case HINGE: {
                        jointShape.addGLGeometry((GLRenderObject)new DiscGeometry(0.01f, 0.03f, 0.03f, 10, 10));
                        Vec3f.set((float[])diffuse, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case UNIVERSAL: {
                        jointShape.addGLGeometry((GLRenderObject)new BoxGeometry(0.01f, 0.01f, 0.01f));
                        Vec3f.set((float[])diffuse, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case BALL: {
                        jointShape.addGLGeometry((GLRenderObject)new SphereGeometry(0.03f, 10, 10));
                        Vec3f.set((float[])diffuse, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                }
                float[] emission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                float[] specular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                m.setAmbientColor(ambient);
                m.setDiffuseColor(diffuse);
                m.setEmissionColor(emission);
                m.setSpecularColor(specular);
                m.setGLShader(new GLShader("simplePhongShader", new String[0]));
                jointShape.addGLState((GLRenderObject)m);
                VJoint shapeVJoint = new VJoint("joint");
                shapeVJoint.setTranslation(jointOffset);
                GLRenderList jointShapeList = new GLRenderList(1);
                jointShapeList.add((GLRenderObject)jointShape);
                jointShape.linkToTransformMatrix(shapeVJoint.getGlobalMatrix());
                VGLNode jointVGLNode = new VGLNode(shapeVJoint, jointShapeList);
                child.addChild(jointVGLNode);
                theVGLNode.addChild(child);
            }
        }
        theVGLNode.addChild(PhysicsDebugVisualisations.getPHCOMDebugVisualisation(ph));
        return theVGLNode;
    }

    public static VGLNode getPHCOMDebugVisualisation(PhysicalHumanoid ph) {
        float[] color = new float[]{0.8f, 0.8f, 0.0f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(color);
        material.setDiffuseColor(color);
        material.setSpecularColor(color);
        material.setAmbientColor(color);
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLFill());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        color = new float[]{0.8f, 0.0f, 0.8f, 1.0f};
        material = new GLMaterial();
        material.setEmissionColor(color);
        material.setDiffuseColor(color);
        material.setSpecularColor(color);
        material.setAmbientColor(color);
        material.setGLShader(new GLShader("simplePhongShader", new String[0]));
        ArrayList<GLRenderObject> renderStatesOffset = new ArrayList<GLRenderObject>();
        renderStatesOffset.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLFill());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return PhysicsDebugVisualisations.getPHCOMDebugVisualisation(ph, renderStates, renderStatesOffset);
    }

    public static VGLNode getPHCOMDebugVisualisation(PhysicalHumanoid ph, ArrayList<GLRenderObject> renderStates, ArrayList<GLRenderObject> renderStatesOffset) {
        VJoint comVJoint = new VJoint("COM");
        GLRenderList shapeList = new GLRenderList(1);
        if (renderStates != null) {
            GLShape glsShape = new GLShape("states");
            for (GLRenderObject state : renderStates) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(comVJoint.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        GLShape comShape = new GLShape("COM");
        Object geometry = new COMGeometry(ph, 0.02f, 8, 8);
        comShape.addGLGeometry((GLRenderObject)geometry);
        comShape.linkToTransformMatrix(comVJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)comShape);
        if (renderStatesOffset != null) {
            GLShape glsShape = new GLShape("states");
            for (GLRenderObject state : renderStatesOffset) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(comVJoint.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        GLShape comOffShape = new GLShape("COM");
        geometry = new COMOffsetGeometry(ph, 0.02f, 8, 8);
        comOffShape.addGLGeometry((GLRenderObject)geometry);
        comOffShape.linkToTransformMatrix(comVJoint.getGlobalMatrix());
        shapeList.add((GLRenderObject)comOffShape);
        VGLNode theVGLNode = new VGLNode(comVJoint, shapeList);
        return theVGLNode;
    }

    static {
        GLShaderProgramLoader.addShaderDirectory((String)"");
    }
}

