/*
 * Decompiled with CFR 0.152.
 */
package hmi.debug.physics;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.math.Vec3f;
import hmi.physics.PhysicalHumanoid;
import hmi.physics.PhysicsSync;

public class COMGeometry
implements GLRenderObject {
    float radius = 5.0f;
    int numSlices = 32;
    int numStacks = 16;
    float drho;
    float dtheta;
    float ds;
    float dt;
    int sphereList;
    PhysicalHumanoid pHuman = null;
    private float[] CoM = new float[3];
    private float[] CoMDiff = new float[3];

    public COMGeometry(PhysicalHumanoid ph, float radius, int numSlices, int numStacks) {
        this.pHuman = ph;
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
        this.drho = (float)Math.PI / (float)numStacks;
        this.dtheta = (float)Math.PI * 2 / (float)numSlices;
        this.ds = 1.0f / (float)numSlices;
        this.dt = 1.0f / (float)numStacks;
    }

    public void glInit(GLRenderContext gl) {
        this.sphereList = gl.glGenLists(1);
        gl.glNewList(this.sphereList, 4864);
        this.render(gl);
        gl.glEndList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glRender(GLRenderContext gl) {
        Object object = PhysicsSync.getSync();
        synchronized (object) {
            Vec3f.set((float[])this.CoM, (float[])this.pHuman.getCOM());
            Vec3f.set((float[])this.CoMDiff, (float[])this.pHuman.getCOMDiff());
        }
        gl.glPushMatrix();
        gl.glTranslatef(this.CoM[0], this.CoM[1], this.CoM[2]);
        this.render(gl);
        if (Vec3f.length((float[])this.CoMDiff) > 0.0f) {
            gl.glBegin(1);
            gl.glVertex3f(0.0f, 0.0f, 0.0f);
            gl.glVertex3f(this.CoMDiff[0], this.CoMDiff[1], this.CoMDiff[2]);
            gl.glEnd();
        }
        gl.glPopMatrix();
    }

    private void render(GLRenderContext gl) {
        float t = 1.0f;
        float s = 0.0f;
        for (int i = 0; i < this.numStacks; ++i) {
            float rho = (float)i * this.drho;
            float srho = (float)Math.sin(rho);
            float crho = (float)Math.cos(rho);
            float srhodrho = (float)Math.sin(rho + this.drho);
            float crhodrho = (float)Math.cos(rho + this.drho);
            gl.glBegin(5);
            s = 0.0f;
            for (int j = 0; j <= this.numSlices; ++j) {
                float theta = j == this.numSlices ? 0.0f : (float)j * this.dtheta;
                float stheta = (float)(-Math.sin(theta));
                float ctheta = (float)Math.cos(theta);
                float x = stheta * srho;
                float y = ctheta * srho;
                float z = crho;
                gl.glTexCoord2f(s, t);
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(x * this.radius, y * this.radius, z * this.radius);
                x = stheta * srhodrho;
                y = ctheta * srhodrho;
                z = crhodrho;
                gl.glTexCoord2f(s, t - this.dt);
                s += this.ds;
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(x * this.radius, y * this.radius, z * this.radius);
            }
            gl.glEnd();
            t -= this.dt;
        }
    }
}

