/*
 * Decompiled with CFR 0.152.
 */
package hmi.debug.animation;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.geometry.BoxGeometry;
import hmi.graphics.opengl.geometry.SphereGeometry;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLLine;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import java.util.ArrayList;

public final class VJointDebugVisualisations {
    private VJointDebugVisualisations() {
    }

    public static VGLNode getColoredShapeDebugVisualisation(VJoint master, String type) {
        float[] grey = new float[]{0.4f, 0.4f, 0.7f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(grey);
        material.setDiffuseColor(grey);
        material.setSpecularColor(grey);
        material.setAmbientColor(grey);
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return VJointDebugVisualisations.getColoredShapeDebugVisualisation(master, type, renderStates, 1.0f);
    }

    public static VGLNode getColoredShapeDebugVisualisation(VJoint master, String type, ArrayList<GLRenderObject> renderStates, float size) {
        GLShape glsShape;
        GLRenderList shapeList = new GLRenderList(1);
        VJoint slaveRoot = master.slaveCopy("slave-" + master.getId());
        float factor = size;
        if (master.getSid() != null && master.getSid().equals("HumanoidRoot")) {
            factor = 2.0f * size;
        }
        if (renderStates != null) {
            glsShape = new GLShape("states");
            for (GLRenderObject state : renderStates) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        glsShape = new GLShape("shape");
        SphereGeometry geometry = null;
        if (type.equals("sphere")) {
            geometry = new SphereGeometry(factor * 0.01f, 4, 4);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        if (type.equals("box")) {
            geometry = new BoxGeometry(factor * 0.01f, factor * 0.01f, factor * 0.01f);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        if (type.equals("axis-cross")) {
            float[] red = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
            float[] green = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
            float[] blue = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            float[] white = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            GLMaterial material = new GLMaterial();
            material.setEmissionColor(white);
            material.setDiffuseColor(white);
            material.setSpecularColor(white);
            material.setAmbientColor(white);
            geometry = new SphereGeometry(factor * 0.002f, 4, 4);
            glsShape.addGLState((GLRenderObject)material);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
            material = new GLMaterial();
            material.setEmissionColor(red);
            material.setDiffuseColor(red);
            material.setSpecularColor(red);
            material.setAmbientColor(red);
            geometry = new BoxGeometry(new float[]{factor * 0.01f, factor * 0.001f, factor * 0.001f}, new float[]{factor * 0.01f, 0.0f, 0.0f});
            glsShape = new GLShape("shape");
            glsShape.addGLState((GLRenderObject)material);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
            material = new GLMaterial();
            material.setEmissionColor(green);
            material.setDiffuseColor(green);
            material.setSpecularColor(green);
            material.setAmbientColor(green);
            geometry = new BoxGeometry(new float[]{factor * 0.001f, factor * 0.01f, factor * 0.001f}, new float[]{0.0f, factor * 0.01f, 0.0f});
            glsShape = new GLShape("shape");
            glsShape.addGLState((GLRenderObject)material);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
            material = new GLMaterial();
            material.setEmissionColor(blue);
            material.setDiffuseColor(blue);
            material.setSpecularColor(blue);
            material.setAmbientColor(blue);
            geometry = new BoxGeometry(new float[]{factor * 0.001f, factor * 0.001f, factor * 0.01f}, new float[]{0.0f, 0.0f, factor * 0.01f});
            glsShape = new GLShape("shape");
            glsShape.addGLState((GLRenderObject)material);
            glsShape.addGLGeometry((GLRenderObject)geometry);
            glsShape.linkToTransformMatrix(slaveRoot.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        VGLNode theVGLNode = new VGLNode(slaveRoot, shapeList);
        return theVGLNode;
    }

    public static VGLNode getColoredShapeDebugVisualisationTree(VJoint master, String type) {
        float[] grey = new float[]{0.4f, 0.4f, 0.7f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(grey);
        material.setDiffuseColor(grey);
        material.setSpecularColor(grey);
        material.setAmbientColor(grey);
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return VJointDebugVisualisations.getColoredShapeDebugVisualisationTree(master, type, renderStates, 1.0f);
    }

    public static VGLNode getColoredShapeDebugVisualisationTree(VJoint master, String type, ArrayList<GLRenderObject> renderStates, float size) {
        VGLNode theVGLNode = VJointDebugVisualisations.getColoredShapeDebugVisualisation(master, type, renderStates, size);
        for (VJoint child : master.getChildren()) {
            VGLNode vglChild = VJointDebugVisualisations.getColoredShapeDebugVisualisationTree(child, type, null, size);
            theVGLNode.addChild(vglChild);
        }
        return theVGLNode;
    }
}

