/*
 * Decompiled with CFR 0.152.
 */
package hmi.debug.animation;

import hmi.animation.VJoint;
import hmi.debug.animation.GLProcAnimGeometry;
import hmi.elckerlyc.animationengine.procanimation.EndEffector;
import hmi.elckerlyc.animationengine.procanimation.ProcAnimationMU;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLLine;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.opengl.state.NoTexture2DState;
import java.util.ArrayList;

public final class ProcAnimationDebugVisualisations {
    private ProcAnimationDebugVisualisations() {
    }

    public static VGLNode getStaticProcAnimationDebugVisualisation(ProcAnimationMU procAnim, VJoint humanoidRoot, VJoint worldRenderRoot, VJoint avatarRenderRoot) {
        float[] pink = new float[]{0.7f, 0.4f, 0.4f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(pink);
        material.setDiffuseColor(pink);
        material.setSpecularColor(pink);
        material.setAmbientColor(pink);
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        VGLNode theVGLNode = new VGLNode(procAnim.id + "_debugviz");
        for (EndEffector eff : procAnim.getAllEndEffectors()) {
            theVGLNode.addChild(ProcAnimationDebugVisualisations.getStaticEndEffectorDebugVisualisation(eff, humanoidRoot, worldRenderRoot, "sphere", renderStates, 1.0f));
        }
        return theVGLNode;
    }

    public static VGLNode getStaticEndEffectorDebugVisualisation(ProcAnimationMU procAnim, String target, VJoint humanoidRoot, VJoint worldRenderRoot, VJoint avatarRenderRoot) {
        float[] pink = new float[]{0.7f, 0.4f, 0.4f, 1.0f};
        GLMaterial material = new GLMaterial();
        material.setEmissionColor(pink);
        material.setDiffuseColor(pink);
        material.setSpecularColor(pink);
        material.setAmbientColor(pink);
        ArrayList<GLRenderObject> renderStates = new ArrayList<GLRenderObject>();
        renderStates.add((GLRenderObject)material);
        renderStates.add((GLRenderObject)new GLLine());
        renderStates.add((GLRenderObject)new NoTexture2DState());
        return ProcAnimationDebugVisualisations.getStaticEndEffectorDebugVisualisation(procAnim, target, humanoidRoot, worldRenderRoot, avatarRenderRoot, "sphere", renderStates, 1.0f);
    }

    public static VGLNode getStaticEndEffectorDebugVisualisation(ProcAnimationMU procAnim, String target, VJoint humanoidRoot, VJoint worldRenderRoot, VJoint avatarRenderRoot, String type, ArrayList<GLRenderObject> renderStates, float factor) {
        EndEffector eff = procAnim.getEndEffector(target);
        return ProcAnimationDebugVisualisations.getStaticEndEffectorDebugVisualisation(eff, humanoidRoot, worldRenderRoot, type, renderStates, factor);
    }

    public static VGLNode getStaticEndEffectorDebugVisualisation(EndEffector eff, VJoint humanoidRoot, VJoint worldRenderRoot, String type, ArrayList<GLRenderObject> renderStates, float factor) {
        String target = eff.getTarget();
        GLRenderList shapeList = new GLRenderList(1);
        VJoint eeffVJ = new VJoint("End effector");
        GLShape glsShape = null;
        GLProcAnimGeometry geometry = null;
        if (eff.isLocal()) {
            float[] pos = new float[3];
            String startJointName = "";
            if (target.equals("r_wrist")) {
                startJointName = "r_shoulder";
            }
            if (target.equals("l_wrist")) {
                startJointName = "l_shoulder";
            }
            if (target.equals("r_ankle")) {
                startJointName = "r_hip";
            }
            if (target.equals("l_ankle")) {
                startJointName = "l_hip";
            }
            if (target.equals("HumanoidRoot")) {
                startJointName = "HumanoidRoot";
            }
            if (target.equals("root")) {
                startJointName = "HumanoidRoot";
            }
            humanoidRoot.getPart(startJointName).getTranslation(pos);
            VJoint offset = humanoidRoot.getPart(startJointName + "-trans");
            if (offset == null) {
                offset = new VJoint(startJointName + "-trans");
                offset.setTranslation(pos);
                humanoidRoot.getPart(startJointName).getParent().addChild(offset);
            }
            VJoint jRender = humanoidRoot.slaveCopyTree("slave-");
            eeffVJ = jRender.getPart(startJointName + "-trans");
            worldRenderRoot.addChild(jRender);
        }
        if (renderStates != null) {
            glsShape = new GLShape("states");
            for (GLRenderObject state : renderStates) {
                glsShape.addGLGeometry(state);
            }
            glsShape.linkToTransformMatrix(eeffVJ.getGlobalMatrix());
            shapeList.add((GLRenderObject)glsShape);
        }
        glsShape = new GLShape("shape");
        geometry = new GLProcAnimGeometry(eff, factor);
        glsShape.addGLGeometry((GLRenderObject)geometry);
        glsShape.linkToTransformMatrix(eeffVJ.getGlobalMatrix());
        shapeList.add((GLRenderObject)glsShape);
        VGLNode theVGLNode = new VGLNode(eeffVJ, shapeList);
        return theVGLNode;
    }
}

