/*
 * Decompiled with CFR 0.152.
 */
package hmi.debug.animation;

import hmi.elckerlyc.animationengine.procanimation.EndEffector;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class GLProcAnimGeometry
implements GLRenderObject {
    static final int NUM_SHAPES = 75;
    float drho;
    float dtheta;
    float ds;
    float dt;
    float radius = 1.0f;
    int numSlices = 4;
    int numStacks = 4;
    int sphereList;
    EndEffector eff = null;

    public GLProcAnimGeometry(EndEffector e, float factor) {
        this.eff = e;
        this.numSlices = 4;
        this.numStacks = 4;
        this.radius = factor * 0.01f;
        this.drho = (float)Math.PI / (float)this.numStacks;
        this.dtheta = (float)Math.PI * 2 / (float)this.numSlices;
        this.ds = 1.0f / (float)this.numSlices;
        this.dt = 1.0f / (float)this.numStacks;
    }

    public void glInit(GLRenderContext gl) {
        this.sphereList = gl.glGenLists(1);
        gl.glNewList(this.sphereList, 4864);
        this.render(gl);
        gl.glEndList();
    }

    public void glRender(GLRenderContext gl) {
        this.render(gl);
    }

    private void render(GLRenderContext gl) {
        for (int i = 0; i < 75; ++i) {
            float[] pos = new float[3];
            this.eff.evaluateTrans(pos, (double)((float)(i + 1) / 75.0f));
            this.renderOneStep(gl, pos);
        }
    }

    private void renderOneStep(GLRenderContext gl, float[] offset) {
        float t = 1.0f;
        float s = 0.0f;
        for (int i = 0; i < this.numStacks; ++i) {
            float rho = (float)i * this.drho;
            float srho = (float)Math.sin(rho);
            float crho = (float)Math.cos(rho);
            float srhodrho = (float)Math.sin(rho + this.drho);
            float crhodrho = (float)Math.cos(rho + this.drho);
            gl.glBegin(5);
            s = 0.0f;
            for (int j = 0; j <= this.numSlices; ++j) {
                float theta = j == this.numSlices ? 0.0f : (float)j * this.dtheta;
                float stheta = (float)(-Math.sin(theta));
                float ctheta = (float)Math.cos(theta);
                float x = stheta * srho;
                float y = ctheta * srho;
                float z = crho;
                gl.glTexCoord2f(s, t);
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(offset[0] + x * this.radius, offset[1] + y * this.radius, offset[2] + z * this.radius);
                x = stheta * srhodrho;
                y = ctheta * srhodrho;
                z = crhodrho;
                gl.glTexCoord2f(s, t - this.dt);
                s += this.ds;
                gl.glNormal3f(x, y, z);
                gl.glVertex3f(offset[0] + x * this.radius, offset[1] + y * this.radius, offset[2] + z * this.radius);
            }
            gl.glEnd();
            t -= this.dt;
        }
    }
}

