/*
 * Decompiled with CFR 0.152.
 */
package hmi.bmlt;

import hmi.bml.Behaviour;
import hmi.bmlt.BMLTParameter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public abstract class BMLTBehaviour
extends Behaviour {
    private static final String BMLTNAMESPACE = "http://hmi.ewi.utwente.nl/bmlt";
    protected HashMap<String, BMLTParameter> parameters = new HashMap();

    public String getNamespace() {
        return BMLTNAMESPACE;
    }

    @Override
    public String getStringParameterValue(String name) {
        return this.parameters.get((Object)name).value;
    }

    @Override
    public boolean specifiesParameter(String name) {
        return this.parameters.get(name) != null;
    }

    @Override
    public float getFloatParameterValue(String name) {
        return Float.parseFloat(this.parameters.get((Object)name).value);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        BMLTParameter p = this.parameters.get(name);
        if (p != null) {
            return p.value.equals(value);
        }
        return false;
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(BMLTParameter.xmlTag())) {
                BMLTParameter param = new BMLTParameter();
                param.readXML(tokenizer);
                this.parameters.put(param.name, param);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }
}

