/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml.parser;

import hmi.bml.BMLElement;
import hmi.bml.Behaviour;
import hmi.bml.BehaviourBlock;
import hmi.bml.MissingSyncPointException;
import hmi.bml.Sync;
import hmi.bml.SyncPoint;
import hmi.bml.Synchronize;
import hmi.bml.parser.Breadcrumb;
import hmi.bml.parser.Constraint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class BMLParser {
    private ArrayList<BehaviourBlock> bbs;
    private HashMap<String, BMLElement> BMLElementsById;
    private ArrayList<Constraint> constraints;
    private Stack<String> behaviourStack = new Stack();

    public BMLParser() {
        this.bbs = new ArrayList();
        this.BMLElementsById = new HashMap();
        this.constraints = new ArrayList();
    }

    public void clear() {
        this.bbs.clear();
        this.BMLElementsById.clear();
        this.constraints.clear();
    }

    public void addBehaviourBlock(BehaviourBlock bb) {
        bb.registerElementsById(this);
        this.constructConstraints(bb);
        this.bbs.add(bb);
        System.out.println("List of constraints: ");
        for (Constraint constraint : this.constraints) {
            System.out.println("\t" + constraint);
        }
    }

    private void constructConstraints(BehaviourBlock bb) {
        bb.constructConstraints(this);
        ArrayList<Constraint> cNewList = new ArrayList<Constraint>();
        double relOffset = 0.0;
        for (Constraint cOld : this.constraints) {
            boolean merged = false;
            Constraint cMerge = null;
            SyncPoint cSyncOld = null;
            block1: for (SyncPoint syncOld : cOld.getTargets()) {
                for (Constraint cNew : cNewList) {
                    for (SyncPoint syncNew : cNew.getTargets()) {
                        if (!syncOld.equalsPoint(syncNew)) continue;
                        relOffset = syncNew.getOffset() - syncOld.getOffset();
                        merged = true;
                        cMerge = cNew;
                        cSyncOld = syncOld;
                        break;
                    }
                    if (!merged) continue;
                    continue block1;
                }
            }
            if (merged) {
                for (SyncPoint syncOld : cOld.getTargets()) {
                    if (syncOld == cSyncOld) continue;
                    SyncPoint sNew = new SyncPoint(syncOld);
                    sNew.offset = (float)((double)sNew.offset + relOffset);
                    cMerge.addTarget(sNew);
                    sNew.setConstraint(cMerge);
                }
            }
            if (merged) continue;
            cNewList.add(cOld);
        }
        this.constraints = cNewList;
    }

    public void constructConstraints(String bbId, Behaviour behaviour) {
        ArrayList<SyncPoint> syncPoints = behaviour.getSyncPoints();
        for (SyncPoint syncPoint : syncPoints) {
            String ref = syncPoint.getRefString();
            if (ref == "") continue;
            try {
                SyncPoint foreignSyncPoint = syncPoint.getForeignSyncPoint(bbId, this);
                this.constructConstraint(syncPoint, foreignSyncPoint);
            }
            catch (MissingSyncPointException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void constructConstraints(String bbId, Synchronize synchronize) {
        SyncPoint synchronizeRef = new SyncPoint(synchronize.getRef());
        SyncPoint left = synchronizeRef.getForeignSyncPoint(bbId, this);
        ArrayList<Sync> syncs = synchronize.getSyncs();
        for (Sync sync : syncs) {
            SyncPoint syncRef = new SyncPoint(sync.ref);
            SyncPoint right = syncRef.getForeignSyncPoint(bbId, this);
            this.constructConstraint(left, right);
        }
    }

    public void constructConstraint(SyncPoint left, SyncPoint right) {
        if (right.inConstraint() && left.inConstraint()) {
            Constraint masterConstraint = left.getConstraint();
            Constraint slaveConstraint = right.getConstraint();
            ArrayList<SyncPoint> targets = slaveConstraint.getTargets();
            for (SyncPoint target : targets) {
                target.setConstraint(masterConstraint);
                masterConstraint.addTarget(target);
            }
            this.constraints.remove(slaveConstraint);
        } else if (right.inConstraint()) {
            Constraint constraint = right.getConstraint();
            constraint.addTarget(left);
            left.setConstraint(constraint);
        } else if (left.inConstraint()) {
            Constraint constraint = left.getConstraint();
            constraint.addTarget(right);
            right.setConstraint(constraint);
        } else {
            Constraint constraint = new Constraint(left, right);
            left.setConstraint(constraint);
            right.setConstraint(constraint);
            this.constraints.add(constraint);
        }
    }

    public void doSchedule() {
        this.schedule();
    }

    private void registerElementsById() {
        Iterator<BehaviourBlock> bbi = this.bbs.iterator();
        while (bbi.hasNext()) {
            bbi.next().registerElementsById(this);
        }
    }

    private void schedule() {
        Iterator<BehaviourBlock> bbi = this.bbs.iterator();
        while (bbi.hasNext()) {
            bbi.next().schedule(this);
        }
    }

    public void schedule(Behaviour behaviour) {
        if (this.behaviourStack.contains(behaviour.fullId)) {
            System.err.println("cycle detected (" + this.behaviourStack.toString() + " & " + behaviour.fullId + "), aborting behaviour schedule");
            return;
        }
        this.behaviourStack.add(behaviour.fullId);
        this.behaviourStack.pop();
    }

    private void handleSyncPoint(Behaviour behaviour, SyncPoint syncPoint, String value) {
        Breadcrumb bc = new Breadcrumb(value);
        String syncId = bc.remove();
        String sourceId = bc.toString();
        Behaviour bmlElement = (Behaviour)this.getBMLElementById(sourceId);
        if (bmlElement == null) {
            return;
        }
        bmlElement.schedule(this);
    }

    public void registerBMLElement(BMLElement element, Breadcrumb breadcrumb) {
        if (element.id == null) {
            return;
        }
        String fullId = "";
        if (breadcrumb.toString().length() > 0) {
            fullId = breadcrumb.toString() + ':';
        }
        element.fullId = fullId = fullId + element.id;
        element.bmlId = breadcrumb.toString();
        System.out.println("Registering " + ((Object)((Object)element)).getClass().toString() + " (" + fullId + ")");
        if (this.BMLElementsById.containsKey(fullId)) {
            System.err.println("fullId " + fullId + " not unique");
        } else {
            this.BMLElementsById.put(fullId, element);
        }
    }

    public BMLElement getBMLElementById(String id) {
        BMLElement retval = this.BMLElementsById.get(id);
        return retval;
    }

    public void outputTimeline() {
        Iterator<BehaviourBlock> bbi = this.bbs.iterator();
        while (bbi.hasNext()) {
            bbi.next().outputTimeline();
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public ArrayList<Behaviour> getBehaviours() {
        ArrayList<Behaviour> behs = new ArrayList<Behaviour>();
        for (BehaviourBlock bb : this.bbs) {
            behs.addAll(bb.behaviours);
        }
        return behs;
    }

    public ArrayList<BehaviourBlock> getBehaviourBlocks() {
        return this.bbs;
    }
}

