/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.InvalidSyncRefException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyncRef {
    public String bbId;
    public String sourceId;
    public String syncId;
    public int iteration = -1;
    public float offset = 0.0f;

    public SyncRef(String syncRef) {
        String bbIdRegex = "[a-zA-Z][a-zA-Z0-9\\-_]*";
        String sourceIdRegex = "[a-zA-Z][a-zA-Z0-9\\-_]*";
        String syncIdRegex = "[a-zA-Z][a-zA-Z0-9_]*";
        String iterationRegex = "[0-9]+";
        String plusminRegex = "(?:\\+|-)";
        String floatRegex = "([0-9]+)(.[0-9]+)?";
        Pattern pattern = Pattern.compile("(?:(" + bbIdRegex + "):)?(" + sourceIdRegex + "):(" + syncIdRegex + ")(?::(" + iterationRegex + "))?(?:(" + plusminRegex + floatRegex + "))?|(" + floatRegex + ")");
        Matcher matcher = pattern.matcher(syncRef);
        matcher.matches();
        try {
            if (matcher.group(8) == null && matcher.group(9) == null) {
                if (matcher.group(1) != null) {
                    this.bbId = matcher.group(1);
                }
                this.sourceId = matcher.group(2);
                this.syncId = matcher.group(3);
                if (matcher.group(4) != null) {
                    this.iteration = Integer.parseInt(matcher.group(4));
                }
                if (matcher.group(5) != null) {
                    this.offset = Float.parseFloat(matcher.group(5));
                }
            } else {
                this.sourceId = "bml";
                this.syncId = "start";
                this.offset = Float.parseFloat(matcher.group(8));
            }
        }
        catch (IllegalStateException e) {
            throw new InvalidSyncRefException(syncRef + " does not match " + pattern);
        }
    }

    public boolean equals(SyncRef s) {
        return s.offset == this.offset && s.sourceId.equals(this.sourceId) && s.syncId.equals(this.syncId) && s.iteration == this.iteration;
    }

    public String toString() {
        String s = this.sourceId + ":" + this.syncId;
        if (this.iteration != -1) {
            s = s + ":" + this.iteration;
        }
        if (this.offset != 0.0f) {
            if (this.offset > 0.0f) {
                s = s + '+';
            }
            s = s + this.offset;
        }
        return s;
    }
}

