/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.Behaviour;
import hmi.bml.MissingSyncPointException;
import hmi.bml.SyncRef;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Constraint;

public class SyncPoint {
    private String name;
    private int iteration = -1;
    public float offset;
    private SyncRef ref;
    private Behaviour behavior;
    private Constraint constraint;

    public SyncPoint(Behaviour behavior, String name) {
        this.behavior = behavior;
        this.name = name;
    }

    public SyncPoint(SyncPoint s) {
        this.name = s.name;
        this.iteration = s.iteration;
        this.offset = s.offset;
        this.ref = s.ref;
        this.behavior = s.behavior;
        this.constraint = s.constraint;
    }

    public SyncPoint(Behaviour behavior, String name, int iteration) {
        this(behavior, name);
        this.iteration = iteration;
    }

    public boolean equalsPoint(SyncPoint p) {
        String[] str;
        if (p.behavior == null && this.behavior == null ? (str = p.name.split(":")).length != 2 || str[0].equals("bml") : p.behavior != this.behavior) {
            return false;
        }
        return p.name.equals(this.name) && p.iteration == this.iteration;
    }

    public SyncPoint(SyncRef ref) {
        this.ref = ref;
    }

    public int getIteration() {
        return this.iteration;
    }

    public String getName() {
        return this.name;
    }

    public void setRefString(String ref) {
        this.ref = new SyncRef(ref);
    }

    public SyncRef getRef() {
        return this.ref;
    }

    public String getRefString() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return "";
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        if (this.behavior != null) {
            retval.append(this.behavior.fullId);
        }
        retval.append(":" + this.name);
        if (this.iteration != -1) {
            retval.append(":" + this.iteration);
        }
        if (this.offset != 0.0f) {
            retval.append(this.offset > 0.0f ? Character.valueOf('+') : "");
            retval.append(this.offset);
        }
        return retval.toString();
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean inConstraint() {
        return this.constraint != null;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public SyncPoint getForeignSyncPoint(String bbId, BMLParser scheduler) throws MissingSyncPointException {
        Behaviour behaviour = null;
        if (!this.ref.sourceId.equals("bml")) {
            behaviour = (Behaviour)scheduler.getBMLElementById((this.ref.bbId == null ? bbId : this.ref.bbId) + ':' + this.ref.sourceId);
        }
        if (behaviour == null) {
            SyncPoint s;
            if (this.ref.syncId.equals("")) {
                s = new SyncPoint(null, "start");
                s.offset = this.ref.offset;
            } else {
                s = new SyncPoint(null, this.ref.sourceId + ":" + this.ref.syncId);
                s.offset = this.ref.offset;
            }
            return s;
        }
        for (SyncPoint syncPoint : behaviour.getSyncPoints()) {
            if (!syncPoint.name.equals(this.ref.syncId) || syncPoint.iteration != this.ref.iteration && this.ref.iteration != -1 || syncPoint.offset != this.ref.offset) continue;
            return syncPoint;
        }
        SyncPoint s = new SyncPoint(behaviour, this.ref.syncId);
        s.offset = this.ref.offset;
        behaviour.addSyncPoint(s);
        return s;
    }

    public Behaviour getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behaviour b) {
        this.behavior = b;
    }

    public float getOffset() {
        return this.offset;
    }
}

