/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.Behaviour;
import hmi.bml.Sync;
import hmi.bml.SyncPoint;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Breadcrumb;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SpeechBehaviour
extends Behaviour {
    protected String content;
    private ArrayList<Sync> syncs = new ArrayList();
    private static final String XMLTAG = "speech";

    public SpeechBehaviour() {
    }

    @Override
    public String getStringParameterValue(String name) {
        return null;
    }

    @Override
    public float getFloatParameterValue(String name) {
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        return false;
    }

    public SpeechBehaviour(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.content != null) {
            buf.append(this.content);
        }
        return super.appendContent(buf, fmt);
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (!tokenizer.atETag()) {
            if (tokenizer.atSTag("text")) {
                SpeechText text = new SpeechText();
                text.readXML(tokenizer);
                this.content = text.content;
                this.syncs = text.syncs;
                for (Sync sync : this.syncs) {
                    this.addSyncPoint(new SyncPoint(this, sync.id));
                }
            } else {
                super.decodeContent(tokenizer);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public void registerElementsById(BMLParser scheduler, Breadcrumb breadcrumb) {
        scheduler.registerBMLElement(this, breadcrumb);
        breadcrumb.add(this.id);
        breadcrumb.remove();
    }

    public String getContent() {
        return this.content;
    }

    class SpeechText
    extends XMLStructureAdapter {
        public String content = "";
        public ArrayList<Sync> syncs = new ArrayList();

        SpeechText() {
        }

        public void decodeContent(XMLTokenizer tokenizer) throws IOException {
            while (!tokenizer.atETag()) {
                if (tokenizer.atSTag("sync")) {
                    Sync s = new Sync();
                    s.readXML(tokenizer);
                    this.content = this.content + s.toString();
                    this.syncs.add(s);
                } else if (tokenizer.atCDSect()) {
                    this.content = this.content + tokenizer.takeCDSect();
                } else if (tokenizer.atCharData()) {
                    this.content = this.content + tokenizer.takeCharData();
                }
                SpeechBehaviour.this.ensureDecodeProgress(tokenizer);
            }
        }

        public String getXMLTag() {
            return "text";
        }
    }
}

