/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.BMLElement;
import hmi.bml.BMLInfo;
import hmi.bml.Behaviour;
import hmi.bml.ConstraintBlock;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Breadcrumb;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RequiredBlock
extends BMLElement {
    public ArrayList<ConstraintBlock> constraintBlocks;
    public ArrayList<Behaviour> behaviours = new ArrayList();
    private static final String XMLTAG = "required";

    public RequiredBlock() {
        this.constraintBlocks = new ArrayList();
    }

    public RequiredBlock(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public boolean decodeAttribute(String attrName, String valCode, XMLTokenizer tokenizer) {
        return super.decodeAttribute(attrName, valCode, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        RequiredBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.behaviours);
        RequiredBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.constraintBlocks);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        if (tag.equals(ConstraintBlock.xmlTag())) {
            this.constraintBlocks.add(new ConstraintBlock(tokenizer));
        }
        for (String str : BMLInfo.behaviourTypes.keySet()) {
            if (!str.equals(tag)) continue;
            Behaviour b = null;
            try {
                b = BMLInfo.behaviourTypes.get(tag).newInstance();
            }
            catch (InstantiationException e) {
                throw new XMLScanException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new XMLScanException(e.getMessage());
            }
            if (b != null) {
                b.readXML(tokenizer);
                if (b.descBehaviour == null) {
                    this.behaviours.add(b);
                    continue;
                }
                this.behaviours.add(b.descBehaviour);
                continue;
            }
            this.ensureDecodeProgress(tokenizer);
        }
        this.ensureDecodeProgress(tokenizer);
    }

    @Override
    public void registerElementsById(BMLParser scheduler, Breadcrumb breadcrumb) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().registerElementsById(scheduler, breadcrumb);
        }
    }

    public void schedule(BMLParser scheduler) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().schedule(scheduler);
        }
    }

    public void constructConstraints(String bbId, BMLParser scheduler) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().constructConstraints(bbId, scheduler);
        }
    }

    public void outputTimeline() {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().outputTimeline();
        }
    }
}

