/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.Behaviour;
import hmi.bml.SyncPoint;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class GestureBehaviour
extends Behaviour {
    private String type;
    private Hand hand;
    private int repetition;
    private String target;
    private String lexeme;
    private boolean dynamic;
    private static final String XMLTAG = "gesture";

    public GestureBehaviour() {
    }

    public GestureBehaviour(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("type")) {
            return this.type.toString().equals(value);
        }
        if (name.equals("hand")) {
            return this.hand.toString().equals(value);
        }
        if (name.equals("lexeme")) {
            return this.lexeme.toString().equals(value);
        }
        if (name.equals("dynamic")) {
            return ("" + this.dynamic).equals(value);
        }
        return false;
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("type")) {
            return this.type.toString();
        }
        if (name.equals("hand")) {
            return this.hand.toString();
        }
        if (name.equals("repetition")) {
            return "" + this.repetition;
        }
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("lexeme")) {
            return this.lexeme;
        }
        if (name.equals("dynamic")) {
            return "" + this.dynamic;
        }
        return null;
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("repetition")) {
            return this.repetition;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("type")) {
            return true;
        }
        if (name.equals("hand")) {
            return true;
        }
        if (name.equals("repetition")) {
            return true;
        }
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("lexeme")) {
            return true;
        }
        return name.equals("dynamic");
    }

    @Override
    public void addDefaultSyncPoints() {
        this.addSyncPoint(new SyncPoint(this, "start"));
        this.addSyncPoint(new SyncPoint(this, "ready"));
        this.addSyncPoint(new SyncPoint(this, "stroke-start"));
        this.addSyncPoint(new SyncPoint(this, "stroke", 1));
        this.addSyncPoint(new SyncPoint(this, "stroke-end"));
        this.addSyncPoint(new SyncPoint(this, "relax"));
        this.addSyncPoint(new SyncPoint(this, "end"));
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type.toString());
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"hand", (String)this.hand.toString());
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"repetition", (int)this.repetition);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"lexeme", (String)this.lexeme);
        GestureBehaviour.appendAttribute((StringBuilder)buf, (String)"dynamic", (boolean)this.dynamic);
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getRequiredAttribute("type", attrMap, tokenizer);
        this.hand = Hand.valueOf(this.getOptionalAttribute("hand", attrMap, Hand.UNSPECIFIED.toString()));
        this.dynamic = this.getOptionalBooleanAttribute("dynamic", attrMap, false);
        this.repetition = this.getOptionalIntAttribute("repetition", attrMap, 1);
        if (this.repetition > 1) {
            for (int i = 1; i < this.repetition; ++i) {
                this.addSyncPoint(new SyncPoint(this, "stroke", i));
            }
        }
        this.target = this.type.equals("POINT") ? this.getRequiredAttribute("target", attrMap, tokenizer) : this.getOptionalAttribute("target", attrMap);
        this.lexeme = this.type.equals("LEXICALIZED") ? this.getRequiredAttribute("lexeme", attrMap, tokenizer) : this.getOptionalAttribute("lexeme", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum Hand {
        LEFT,
        RIGHT,
        BOTH,
        UNSPECIFIED;

    }
}

