/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.Behaviour;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class GazeBehaviour
extends Behaviour {
    private Type type;
    private String target;
    private float offsetAngle;
    private OffsetDirection offsetDirection;
    private String modality = "";
    private boolean dynamic;
    private static final String XMLTAG = "gaze";

    public GazeBehaviour() {
    }

    @Override
    public boolean satisfiesConstraint(String name, String value) {
        if (name.equals("type")) {
            return this.type.toString().equals(value);
        }
        if (name.equals("modality")) {
            return this.modality.toString().equals(value);
        }
        if (name.equals("dynamic")) {
            return ("" + this.dynamic).equals(value);
        }
        return false;
    }

    @Override
    public float getFloatParameterValue(String name) {
        if (name.equals("offsetAngle")) {
            return this.offsetAngle;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found/not a float.");
    }

    @Override
    public String getStringParameterValue(String name) {
        if (name.equals("target")) {
            return this.target;
        }
        if (name.equals("offsetAngle")) {
            return "" + this.offsetAngle;
        }
        if (name.equals("offsetDirection")) {
            return this.offsetDirection.toString();
        }
        if (name.equals("modality")) {
            return this.modality;
        }
        if (name.equals("type")) {
            return this.type.toString();
        }
        if (name.equals("dynamic")) {
            return "" + this.dynamic;
        }
        throw new IllegalArgumentException("Parameter " + name + " not found");
    }

    @Override
    public boolean specifiesParameter(String name) {
        if (name.equals("target")) {
            return true;
        }
        if (name.equals("offsetAngle")) {
            return true;
        }
        if (name.equals("offsetDirection")) {
            return true;
        }
        if (name.equals("modality")) {
            return true;
        }
        if (name.equals("type")) {
            return true;
        }
        return name.equals("dynamic");
    }

    public GazeBehaviour(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf) {
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type.toString());
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"target", (String)this.target);
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetAngle", (float)this.offsetAngle);
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"offsetDirection", (String)this.offsetDirection.toString());
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"modality", (String)this.modality);
        GazeBehaviour.appendAttribute((StringBuilder)buf, (String)"dynamic", (boolean)this.dynamic);
        return super.appendAttributeString(buf);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = Type.valueOf(this.getRequiredAttribute("type", attrMap, tokenizer));
        this.target = this.getOptionalAttribute("target", attrMap);
        this.offsetAngle = this.getOptionalFloatAttribute("offsetAngle", attrMap, 0.0f);
        this.offsetDirection = OffsetDirection.valueOf(this.getOptionalAttribute("offsetDirection", attrMap, OffsetDirection.RIGHT.toString()));
        this.modality = this.getOptionalAttribute("modality", attrMap, "");
        this.dynamic = this.getOptionalBooleanAttribute("dynamic", attrMap, false);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum OffsetDirection {
        RIGHT,
        LEFT,
        UP,
        DOWN,
        UPRIGHT,
        UPLEFT,
        DOWNLEFT,
        DOWNRIGHT,
        POLAR;

    }

    private static enum Type {
        AT,
        AVERT;

    }
}

