/*
 * Decompiled with CFR 0.152.
 */
package hmi.bml;

import hmi.bml.BMLElement;
import hmi.bml.BMLInfo;
import hmi.bml.Behaviour;
import hmi.bml.ConstraintBlock;
import hmi.bml.RequiredBlock;
import hmi.bml.SyncPoint;
import hmi.bml.parser.BMLParser;
import hmi.bml.parser.Breadcrumb;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLScanException;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class BehaviourBlock
extends BMLElement {
    public ArrayList<RequiredBlock> requiredBlocks = new ArrayList();
    public ArrayList<ConstraintBlock> constraintBlocks = new ArrayList();
    public ArrayList<Behaviour> behaviours = new ArrayList();
    private static final String XMLTAG = "bml";

    public BehaviourBlock() {
    }

    public BehaviourBlock(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.requiredBlocks);
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.constraintBlocks);
        BehaviourBlock.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.behaviours);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(RequiredBlock.xmlTag())) {
                this.requiredBlocks.add(new RequiredBlock(tokenizer));
            }
            if (tag.equals(ConstraintBlock.xmlTag())) {
                this.constraintBlocks.add(new ConstraintBlock(tokenizer));
            }
            for (String str : BMLInfo.behaviourTypes.keySet()) {
                if (!str.equals(tag)) continue;
                Behaviour b = null;
                try {
                    b = BMLInfo.behaviourTypes.get(tag).newInstance();
                }
                catch (InstantiationException e) {
                    throw new XMLScanException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new XMLScanException(e.getMessage());
                }
                if (b != null) {
                    b.readXML(tokenizer);
                    if (b.descBehaviour == null) {
                        this.behaviours.add(b);
                        continue;
                    }
                    ArrayList<SyncPoint> removeList = new ArrayList<SyncPoint>();
                    ArrayList<SyncPoint> addList = new ArrayList<SyncPoint>();
                    for (SyncPoint s : b.getSyncPoints()) {
                        boolean add = true;
                        for (SyncPoint sDesc : b.descBehaviour.getSyncPoints()) {
                            if (!s.getName().equals(sDesc.getName())) continue;
                            if (sDesc.getRef() == null) {
                                removeList.add(sDesc);
                                break;
                            }
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        s.setBehavior(b.descBehaviour);
                        addList.add(s);
                    }
                    b.descBehaviour.removeSyncPoints(removeList);
                    b.descBehaviour.addSyncPoints(addList);
                    this.behaviours.add(b.descBehaviour);
                    continue;
                }
                this.ensureDecodeProgress(tokenizer);
            }
            this.ensureDecodeProgress(tokenizer);
        }
    }

    public void registerElementsById(BMLParser scheduler) {
        this.registerElementsById(scheduler, new Breadcrumb());
    }

    @Override
    public void registerElementsById(BMLParser scheduler, Breadcrumb breadcrumb) {
        scheduler.registerBMLElement(this, breadcrumb);
        breadcrumb.add(this.id);
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().registerElementsById(scheduler, breadcrumb);
        }
        Iterator<RequiredBlock> ri = this.requiredBlocks.iterator();
        while (ri.hasNext()) {
            ri.next().registerElementsById(scheduler, breadcrumb);
        }
        breadcrumb.remove();
    }

    public void schedule(BMLParser scheduler) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().schedule(scheduler);
        }
        Iterator<RequiredBlock> ri = this.requiredBlocks.iterator();
        while (ri.hasNext()) {
            ri.next().schedule(scheduler);
        }
    }

    public void constructConstraints(BMLParser scheduler) {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().constructConstraints(this.id, scheduler);
        }
        Iterator<RequiredBlock> ri = this.requiredBlocks.iterator();
        while (ri.hasNext()) {
            ri.next().constructConstraints(this.id, scheduler);
        }
        Iterator<ConstraintBlock> ci = this.constraintBlocks.iterator();
        while (ci.hasNext()) {
            ci.next().constructConstraints(this.id, scheduler);
        }
    }

    public void outputTimeline() {
        Iterator<Behaviour> bi = this.behaviours.iterator();
        while (bi.hasNext()) {
            bi.next().outputTimeline();
        }
        Iterator<RequiredBlock> ri = this.requiredBlocks.iterator();
        while (ri.hasNext()) {
            ri.next().outputTimeline();
        }
    }
}

